<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageSeo;
use App\Models\PageContent;

class SeedGuaranteesPage extends Seeder
{
    public function run()
    {
        // Create the Guarantees page
        $page = Page::create([
            'title' => 'Our Guarantees - Academic Scribe',
            'slug' => 'guarantees',
            'page_type' => 'landing',
            'status' => 'published',
            'template' => 'default',
            'seo_priority' => 85,
            'published_at' => now(),
        ]);

        // Create SEO data
        PageSeo::create([
            'page_id' => $page->id,
            'meta_title' => 'Our Guarantees - 100% Plagiarism-Free, Money-Back, Quality Assured | Academic Scribe',
            'meta_description' => 'Academic Scribe guarantees: 100% plagiarism-free papers, money-back guarantee, unlimited free revisions, on-time delivery, expert writers, and complete confidentiality. Risk-free academic writing service.',
            'meta_keywords' => 'plagiarism-free guarantee, money-back guarantee, quality guarantee, academic writing guarantees, free revisions, on-time delivery guarantee, confidentiality guarantee',
            'canonical_url' => 'https://academicscribe.com/guarantees',
            'robots' => 'index, follow',
            'og_title' => 'Our Quality Guarantees - Risk-Free Academic Writing Service',
            'og_description' => '100% plagiarism-free, money-back guarantee, unlimited revisions, on-time delivery. Get risk-free academic writing help with complete satisfaction guaranteed.',
            'og_image' => 'https://academicscribe.com/images/guarantees-og.jpg',
            'twitter_card' => 'summary_large_image',
            'twitter_title' => 'Academic Scribe Guarantees - Risk-Free Writing Service',
            'twitter_description' => 'Plagiarism-free, money-back, unlimited revisions. Your satisfaction is guaranteed.',
            'structured_data' => [
                'webpage' => [
                    '@context' => 'https://schema.org',
                    '@type' => 'WebPage',
                    'name' => 'Our Guarantees - Academic Scribe',
                    'description' => 'Complete quality guarantees for academic writing services',
                    'url' => 'https://academicscribe.com/guarantees'
                ]
            ]
        ]);

        // Content Block 1: Hero
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'hero',
            'block_key' => 'guarantees_hero',
            'order' => 1,
            'is_active' => true,
            'content' => [
                'title' => 'Our Quality Guarantees',
                'subtitle' => 'Your Success is Our Priority',
                'description' => 'At Academic Scribe, we stand behind our work with <strong>comprehensive guarantees</strong> that ensure your complete satisfaction. Your academic success is our commitment.',
            ]
        ]);

        // Content Block 2: Main Guarantees
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'guarantees_list',
            'block_key' => 'main_guarantees',
            'order' => 2,
            'is_active' => true,
            'content' => [
                'title' => 'Our Core Guarantees',
                'guarantees' => [
                    [
                        'icon' => '🔒',
                        'title' => '100% Plagiarism-Free Guarantee',
                        'description' => 'Every paper is written from scratch with original content. We provide free plagiarism reports with every order.',
                        'features' => [
                            'Original content written from scratch',
                            'Free Turnitin plagiarism report',
                            'Multiple plagiarism detection tools',
                            'Zero tolerance for copied content',
                        ],
                        'link' => '/services/essay-writing',
                        'linkText' => 'Get Original Essays',
                    ],
                    [
                        'icon' => '💰',
                        'title' => 'Money-Back Guarantee',
                        'description' => 'Not satisfied with your paper? Get your money back. We offer full refunds for unsatisfactory work.',
                        'features' => [
                            'Full refund if not satisfied',
                            'Partial refunds for late delivery',
                            'No questions asked policy',
                            'Quick refund processing',
                        ],
                        'link' => '/services/research-papers',
                        'linkText' => 'Risk-Free Research Papers',
                    ],
                    [
                        'icon' => '🔄',
                        'title' => 'Free Unlimited Revisions',
                        'description' => 'We revise your paper until you\'re completely satisfied. Free revisions within 30 days of delivery.',
                        'features' => [
                            'Unlimited revisions for 30 days',
                            'Quick revision turnaround',
                            'No additional charges',
                            'Direct communication with writer',
                        ],
                        'link' => '/services/assignments',
                        'linkText' => 'Get Perfect Assignments',
                    ],
                    [
                        'icon' => '⏰',
                        'title' => 'On-Time Delivery Guarantee',
                        'description' => 'We deliver your paper on time, every time. Late delivery results in automatic compensation.',
                        'features' => [
                            'Guaranteed on-time delivery',
                            'Compensation for late delivery',
                            'Progress tracking available',
                            'Rush orders accepted',
                        ],
                        'link' => '/services/dissertation-writing',
                        'linkText' => 'Timely Dissertation Help',
                    ],
                    [
                        'icon' => '🎓',
                        'title' => 'Expert Writer Guarantee',
                        'description' => 'Your paper is written by qualified experts in your field with advanced degrees and experience.',
                        'features' => [
                            'PhD and Masters level writers',
                            'Subject matter experts',
                            'Native English speakers',
                            'Verified academic credentials',
                        ],
                        'link' => '/services/thesis-proposals',
                        'linkText' => 'Expert Thesis Writing',
                    ],
                    [
                        'icon' => '🔐',
                        'title' => 'Privacy & Confidentiality',
                        'description' => 'Your personal information and order details are kept strictly confidential and secure.',
                        'features' => [
                            'SSL encrypted transactions',
                            'Anonymous communication',
                            'No data sharing with third parties',
                            'Secure payment processing',
                        ],
                        'link' => '/services/case-studies',
                        'linkText' => 'Confidential Case Studies',
                    ],
                ]
            ]
        ]);

        // Content Block 3: Quality Standards
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'quality_standards',
            'block_key' => 'quality_standards',
            'order' => 3,
            'is_active' => true,
            'content' => [
                'title' => 'Our Quality Standards',
                'standards' => [
                    [
                        'title' => 'Academic Writing Standards',
                        'description' => 'All papers meet strict academic writing standards with proper formatting and citations.',
                        'link' => '/services/literature-reviews',
                        'linkText' => 'Professional Literature Reviews',
                    ],
                    [
                        'title' => 'Quality Assurance Process',
                        'description' => 'Multi-step quality check including editing, proofreading, and plagiarism detection.',
                        'link' => '/services/essay-writing',
                        'linkText' => 'Quality Essay Writing',
                    ],
                    [
                        'title' => 'Customer Satisfaction',
                        'description' => '98% customer satisfaction rate with thousands of successful orders completed.',
                        'link' => '/services/research-papers',
                        'linkText' => 'Satisfied Research Clients',
                    ],
                    [
                        'title' => '24/7 Customer Support',
                        'description' => 'Round-the-clock customer support to address any concerns or questions.',
                        'link' => '/services/assignments',
                        'linkText' => 'Supported Assignment Help',
                    ],
                ]
            ]
        ]);

        // Content Block 4: FAQs (ALL 8 FAQs)
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'faqs',
            'block_key' => 'guarantees_faqs',
            'order' => 4,
            'is_active' => true,
            'content' => [
                'title' => 'Frequently Asked Questions About Our Guarantees',
                'faqs' => [
                    [
                        'question' => 'What is your plagiarism-free guarantee for essay writing services?',
                        'answer' => 'Our plagiarism-free guarantee ensures every essay is written from scratch with 100% original content. We provide free Turnitin reports and use multiple plagiarism detection tools to verify originality.',
                        'link' => '/services/essay-writing',
                        'linkText' => 'Learn about our essay writing guarantee',
                    ],
                    [
                        'question' => 'How does your money-back guarantee work for research papers?',
                        'answer' => 'If you\'re not satisfied with your research paper, we offer full refunds. Our money-back guarantee covers quality issues, late delivery, and failure to meet requirements.',
                        'link' => '/services/research-papers',
                        'linkText' => 'Get guaranteed research papers',
                    ],
                    [
                        'question' => 'What does your free revision guarantee include for dissertations?',
                        'answer' => 'Our free revision guarantee includes unlimited revisions for 30 days after delivery. We revise your dissertation until it meets your exact requirements at no extra cost.',
                        'link' => '/services/dissertation-writing',
                        'linkText' => 'Explore dissertation revision guarantee',
                    ],
                    [
                        'question' => 'Do you guarantee on-time delivery for urgent assignments?',
                        'answer' => 'Yes, we guarantee on-time delivery for all assignments, including urgent orders. Late delivery results in automatic compensation or partial refunds.',
                        'link' => '/services/assignments',
                        'linkText' => 'Get timely assignment help',
                    ],
                    [
                        'question' => 'What qualifications do your guaranteed expert writers have?',
                        'answer' => 'Our expert writers hold PhD and Masters degrees in their respective fields. All writers are verified for their academic credentials and writing experience.',
                        'link' => '/services/thesis-proposals',
                        'linkText' => 'Meet our expert thesis writers',
                    ],
                    [
                        'question' => 'How do you guarantee privacy and confidentiality?',
                        'answer' => 'We guarantee complete privacy through SSL encryption, anonymous communication, and strict no-sharing policies. Your personal information is never disclosed to third parties.',
                        'link' => '/services/case-studies',
                        'linkText' => 'Confidential case study writing',
                    ],
                    [
                        'question' => 'What quality standards do you guarantee for literature reviews?',
                        'answer' => 'We guarantee academic writing standards including proper formatting, citations, and thorough research. All literature reviews undergo multi-step quality assurance.',
                        'link' => '/services/literature-reviews',
                        'linkText' => 'Quality literature review guarantee',
                    ],
                    [
                        'question' => 'Do you guarantee customer satisfaction for all services?',
                        'answer' => 'Yes, we guarantee customer satisfaction with a 98% satisfaction rate. We work with you until you\'re completely happy with your paper or provide a full refund.',
                        'link' => '/services',
                        'linkText' => 'Explore all guaranteed services',
                    ],
                ]
            ]
        ]);

        // Content Block 5: Testimonials
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'testimonials',
            'block_key' => 'guarantees_testimonials',
            'order' => 5,
            'is_active' => true,
            'content' => [
                'title' => 'What Our Customers Say About Our Guarantees',
                'testimonials' => [
                    [
                        'quote' => 'The plagiarism-free guarantee gave me confidence. My essay was 100% original with a detailed plagiarism report.',
                        'name' => 'Sarah M.',
                        'service' => 'Essay Writing',
                        'rating' => 5,
                        'link' => '/services/essay-writing',
                    ],
                    [
                        'quote' => 'Money-back guarantee worked perfectly. Got a full refund when the first draft didn\'t meet requirements.',
                        'name' => 'Mike R.',
                        'service' => 'Research Papers',
                        'rating' => 5,
                        'link' => '/services/research-papers',
                    ],
                    [
                        'quote' => 'Free revisions guarantee is amazing. They revised my dissertation 3 times until it was perfect.',
                        'name' => 'Lisa K.',
                        'service' => 'Dissertation',
                        'rating' => 5,
                        'link' => '/services/dissertation-writing',
                    ],
                    [
                        'quote' => 'On-time delivery guarantee saved my grade. Got my assignment 2 hours before the deadline.',
                        'name' => 'John D.',
                        'service' => 'Assignments',
                        'rating' => 5,
                        'link' => '/services/assignments',
                    ],
                    [
                        'quote' => 'Expert writer guarantee delivered. My thesis proposal was written by a PhD in my field.',
                        'name' => 'Emma T.',
                        'service' => 'Thesis Proposal',
                        'rating' => 5,
                        'link' => '/services/thesis-proposals',
                    ],
                    [
                        'quote' => 'Privacy guarantee is real. Complete confidentiality throughout the entire process.',
                        'name' => 'Alex P.',
                        'service' => 'Case Studies',
                        'rating' => 5,
                        'link' => '/services/case-studies',
                    ],
                ]
            ]
        ]);

        // Content Block 6: CTA
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'cta',
            'block_key' => 'guarantees_cta',
            'order' => 6,
            'is_active' => true,
            'content' => [
                'title' => 'Ready to Experience Our Risk-Free Service?',
                'description' => 'Join thousands of satisfied students who trust our <strong>guaranteed academic writing service</strong>. Your success is our commitment.',
                'primaryButtonText' => 'Place Your Order Now',
                'primaryButtonLink' => '/place-order',
                'secondaryButtonText' => 'Contact Support',
                'secondaryButtonLink' => '/contact',
                'bgColor' => 'blue',
            ]
        ]);

        echo "✅ Guarantees page seeded successfully!\n";
        echo "   - Page: {$page->title}\n";
        echo "   - Slug: /{$page->slug}\n";
        echo "   - SEO: Complete\n";
        echo "   - Content Blocks: 6 (Hero, Guarantees, Standards, FAQs, Testimonials, CTA)\n";
        echo "   - Main guarantees: 6 items\n";
        echo "   - Quality standards: 4 items\n";
        echo "   - FAQs: 8 items\n";
        echo "   - Testimonials: 6 items\n";
    }
}

