<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageSeo;
use App\Models\PageContent;

class SeedGuaranteesPageModular extends Seeder
{
    public function run()
    {
        // Delete existing guarantees page if it exists
        $existingPage = Page::where('slug', 'guarantees')->first();
        if ($existingPage) {
            $existingPage->contentBlocks()->delete();
            $existingPage->seo()->delete();
            $existingPage->delete();
        }

        // Create the Guarantees page
        $page = Page::create([
            'title' => 'Our Guarantees - Academic Scribe',
            'slug' => 'guarantees',
            'page_type' => 'landing',
            'status' => 'published',
            'template' => 'default',
            'seo_priority' => 85,
            'published_at' => now(),
        ]);

        // Create SEO data
        PageSeo::create([
            'page_id' => $page->id,
            'meta_title' => 'Quality Guarantees | 100% Plagiarism-Free, Money-Back, Free Revisions | Academic Scribe',
            'meta_description' => 'Quality guarantees for essay writing, research papers, dissertations. 100% plagiarism-free guarantee, money-back guarantee, free unlimited revisions, on-time delivery, expert writers, privacy protection.',
            'meta_keywords' => 'plagiarism-free guarantee, money-back guarantee, free revisions guarantee, on-time delivery guarantee, expert writer guarantee, privacy guarantee, quality assurance, academic writing guarantees, essay writing guarantee, research paper guarantee, dissertation guarantee',
            'canonical_url' => 'https://academicscribe.com/guarantees',
            'robots' => 'index, follow',
            'og_title' => 'Quality Guarantees | 100% Plagiarism-Free, Money-Back, Free Revisions',
            'og_description' => 'Comprehensive quality guarantees for all academic writing services. Plagiarism-free, money-back, free revisions, on-time delivery guaranteed.',
            'og_image' => '/images/quality-guarantees.jpg',
            'twitter_card' => 'summary_large_image',
            'twitter_title' => 'Quality Guarantees | 100% Plagiarism-Free, Money-Back, Free Revisions',
            'twitter_description' => 'Comprehensive quality guarantees for academic writing services. Risk-free ordering with multiple guarantees.',
            'structured_data' => [
                'service' => [
                    '@context' => 'https://schema.org',
                    '@type' => 'Service',
                    'name' => 'Academic Writing Quality Guarantees',
                    'description' => '100% plagiarism-free guarantee, money-back guarantee, free revisions, on-time delivery for essay writing, research papers, dissertations',
                    'provider' => [
                        '@type' => 'Organization',
                        'name' => 'Academic Scribe',
                    ],
                    'serviceType' => 'Academic Writing Services',
                    'areaServed' => 'Worldwide',
                ]
            ]
        ]);

        // Block 1: Hero Section
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'guarantees_hero',
            'block_key' => 'guarantees_hero',
            'order' => 1,
            'is_active' => true,
            'content' => [
                'title' => 'Our Quality Guarantees',
                'subtitle' => 'Your Success is Our Priority',
                'description' => 'At Academic Scribe, we stand behind our work with <strong>comprehensive guarantees</strong> that ensure your complete satisfaction. Your <em>academic success</em> is our commitment.',
            ]
        ]);

        // Block 2: Main Guarantees Grid
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'main_guarantees',
            'block_key' => 'main_guarantees',
            'order' => 2,
            'is_active' => true,
            'content' => [
                'title' => 'Our Core Guarantees',
                'description' => 'We provide comprehensive guarantees to ensure your complete satisfaction and academic success.',
                'guarantees' => [
                    [
                        'icon' => '🔒',
                        'title' => '100% Plagiarism-Free Guarantee',
                        'description' => 'Every paper is written from scratch with <strong>original content</strong>. We provide <a href="/services/essay-writing">free plagiarism reports</a> with every order to ensure complete originality.',
                        'features' => [
                            'Original content written from scratch',
                            'Free Turnitin plagiarism report',
                            'Multiple plagiarism detection tools',
                            'Zero tolerance for copied content',
                        ],
                        'link' => '/services/essay-writing',
                        'linkText' => 'Get Original Essays',
                    ],
                    [
                        'icon' => '💰',
                        'title' => 'Money-Back Guarantee',
                        'description' => 'Not satisfied with your paper? <strong>Get your money back</strong>. We offer <a href="/refund-policy">full refunds</a> for unsatisfactory work.',
                        'features' => [
                            'Full refund if not satisfied',
                            'Partial refunds for late delivery',
                            'No questions asked policy',
                            'Quick refund processing',
                        ],
                        'link' => '/services/research-papers',
                        'linkText' => 'Risk-Free Research Papers',
                    ],
                    [
                        'icon' => '🔄',
                        'title' => 'Free Unlimited Revisions',
                        'description' => 'We revise your paper until you\'re <strong>completely satisfied</strong>. Free revisions within <em>30 days</em> of delivery with <a href="/services/assignments">no additional charges</a>.',
                        'features' => [
                            'Unlimited revisions for 30 days',
                            'Quick revision turnaround',
                            'No additional charges',
                            'Direct communication with writer',
                        ],
                        'link' => '/services/assignments',
                        'linkText' => 'Get Perfect Assignments',
                    ],
                    [
                        'icon' => '⏰',
                        'title' => 'On-Time Delivery Guarantee',
                        'description' => 'We deliver your paper <strong>on time, every time</strong>. Late delivery results in automatic <a href="/services/dissertation-writing">compensation</a>.',
                        'features' => [
                            'Guaranteed on-time delivery',
                            'Compensation for late delivery',
                            'Progress tracking available',
                            'Rush orders accepted',
                        ],
                        'link' => '/services/dissertation-writing',
                        'linkText' => 'Timely Dissertation Help',
                    ],
                    [
                        'icon' => '🎓',
                        'title' => 'Expert Writer Guarantee',
                        'description' => 'Your paper is written by <strong>qualified experts</strong> in your field with <a href="/writers">advanced degrees and experience</a>.',
                        'features' => [
                            'PhD and Masters level writers',
                            'Subject matter experts',
                            'Native English speakers',
                            'Verified academic credentials',
                        ],
                        'link' => '/services/thesis-proposals',
                        'linkText' => 'Expert Thesis Writing',
                    ],
                    [
                        'icon' => '🔐',
                        'title' => 'Privacy & Confidentiality',
                        'description' => 'Your personal information and order details are kept <strong>strictly confidential</strong> and <a href="/privacy-policy">secure</a>.',
                        'features' => [
                            'SSL encrypted transactions',
                            'Anonymous communication',
                            'No data sharing with third parties',
                            'Secure payment processing',
                        ],
                        'link' => '/services/case-studies',
                        'linkText' => 'Confidential Case Studies',
                    ],
                ]
            ]
        ]);

        // Block 3: Quality Standards
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'quality_standards',
            'block_key' => 'quality_standards',
            'order' => 3,
            'is_active' => true,
            'content' => [
                'title' => 'Our Quality Standards',
                'description' => 'Beyond our guarantees, we maintain the highest <strong>quality standards</strong> in every aspect of our service.',
                'standards' => [
                    [
                        'icon' => '📚',
                        'title' => 'Academic Writing Standards',
                        'description' => 'All papers meet <strong>strict academic writing standards</strong> with proper formatting and citations. Learn more about our <a href="/services/literature-reviews">professional literature reviews</a>.',
                        'link' => '/services/literature-reviews',
                        'linkText' => 'Professional Literature Reviews',
                    ],
                    [
                        'icon' => '✅',
                        'title' => 'Quality Assurance Process',
                        'description' => '<strong>Multi-step quality check</strong> including editing, proofreading, and plagiarism detection for <a href="/services/essay-writing">quality essay writing</a>.',
                        'link' => '/services/essay-writing',
                        'linkText' => 'Quality Essay Writing',
                    ],
                    [
                        'icon' => '😊',
                        'title' => 'Customer Satisfaction',
                        'description' => '<strong>98% customer satisfaction rate</strong> with thousands of successful orders completed. See our <a href="/services/research-papers">satisfied research clients</a>.',
                        'link' => '/services/research-papers',
                        'linkText' => 'Satisfied Research Clients',
                    ],
                    [
                        'icon' => '🕐',
                        'title' => '24/7 Customer Support',
                        'description' => '<strong>Round-the-clock customer support</strong> to address any concerns or questions. Get <a href="/services/assignments">supported assignment help</a>.',
                        'link' => '/services/assignments',
                        'linkText' => 'Supported Assignment Help',
                    ],
                ]
            ]
        ]);

        // Block 4: Testimonials
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'guarantees_testimonials',
            'block_key' => 'guarantees_testimonials',
            'order' => 4,
            'is_active' => true,
            'content' => [
                'title' => 'What Our Clients Say About Our Guarantees',
                'description' => 'Real experiences from students who have benefited from our <strong>comprehensive guarantees</strong>.',
                'testimonials' => [
                    [
                        'text' => 'The <strong>plagiarism-free guarantee</strong> gave me confidence. My essay was <em>100% original</em> with a detailed plagiarism report.',
                        'author' => 'Sarah M.',
                        'role' => 'Essay Writing Client',
                        'rating' => 5,
                        'service' => 'Essay Writing',
                    ],
                    [
                        'text' => '<strong>Money-back guarantee</strong> worked perfectly. Got a full refund when the first draft didn\'t meet requirements.',
                        'author' => 'Mike R.',
                        'role' => 'Research Paper Client',
                        'rating' => 5,
                        'service' => 'Research Papers',
                    ],
                    [
                        'text' => '<strong>Free revisions guarantee</strong> is amazing. They revised my dissertation <em>3 times</em> until it was perfect.',
                        'author' => 'Lisa K.',
                        'role' => 'Dissertation Client',
                        'rating' => 5,
                        'service' => 'Dissertation',
                    ],
                ]
            ]
        ]);

        // Block 5: FAQs
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'guarantees_faqs',
            'block_key' => 'guarantees_faqs',
            'order' => 5,
            'is_active' => true,
            'content' => [
                'title' => 'Frequently Asked Questions About Our Guarantees',
                'description' => 'Get answers to common questions about our <strong>quality guarantees and policies</strong>.',
                'faqs' => [
                    [
                        'question' => 'What is your plagiarism-free guarantee for essay writing services?',
                        'answer' => 'Our plagiarism-free guarantee ensures every essay is written from scratch with <strong>100% original content</strong>. We provide free <a href="/services/essay-writing">Turnitin reports</a> and use multiple plagiarism detection tools to verify originality.',
                        'link' => '/services/essay-writing',
                        'linkText' => 'Learn about our essay writing guarantee',
                    ],
                    [
                        'question' => 'How does your money-back guarantee work for research papers?',
                        'answer' => 'If you\'re not satisfied with your research paper, we offer <strong>full refunds</strong>. Our <a href="/refund-policy">money-back guarantee</a> covers quality issues, late delivery, and failure to meet requirements.',
                        'link' => '/services/research-papers',
                        'linkText' => 'Get guaranteed research papers',
                    ],
                    [
                        'question' => 'What does your free revision guarantee include for dissertations?',
                        'answer' => 'Our free revision guarantee includes <strong>unlimited revisions for 30 days</strong> after delivery. We revise your <a href="/services/dissertation-writing">dissertation</a> until it meets your exact requirements at no extra cost.',
                        'link' => '/services/dissertation-writing',
                        'linkText' => 'Explore dissertation revision guarantee',
                    ],
                    [
                        'question' => 'Do you guarantee on-time delivery for urgent assignments?',
                        'answer' => 'Yes, we guarantee <strong>on-time delivery</strong> for all <a href="/services/assignments">assignments</a>, including urgent orders. Late delivery results in automatic compensation or partial refunds.',
                        'link' => '/services/assignments',
                        'linkText' => 'Get timely assignment help',
                    ],
                ]
            ]
        ]);

        // Block 6: CTA
        PageContent::create([
            'page_id' => $page->id,
            'block_type' => 'guarantees_cta',
            'block_key' => 'guarantees_cta',
            'order' => 6,
            'is_active' => true,
            'content' => [
                'title' => 'Ready to Experience Our Risk-Free Service?',
                'description' => 'Join <strong>thousands of satisfied students</strong> who trust our <a href="/services">guaranteed academic writing service</a>. Your success is our commitment.',
                'primaryButtonText' => 'Place Your Order Now',
                'primaryButtonLink' => '/place-order',
                'secondaryButtonText' => 'Contact Support',
                'secondaryButtonLink' => '/contact',
            ]
        ]);

        $this->command->info('✅ Guarantees page created successfully with modular content blocks!');
        $this->command->info('   - Hero section with rich text');
        $this->command->info('   - 6 main guarantees with TinyMCE-ready descriptions');
        $this->command->info('   - 4 quality standards with internal links');
        $this->command->info('   - Testimonials section');
        $this->command->info('   - FAQs with rich HTML answers');
        $this->command->info('   - CTA section');
    }
}





