<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageContent;

class SeedHomepageFaqs extends Seeder
{
    public function run(): void
    {
        $page = Page::where('slug', 'homepage')->first();
        if (!$page) {
            $page = Page::create([
                'slug' => 'homepage',
                'title' => 'Homepage',
                'page_type' => 'homepage',
                'status' => 'published',
            ]);
        }

        $payload = [
            'title' => 'Frequently Asked Questions About Our Academic Writing Services',
            'subtitle' => 'Get answers to common questions about our professional essay writers, dissertation writing help, research paper writing service, and custom academic papers.',
            'categories' => [
                [
                    'name' => 'General Services',
                    'description' => 'Common questions about our academic writing services',
                    'faqs' => [
                        [
                            'question' => 'What types of academic writing services do you offer?',
                            'answer' => 'We provide comprehensive academic writing services including dissertation writing help, research paper writing service, custom academic papers, essays, case studies, literature reviews, and thesis writing. Our professional essay writers specialize in all academic levels and 35+ disciplines.',
                            'keywords' => ['academic writing services','dissertation writing help','research paper writing service','custom academic papers','professional essay writers'],
                        ],
                        [
                            'question' => 'How do you ensure the quality of your academic writing services?',
                            'answer' => 'Every order goes through expert assignment, internal review, plagiarism checking, and final QA. Dissertation writing help includes methodology review; research paper writing service ensures proper citation and formatting.',
                            'keywords' => ['quality assurance','plagiarism checking','methodology review','citation','formatting'],
                        ],
                        [
                            'question' => 'What qualifications do your writers have?',
                            'answer' => 'Our team includes 180+ experts. 67% hold PhDs and 33% hold Masters degrees. Writers for dissertations have doctoral-level experience; research papers are handled by writers with published academic work.',
                            'keywords' => ['professional essay writers','PhD writers','Masters','experience'],
                        ],
                        [
                            'question' => 'How do you match writers to projects?',
                            'answer' => 'We match by academic level, subject, deadline, and requirements. Dissertations are assigned to PhD-level writers; research papers to writers with prior publications in the field.',
                            'keywords' => ['writer matching','subject expertise','deadline','requirements'],
                        ],
                    ],
                ],
                [
                    'name' => 'Quality & Plagiarism',
                    'description' => 'Questions about originality, quality control, and academic integrity',
                    'faqs' => [
                        [
                            'question' => 'How do you guarantee original, plagiarism-free academic writing?',
                            'answer' => 'All custom academic papers are written from scratch and checked with advanced plagiarism detection. We provide free plagiarism reports upon request.',
                            'keywords' => ['plagiarism-free','original content','plagiarism report'],
                        ],
                        [
                            'question' => 'How do you handle citation styles and formatting?',
                            'answer' => 'We support APA, MLA, Chicago, Harvard, and IEEE. We ensure accurate in-text citations, reference lists, and journal-specific formatting where required.',
                            'keywords' => ['APA','MLA','Chicago','Harvard','IEEE'],
                        ],
                        [
                            'question' => 'What is your revision policy?',
                            'answer' => 'We offer unlimited free revisions within 14 days. Revisions are completed within 24–48 hours and we ensure requirements are met to your satisfaction.',
                            'keywords' => ['revisions','policy','turnaround'],
                        ],
                        [
                            'question' => 'What quality control measures do you have?',
                            'answer' => 'We run a multi-stage QC: writer assignment, internal review, plagiarism check, formatting verification, and final QA. Dissertations include extra methodology and literature checks.',
                            'keywords' => ['quality control','checks','process'],
                        ],
                    ],
                ],
                [
                    'name' => 'Pricing & Payment',
                    'description' => 'Information about pricing, payment methods, and refund policies',
                    'faqs' => [
                        [
                            'question' => 'How is pricing determined?',
                            'answer' => 'Pricing depends on academic level, deadline, length, and complexity. Dissertation writing help typically costs more due to extensive research; standard papers are competitively priced.',
                            'keywords' => ['pricing','deadline','complexity'],
                        ],
                        [
                            'question' => 'What payment methods do you accept?',
                            'answer' => 'We accept major credit cards, PayPal, and bank transfers. All transactions are secured via encryption and PCI-compliant gateways.',
                            'keywords' => ['payment','PayPal','credit cards','bank transfer'],
                        ],
                        [
                            'question' => 'Do you offer discounts?',
                            'answer' => 'We offer welcome discounts, loyalty bonuses, bulk order discounts, and seasonal promotions. Packages are available for multi-part or longer projects.',
                            'keywords' => ['discounts','loyalty','bulk','promotions'],
                        ],
                        [
                            'question' => 'What is your refund policy?',
                            'answer' => 'We offer a money-back guarantee if requirements are not met despite revisions, including partial or full refunds depending on the case and delivery time.',
                            'keywords' => ['refund','money-back','guarantee'],
                        ],
                    ],
                ],
                [
                    'name' => 'Deadlines & Delivery',
                    'description' => 'Questions about turnaround times, urgent orders, and delivery',
                    'faqs' => [
                        [
                            'question' => 'What are your typical turnaround times?',
                            'answer' => 'Essays: 3–14 days; Research papers: 5–21 days; Dissertations: 2–8 weeks depending on scope. Rush options are available for shorter assignments.',
                            'keywords' => ['turnaround','timelines','delivery'],
                        ],
                        [
                            'question' => 'Can you handle urgent requests?',
                            'answer' => 'Yes. We offer 24–48 hour delivery for shorter assignments and expedited timelines for research papers and dissertations, maintaining quality standards.',
                            'keywords' => ['urgent','rush','expedite'],
                        ],
                        [
                            'question' => 'How do you ensure on-time delivery?',
                            'answer' => 'We use milestone-based planning, internal buffers, and proactive communication. Our on-time delivery rate exceeds 99%.',
                            'keywords' => ['on-time','milestones','buffers'],
                        ],
                        [
                            'question' => 'What happens if an order is late?',
                            'answer' => 'We offer compensation, partial refunds, or full refunds based on delay length and impact, and prioritize expedited completion.',
                            'keywords' => ['late','compensation','policy'],
                        ],
                    ],
                ],
                [
                    'name' => 'Communication & Support',
                    'description' => 'Questions about customer support, writer communication, and assistance',
                    'faqs' => [
                        [
                            'question' => 'How can I communicate with my writer?',
                            'answer' => 'Use our secure messaging system to chat with your assigned expert 24/7, share requirements, and request updates throughout the project.',
                            'keywords' => ['communication','messaging','updates'],
                        ],
                        [
                            'question' => 'What customer support do you provide?',
                            'answer' => '24/7 support via live chat, email, and phone. Project managers coordinate with writers to ensure smooth progress and timely delivery.',
                            'keywords' => ['support','live chat','phone','email'],
                        ],
                        [
                            'question' => 'Can I request progress updates?',
                            'answer' => 'Yes—regular status updates and milestone reports are available. Draft previews are provided for major projects such as dissertations.',
                            'keywords' => ['progress','status','milestones'],
                        ],
                        [
                            'question' => 'Can I modify my order?',
                            'answer' => 'We accommodate reasonable modifications. Minor changes are usually free; major scope changes may affect pricing and timelines.',
                            'keywords' => ['modifications','changes','scope'],
                        ],
                    ],
                ],
                [
                    'name' => 'Confidentiality & Security',
                    'description' => 'Questions about privacy, data security, and confidentiality',
                    'faqs' => [
                        [
                            'question' => 'How do you protect my personal information?',
                            'answer' => 'Bank-level security, encryption, and strict access controls. Writers see only assignment-related data. We never share data with third parties.',
                            'keywords' => ['privacy','encryption','security'],
                        ],
                        [
                            'question' => 'Is using your service confidential?',
                            'answer' => 'Yes. We sign NDAs, never disclose client usage, and maintain anonymity across all interactions and deliverables.',
                            'keywords' => ['confidentiality','NDA','anonymity'],
                        ],
                        [
                            'question' => 'How secure are your payment systems?',
                            'answer' => 'Payments are processed via PCI-compliant gateways with SSL encryption. We do not store credit card details.',
                            'keywords' => ['PCI','SSL','payments'],
                        ],
                        [
                            'question' => 'What data do you collect and why?',
                            'answer' => 'We collect only necessary project and contact data to deliver the service effectively and provide support. No unnecessary data collection.',
                            'keywords' => ['data','collection','purpose'],
                        ],
                    ],
                ],
            ],
        ];

        PageContent::updateOrCreate(
            [
                'page_id' => $page->id,
                'block_type' => 'faqs',
                'block_key' => 'faqs_main',
            ],
            [
                'content' => $payload,
                'order' => 4,
                'is_active' => true,
            ]
        );
    }
}


