<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageContent;

class SeedHomepageTestimonials extends Seeder
{
    public function run(): void
    {
        $page = Page::where('slug', 'homepage')->first();
        if (!$page) {
            $page = Page::create([
                'slug' => 'homepage',
                'title' => 'Homepage',
                'page_type' => 'homepage',
                'status' => 'published',
            ]);
        }

        $payload = [
            'title' => 'What Our Clients Say About Our Academic Writing Services',
            'subtitle' => 'Discover why students, researchers, and professionals trust our <strong>professional essay writers</strong> and comprehensive <strong>academic writing services</strong>. From <a href="https://essaypro.com/custom-dissertation-writing-service"><strong>dissertation writing help</strong></a> to <strong>research paper writing service</strong>, our <strong>custom academic papers</strong> have helped thousands achieve academic excellence.',
            'overallStats' => [
                'totalReviews' => 1247,
                'averageRating' => 4.9,
                'recommendationRate' => 98,
                'repeatCustomers' => 76,
            ],
            'categories' => [
                [
                    'name' => 'Students',
                    'description' => 'Undergraduate and graduate students',
                    'testimonials' => [
                        [
                            'text' => 'The dissertation writing help I received was exceptional. My committee was impressed with the quality of research and writing. The professional essay writers understood exactly what was needed for my PhD program.',
                            'author' => 'Dr. Sarah Johnson',
                            'role' => 'PhD Graduate - Psychology',
                            'university' => 'Stanford University',
                            'grade' => 'A+',
                            'service' => 'Dissertation Writing Help',
                            'rating' => 5,
                            'date' => 'March 2024',
                            'verified' => true,
                            'image' => '/images/testimonials/sarah-j.jpg',
                        ],
                        [
                            'text' => 'I was struggling with my research paper writing and found their academic writing services through a friend\'s recommendation. The custom academic paper I received helped me understand proper research methodology and improved my overall academic performance.',
                            'author' => 'Michael Chen',
                            'role' => 'Master\'s Student - Business Administration',
                            'university' => 'Harvard Business School',
                            'grade' => 'A',
                            'service' => 'Research Paper Writing Service',
                            'rating' => 5,
                            'date' => 'February 2024',
                            'verified' => true,
                            'image' => '/images/testimonials/michael-c.jpg',
                        ],
                        [
                            'text' => 'As an international student, I needed help with academic writing standards. Their professional essay writers not only delivered excellent work but also taught me valuable writing techniques that I use in all my assignments now.',
                            'author' => 'Priya Patel',
                            'role' => 'Undergraduate - Computer Science',
                            'university' => 'MIT',
                            'grade' => 'A-',
                            'service' => 'Custom Academic Papers',
                            'rating' => 5,
                            'date' => 'January 2024',
                            'verified' => true,
                            'image' => '/images/testimonials/priya-p.jpg',
                        ],
                    ],
                ],
                [
                    'name' => 'Researchers',
                    'description' => 'Academic researchers and faculty',
                    'testimonials' => [
                        [
                            'text' => 'Their research paper writing service helped me publish in a top-tier journal. The writers have deep understanding of academic standards and research methodology. I\'ve recommended their academic writing services to several colleagues.',
                            'author' => 'Prof. David Martinez',
                            'role' => 'Associate Professor - Environmental Science',
                            'university' => 'UC Berkeley',
                            'grade' => 'Published',
                            'service' => 'Research Paper Writing Service',
                            'rating' => 5,
                            'date' => 'April 2024',
                            'verified' => true,
                            'image' => '/images/testimonials/david-m.jpg',
                        ],
                        [
                            'text' => 'The dissertation writing help provided was comprehensive and professional. The writer assigned to my project had extensive knowledge in my field and delivered work that exceeded my expectations. Truly exceptional academic writing services.',
                            'author' => 'Dr. Lisa Thompson',
                            'role' => 'Postdoctoral Researcher - Neuroscience',
                            'university' => 'Johns Hopkins University',
                            'grade' => 'Excellent',
                            'service' => 'Dissertation Writing Help',
                            'rating' => 5,
                            'date' => 'March 2024',
                            'verified' => true,
                            'image' => '/images/testimonials/lisa-t.jpg',
                        ],
                        [
                            'text' => 'Working with their professional essay writers was a game-changer for my research career. The quality of custom academic papers they produce is consistently high, and their understanding of academic requirements is impressive.',
                            'author' => 'Dr. James Wilson',
                            'role' => 'Research Fellow - Economics',
                            'university' => 'Oxford University',
                            'grade' => 'Outstanding',
                            'service' => 'Custom Academic Papers',
                            'rating' => 5,
                            'date' => 'February 2024',
                            'verified' => true,
                            'image' => '/images/testimonials/james-w.jpg',
                        ],
                    ],
                ],
                [
                    'name' => 'Professionals',
                    'description' => 'Working professionals pursuing degrees',
                    'testimonials' => [
                        [
                            'text' => 'Balancing work and studies was challenging until I found their academic writing services. The research paper writing service helped me maintain my GPA while managing my full-time job. Highly recommend their professional approach.',
                            'author' => 'Amanda Rodriguez',
                            'role' => 'MBA Student & Marketing Director',
                            'university' => 'Wharton School',
                            'grade' => 'A',
                            'service' => 'Research Paper Writing Service',
                            'rating' => 5,
                            'date' => 'April 2024',
                            'verified' => true,
                            'image' => '/images/testimonials/amanda-r.jpg',
                        ],
                        [
                            'text' => 'The dissertation writing help I received was invaluable for completing my executive PhD program. The professional essay writers understood the unique challenges of working professionals and delivered exceptional quality work.',
                            'author' => 'Robert Kim',
                            'role' => 'Executive PhD Student & CEO',
                            'university' => 'Northwestern Kellogg',
                            'grade' => 'A+',
                            'service' => 'Dissertation Writing Help',
                            'rating' => 5,
                            'date' => 'March 2024',
                            'verified' => true,
                            'image' => '/images/testimonials/robert-k.jpg',
                        ],
                        [
                            'text' => 'Their custom academic papers helped me excel in my part-time master\'s program. The quality and attention to detail in their academic writing services made it possible for me to achieve my educational goals while working full-time.',
                            'author' => 'Jennifer Lee',
                            'role' => 'Master\'s Student & Financial Analyst',
                            'university' => 'Columbia Business School',
                            'grade' => 'A-',
                            'service' => 'Custom Academic Papers',
                            'rating' => 5,
                            'date' => 'January 2024',
                            'verified' => true,
                            'image' => '/images/testimonials/jennifer-l.jpg',
                        ],
                    ],
                ],
            ],
            'serviceHighlights' => [
                [
                    'service' => 'Dissertation Writing Help',
                    'satisfaction' => '97%',
                    'avgGrade' => 'A+',
                    'completionRate' => '99.2%',
                    'color' => 'from-purple-500 to-indigo-600',
                    'testimonialCount' => 245,
                ],
                [
                    'service' => 'Research Paper Writing Service',
                    'satisfaction' => '96%',
                    'avgGrade' => 'A',
                    'completionRate' => '98.8%',
                    'color' => 'from-blue-500 to-cyan-600',
                    'testimonialCount' => 387,
                ],
                [
                    'service' => 'Custom Academic Papers',
                    'satisfaction' => '98%',
                    'avgGrade' => 'A-',
                    'completionRate' => '99.5%',
                    'color' => 'from-green-500 to-emerald-600',
                    'testimonialCount' => 615,
                ],
            ],
            'trustIndicators' => [
                [
                    'title' => 'Verified Reviews',
                    'description' => 'All testimonials verified through our secure review system',
                ],
                [
                    'title' => 'Grade Guarantee',
                    'description' => '92% of students achieve A+ grades with our help',
                ],
                [
                    'title' => 'Expert Writers',
                    'description' => 'PhD-level professional essay writers in every field',
                ],
                [
                    'title' => 'Student Success',
                    'description' => '98% client satisfaction rate across all services',
                ],
            ],
        ];

        PageContent::updateOrCreate(
            [
                'page_id' => $page->id,
                'block_type' => 'testimonials',
                'block_key' => 'testimonials_main',
            ],
            [
                'content' => $payload,
                'order' => 5,
                'is_active' => true,
            ]
        );
    }
}

