<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageContent;
use App\Models\PageSeo;

class SeedPricingPageComplete extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create the Pricing page
        $page = Page::create([
            'title' => 'Pricing Page',
            'slug' => 'pricing',
            'page_type' => 'pricing',
            'status' => 'published',
            'template' => 'pricing',
            'seo_priority' => 5,
            'updated_by' => 1,
            'published_at' => now(),
        ]);

        // Create SEO data
        PageSeo::create([
            'page_id' => $page->id,
            'meta_title' => 'Cheap Custom Essay Writing Service Prices | From $8.50/Page | Academic Scribe',
            'meta_description' => 'Affordable, original essays from $8.50/page. Cheap custom essay writing service with plagiarism reports, free revisions, fast turnaround, and secure payments.',
            'meta_keywords' => 'cheap custom essay writing service, affordable essay writing, essay writing prices, custom essay cheap, buy essays online cheap',
            'og_title' => 'Cheapest Essays Online | Buy Cheap Essays Starting $8.50',
            'og_description' => 'Get the cheapest essays online with quality guarantee. Buy cheap essays starting $8.50/page. Custom essay writing at lowest prices with instant delivery.',
            'og_image' => '/images/academic-writing-pricing.jpg',
            'twitter_title' => 'Cheap Custom Essay Writing Service Prices | From $8.50/Page | Academic Scribe',
            'twitter_description' => 'Affordable, original essays from $8.50/page. Cheap custom essay writing service with plagiarism reports, free revisions, fast turnaround, and secure payments.',
            'twitter_image' => '/images/academic-writing-pricing.jpg',
            'canonical_url' => 'https://academicscribe.com/pricing-page',
            'structured_data' => json_encode([
                '@context' => 'https://schema.org',
                '@type' => 'Service',
                'name' => 'Academic Writing Services',
                'description' => 'Cheap custom essay writing, affordable research papers, and dissertation help with transparent pricing.',
                'provider' => [
                    '@type' => 'Organization',
                    'name' => 'Academic Scribe',
                ],
                'offers' => [
                    [
                        '@type' => 'Offer',
                        'name' => 'High School Academic Writing Service',
                        'price' => '8.5',
                        'priceCurrency' => 'USD',
                        'description' => 'Affordable essay writing service for high school students with professional quality',
                    ],
                    [
                        '@type' => 'Offer',
                        'name' => 'University Academic Writing Service',
                        'price' => '10.5',
                        'priceCurrency' => 'USD',
                        'description' => 'College essay writing service prices that fit student budgets',
                    ],
                    [
                        '@type' => 'Offer',
                        'name' => 'Masters Academic Writing Service',
                        'price' => '14',
                        'priceCurrency' => 'USD',
                        'description' => 'Graduate research paper prices for advanced academic writing',
                    ],
                    [
                        '@type' => 'Offer',
                        'name' => 'PhD Academic Writing Service',
                        'price' => '18',
                        'priceCurrency' => 'USD',
                        'description' => 'PhD thesis writing service rates for expert dissertation help',
                    ],
                ],
            ]),
        ]);

        // Create content blocks
        $blocks = [
            // 1. Pricing Hero
            [
                'block_type' => 'pricing_hero',
                'order' => 1,
                'content' => [
                    'title' => 'Cheap Custom Essay Writing Service Prices (From $8.50/Page)',
                    'description' => 'Get the cheapest essays online with quality guarantee! Buy cheap essays starting $8.50/page. Custom essay writing at lowest prices with instant delivery and money-back guarantee. Order custom essay cheap online with quality guarantee from PhD writers.',
                    'primaryButtonText' => 'Get Cheapest Essays Now',
                    'primaryButtonLink' => '/place-order',
                    'secondaryButtonText' => 'View Essay Services',
                    'secondaryButtonLink' => '/services/essay-writing',
                    'relatedLinks' => [
                        ['text' => 'cheap custom essay', 'url' => '/services/essay-writing'],
                        ['text' => 'cheap custom essay writing service', 'url' => '/services/essay-writing'],
                        ['text' => 'buy essays online cheap', 'url' => '/services/essay-writing'],
                        ['text' => 'order essay online cheap', 'url' => '/services/essay-writing'],
                    ],
                ],
            ],

            // 2. Pricing Tiers
            [
                'block_type' => 'pricing_tiers',
                'order' => 2,
                'content' => [
                    'title' => 'Cheapest Essay Writing Service Prices & Savings',
                    'description' => 'Compare our cheapest essay writing service price per page - Save 30-50% compared to competitors! Buy cheap essays online with quality guarantee. The prices below are the average starting prices for a 2 weeks deadline.',
                    'tiers' => [
                        [
                            'level' => 'High School',
                            'startingPrice' => '8.5',
                            'description' => 'Affordable essay writing service for high school students with professional quality',
                            'orderLink' => '/place-order',
                            'serviceLink' => '/services/essay-writing',
                        ],
                        [
                            'level' => 'University',
                            'startingPrice' => '10.5',
                            'description' => 'College essay writing service prices that fit student budgets',
                            'orderLink' => '/place-order',
                            'serviceLink' => '/services/essay-writing',
                        ],
                        [
                            'level' => 'Masters',
                            'startingPrice' => '14',
                            'description' => 'Graduate research paper prices for advanced academic writing',
                            'orderLink' => '/place-order',
                            'serviceLink' => '/services/essay-writing',
                        ],
                        [
                            'level' => 'PhD',
                            'startingPrice' => '18',
                            'description' => 'PhD thesis writing service rates for expert dissertation help',
                            'orderLink' => '/place-order',
                            'serviceLink' => '/services/essay-writing',
                        ],
                    ],
                    'priceComparison' => [
                        'title' => '🏆 Why We\'re the Cheapest Essay Writing Service',
                        'competitorPrice' => '$15-20',
                        'ourPrice' => '$8.50-18',
                        'savings' => 'Save 30-50%',
                        'ctaText' => 'Order Cheapest Essays Now - Save 30%+',
                        'ctaLink' => '/place-order',
                    ],
                    'internalLinks' => [
                        'title' => 'Why Choose Our Cheapest Essay Writing Service?',
                        'writersSection' => [
                            'title' => 'Meet Our Expert Writers',
                            'description' => 'Our cheapest essays are written by PhD-qualified writers with verified credentials and extensive experience.',
                            'link' => '/writers',
                            'linkText' => 'Meet Our PhD-Qualified Writers',
                        ],
                        'guaranteesSection' => [
                            'title' => 'Our Quality Guarantees',
                            'description' => 'Get cheapest essays with comprehensive guarantees including plagiarism-free content and unlimited revisions.',
                            'link' => '/guarantees',
                            'linkText' => 'View Our Quality Guarantees',
                        ],
                    ],
                    'urgentNotice' => [
                        'disclaimer' => '* Cheapest essay prices may vary based on deadline and complexity. All prices include quality guarantee and free revisions.',
                        'title' => '⚡ URGENT: Cheapest Essays with Same-Day Delivery',
                        'description' => 'Need cheapest essays urgently? Get same-day delivery for just 50% extra! Buy cheap essay online with same day delivery. Rush orders available with emergency cheapest essay help starting at $12.75/page.',
                        'link' => '/services/essay-writing',
                        'linkText' => 'Get Cheapest Essays Urgently',
                    ],
                ],
            ],

            // 3. Service Pricing Grid
            [
                'block_type' => 'service_pricing_grid',
                'order' => 3,
                'content' => [
                    'title' => 'All Academic Writing Services & Pricing',
                    'description' => 'Explore our complete range of cheapest academic writing services with transparent pricing and quality guarantee. Buy cheap essays online with quality guarantee from professional writers.',
                    'services' => [
                        [
                            'name' => 'Essay Writing',
                            'price' => '$10-18',
                            'description' => 'Professional essay writing service for all academic levels',
                            'learnMoreLink' => '/services/essay-writing',
                            'orderLink' => '/place-order',
                        ],
                        [
                            'name' => 'Research Papers',
                            'price' => '$12-20',
                            'description' => 'Expert research paper writing with thorough analysis',
                            'learnMoreLink' => '/services/research-papers',
                            'orderLink' => '/place-order',
                        ],
                        [
                            'name' => 'Dissertation Writing',
                            'price' => '$12-20',
                            'description' => 'Comprehensive dissertation writing and consultation',
                            'learnMoreLink' => '/services/dissertation-writing',
                            'orderLink' => '/place-order',
                        ],
                        [
                            'name' => 'Assignments',
                            'price' => '$8-18',
                            'description' => 'All types of academic assignments and homework help',
                            'learnMoreLink' => '/services/assignments',
                            'orderLink' => '/place-order',
                        ],
                        [
                            'name' => 'Case Studies',
                            'price' => '$12-18',
                            'description' => 'Detailed case study analysis and writing',
                            'learnMoreLink' => '/services/case-studies',
                            'orderLink' => '/place-order',
                        ],
                        [
                            'name' => 'Literature Reviews',
                            'price' => '$10-18',
                            'description' => 'Comprehensive literature review and analysis',
                            'learnMoreLink' => '/services/literature-reviews',
                            'orderLink' => '/place-order',
                        ],
                        [
                            'name' => 'Thesis Proposals',
                            'price' => '$18-25',
                            'description' => 'Professional thesis proposal writing and guidance',
                            'learnMoreLink' => '/services/thesis-proposals',
                            'orderLink' => '/place-order',
                        ],
                    ],
                    'viewAllServicesText' => 'View All Essay Writing Services',
                    'viewAllServicesLink' => '/services',
                ],
            ],

            // 4. Service Image Section
            [
                'block_type' => 'service_image',
                'order' => 4,
                'content' => [
                    'title' => 'Professional Academic Writing Service Cost Comparison',
                    'imageSrc' => '/images/academic-writing-pricing.jpg',
                    'imageAlt' => 'Buy essays online cheap - professional academic writers providing quality essay writing service prices, dissertation writing cost, and research paper writing rates for students',
                    'description' => 'When you purchase essay writing help from us, you get expert writers, original content, and the best academic writing service pricing in the industry.',
                    'exploreText' => 'Explore All Cheapest Essay Services',
                    'exploreLink' => '/services',
                ],
            ],

            // 5. Pricing Reasons
            [
                'block_type' => 'pricing_reasons',
                'order' => 5,
                'content' => [
                    'title' => 'Why Our Prices Beat the Competition',
                    'description' => 'Cheapest essay writing service prices with guaranteed quality and professional writers. Save 30-50% compared to competitors.',
                    'reasons' => [
                        [
                            'title' => 'Cheapest Essays Online with Quality Guarantee',
                            'description' => 'Get the cheapest essays online without compromising quality. Our cheapest essay writing service delivers professional results at unbeatable prices.',
                            'link' => '/services/essay-writing',
                            'linkText' => 'View Cheapest Essay Services',
                        ],
                        [
                            'title' => 'Best Research Paper Writing Rates',
                            'description' => 'Compare research paper writing prices and see why we offer the most competitive rates for expert research and analysis.',
                            'link' => '/services/research-papers',
                            'linkText' => 'View Research Paper Services',
                        ],
                        [
                            'title' => 'Professional Dissertation Writing Rates',
                            'description' => 'Our dissertation writing cost includes expert research, quality writing, and unlimited revisions for your academic success.',
                            'link' => '/services/dissertation-writing',
                            'linkText' => 'View Dissertation Services',
                        ],
                        [
                            'title' => 'Assignment Help Pricing',
                            'description' => 'Affordable assignment help cost for all types of academic work including case studies, literature reviews, and more.',
                            'link' => '/services/assignments',
                            'linkText' => 'View Assignment Services',
                        ],
                        [
                            'title' => 'Cheapest Custom Essays with PhD Writers',
                            'description' => 'Order custom essay cheap from PhD-qualified writers. Our cheapest custom essays include original research, plagiarism reports, and unlimited revisions.',
                            'link' => '/services/essay-writing',
                            'linkText' => 'Order Cheapest Custom Essays',
                        ],
                        [
                            'title' => 'Academic Writing Service Pricing',
                            'description' => 'Transparent academic writing service cost comparison shows we offer the best value across all service types.',
                            'link' => '/services',
                            'linkText' => 'Compare All Services',
                        ],
                    ],
                ],
            ],

            // 6. Pricing FAQs
            [
                'block_type' => 'pricing_faqs',
                'order' => 6,
                'content' => [
                    'title' => 'Academic Writing Service Pricing FAQ',
                    'description' => 'Common questions about essay writing service cost per page and dissertation writing service rates',
                    'faqs' => [
                        [
                            'question' => 'Are your essays really the cheapest online?',
                            'answer' => 'Yes! Our cheapest essays online with quality guarantee start at $8.50/page, which is 30-50% cheaper than competitors. We offer the cheapest essay writing service price per page with quality guarantee, plagiarism reports, and unlimited revisions included.',
                            'link' => '/services/essay-writing',
                            'linkText' => 'View our cheapest essay services',
                        ],
                        [
                            'question' => 'How do you offer cheapest essays without compromising quality?',
                            'answer' => 'We maintain quality while offering cheapest essays through efficient processes, bulk writer partnerships, and streamlined operations. Our cheapest custom essays are written by PhD-qualified writers with the same quality standards as premium services.',
                            'link' => '/services/essay-writing',
                            'linkText' => 'Learn about our quality guarantee',
                        ],
                        [
                            'question' => 'Can I buy cheap essays with same-day delivery?',
                            'answer' => 'Yes! Our cheapest essays with same-day delivery start at $12.75/page (50% rush fee). Buy cheap essay online with same day delivery. We offer urgent cheapest essay help for tight deadlines while maintaining quality standards.',
                            'link' => '/services/essay-writing',
                            'linkText' => 'Get urgent cheapest essays',
                        ],
                        [
                            'question' => 'What\'s included when I order custom essay cheap?',
                            'answer' => 'When you order custom essay cheap online with quality guarantee from us, you get original content, plagiarism report, unlimited revisions, 24/7 support, and money-back guarantee. All cheapest essays online with quality guarantee include these features at no extra cost.',
                            'link' => '/services/essay-writing',
                            'linkText' => 'Order cheapest custom essays',
                        ],
                        [
                            'question' => 'What are your urgent essay writing service prices?',
                            'answer' => 'Rush dissertation writing cost and 24 hour research paper writing prices include a 50-100% urgency fee. Same day essay writing rates start at $24 per page.',
                            'link' => '/services/essay-writing',
                            'linkText' => 'Get urgent essay writing help',
                        ],
                        [
                            'question' => 'How do your academic writing service pricing compare to competitors?',
                            'answer' => 'Our academic writing service cost comparison shows we offer 20-30% lower rates than competitors while maintaining superior quality and customer service.',
                            'link' => '/services',
                            'linkText' => 'Compare all our services',
                        ],
                        [
                            'question' => 'Can I purchase essay writing help for specific academic levels?',
                            'answer' => 'Yes! We offer college essay writing service prices, university dissertation writing cost, and undergraduate assignment help cost tailored to each academic level.',
                            'link' => '/services/assignments',
                            'linkText' => 'View assignment help services',
                        ],
                        [
                            'question' => 'What\'s included when I buy academic papers online?',
                            'answer' => 'When you buy academic papers online from us, you get original content, free revisions, plagiarism report, and 24/7 customer support at no extra cost.',
                            'link' => '/services',
                            'linkText' => 'See all included services',
                        ],
                    ],
                ],
            ],

            // 7. Pricing CTA
            [
                'block_type' => 'pricing_cta',
                'order' => 7,
                'content' => [
                    'title' => 'Ready to Buy Affordable Essays Online?',
                    'description' => 'Get cheapest essays online from expert writers with quality guarantee. Order cheap essays with our reliable pricing and save 30-50% compared to competitors. Buy cheap essays online with quality guarantee from PhD writers.',
                    'limitedOffer' => [
                        'title' => '🚨 LIMITED TIME: Extra 15% OFF Essay Orders',
                        'description' => 'Limited writer availability today! This offer expires in 24 hours.',
                        'link' => '/place-order',
                        'buttonText' => 'Claim 15% OFF Now',
                    ],
                    'primaryButtonText' => 'Buy Essays Now',
                    'primaryButtonLink' => '/place-order',
                    'secondaryButtonText' => 'View All Services',
                    'secondaryButtonLink' => '/services',
                    'trustIndicators' => [
                        ['text' => 'Money-Back Guarantee'],
                        ['text' => 'Free Revisions'],
                        ['text' => '24/7 Support'],
                        ['text' => 'Plagiarism-Free'],
                    ],
                ],
            ],

            // 8. Pricing Keywords
            [
                'block_type' => 'pricing_keywords',
                'order' => 8,
                'content' => [
                    'title' => 'Complete Academic Writing Service Cost Guide',
                    'description' => 'Comprehensive pricing for all academic writing services',
                    'categories' => [
                        [
                            'title' => 'Assignment Help Pricing',
                            'link' => '/services/assignments',
                            'items' => [
                                ['text' => 'Case study writing cost: $15-22/page', 'link' => '/services/case-studies'],
                                ['text' => 'Literature review writing rates: $16-24/page', 'link' => '/services/literature-reviews'],
                                ['text' => 'Thesis proposal writing prices: $18-25/page', 'link' => '/services/thesis-proposals'],
                                ['text' => 'Undergraduate assignment help cost: $12-18/page', 'link' => '/services/assignments'],
                            ],
                        ],
                        [
                            'title' => 'Quality vs Price Guarantee',
                            'link' => '/services',
                            'items' => [
                                ['text' => 'Quality essay writing affordable prices', 'link' => '/services/essay-writing'],
                                ['text' => 'Expert research paper writing cost', 'link' => '/services/research-papers'],
                                ['text' => 'Reliable essay service pricing', 'link' => '/services'],
                                ['text' => 'Professional dissertation writing rates', 'link' => '/services/dissertation-writing'],
                            ],
                        ],
                        [
                            'title' => 'Academic Level Pricing',
                            'link' => '/services',
                            'items' => [
                                ['text' => 'College essay writing service prices', 'link' => '/services/essay-writing'],
                                ['text' => 'University dissertation writing cost', 'link' => '/services/dissertation-writing'],
                                ['text' => 'Graduate research paper prices', 'link' => '/services/research-papers'],
                                ['text' => 'PhD thesis writing service rates', 'link' => '/services/dissertation-writing'],
                            ],
                        ],
                    ],
                    'bottomSection' => [
                        'title' => 'Why We\'re the Best Academic Writing Service Pricing Choice',
                        'leftColumn' => [
                            'title' => 'Affordable vs Expensive Essay Services',
                            'description' => 'We offer the perfect balance of quality and affordability, beating expensive competitors by 30%.',
                            'link' => '/services/essay-writing',
                            'linkText' => 'Compare Cheapest Essay Prices',
                        ],
                        'rightColumn' => [
                            'title' => 'Compare Essay Writing Prices',
                            'description' => 'Our transparent pricing beats the competition with no hidden fees or surprise charges.',
                            'link' => '/services',
                            'linkText' => 'View All Cheapest Services',
                        ],
                    ],
                ],
            ],

            // 9. Pricing Testimonials
            [
                'block_type' => 'pricing_testimonials',
                'order' => 9,
                'content' => [
                    'title' => 'What Our Customers Say About Our Pricing',
                    'description' => 'Real feedback from students who chose our services',
                    'testimonials' => [
                        [
                            'quote' => 'Best essay writing service prices I found! Quality work at affordable rates.',
                            'author' => 'Sarah M.',
                            'position' => 'University Student',
                            'service' => 'Essay Writing',
                            'rating' => 5,
                            'link' => '/services/essay-writing',
                            'linkText' => 'Get Cheapest Essay Help',
                        ],
                        [
                            'quote' => 'Research paper writing rates were very reasonable. Excellent value for money!',
                            'author' => 'Mike R.',
                            'position' => 'Graduate Student',
                            'service' => 'Research Paper',
                            'rating' => 5,
                            'link' => '/services/research-papers',
                            'linkText' => 'Get Research Help',
                        ],
                        [
                            'quote' => 'Dissertation writing cost was fair and the quality exceeded my expectations.',
                            'author' => 'Lisa K.',
                            'position' => 'PhD Candidate',
                            'service' => 'Dissertation',
                            'rating' => 5,
                            'link' => '/services/dissertation-writing',
                            'linkText' => 'Get Dissertation Help',
                        ],
                    ],
                    'viewMoreReviewsText' => 'Read More Reviews',
                    'viewMoreReviewsLink' => '/reviews',
                ],
            ],

            // 10. Pricing Resources
            [
                'block_type' => 'pricing_resources',
                'order' => 10,
                'content' => [
                    'title' => 'Cheapest Essay Writing Resources & Guides',
                    'description' => 'Learn more about essay writing and find the cheapest essay services with our comprehensive guides',
                    'resourceCategories' => [
                        [
                            'title' => '📚 Essay Writing Guides',
                            'links' => [
                                ['text' => 'How to Choose Essay Writing Service', 'url' => '/blog/buy-essays-online-ultimate-guide-2025', 'external' => false],
                                ['text' => '8 Essay Writing Tips for Students (2025)', 'url' => '/blog/8-essay-writing-tips-for-students-2025', 'external' => false],
                                ['text' => 'Essay Topic Ideas', 'url' => '/blog/essay-topic-ideas', 'external' => false],
                                ['text' => 'Essay Structure Guide', 'url' => '/blog/essay-structure-guide', 'external' => false],
                            ],
                        ],
                        [
                            'title' => '🛡️ Trust & Authority',
                            'links' => [
                                ['text' => 'Better Business Bureau', 'url' => 'https://www.bbb.org', 'external' => true],
                                ['text' => 'Trustpilot Reviews', 'url' => 'https://www.trustpilot.com', 'external' => true],
                                ['text' => 'Turnitin Plagiarism Check', 'url' => 'https://www.turnitin.com', 'external' => true],
                            ],
                        ],
                        [
                            'title' => '🎓 Educational Resources',
                            'links' => [
                                ['text' => 'Purdue OWL Writing Guide', 'url' => 'https://owl.purdue.edu', 'external' => true],
                                ['text' => 'APA Style Guide', 'url' => 'https://www.apastyle.org', 'external' => true],
                                ['text' => 'MLA Style Guide', 'url' => 'https://www.mla.org', 'external' => true],
                            ],
                        ],
                    ],
                ],
            ],

            // 11. Pricing Security
            [
                'block_type' => 'pricing_security',
                'order' => 11,
                'content' => [
                    'title' => 'Your Security & Privacy Matter',
                    'description' => 'We protect your personal information and ensure secure transactions',
                    'securityFeatures' => [
                        [
                            'title' => 'SSL Encryption',
                            'description' => 'All data transmitted is encrypted with 256-bit SSL security',
                            'iconBgColor' => 'bg-green-100',
                            'iconColor' => 'text-green-600',
                            'iconPath' => 'M2.166 4.999A11.954 11.954 0 0010 1.944 11.954 11.954 0 0017.834 5c.11.65.166 1.32.166 2.001 0 5.225-3.34 9.67-8 11.317C5.34 16.67 2 12.225 2 7c0-.682.057-1.35.166-2.001zm11.541 3.708a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z',
                        ],
                        [
                            'title' => 'Privacy Protected',
                            'description' => 'Your personal information is never shared with third parties',
                            'iconBgColor' => 'bg-blue-100',
                            'iconColor' => 'text-blue-600',
                            'iconPath' => 'M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z',
                        ],
                        [
                            'title' => 'Secure Payments',
                            'description' => 'Multiple payment options with bank-level security',
                            'iconBgColor' => 'bg-purple-100',
                            'iconColor' => 'text-purple-600',
                            'iconPath' => 'M4 4a2 2 0 00-2 2v4a2 2 0 002 2V6h10a2 2 0 00-2-2H4zm2 6a2 2 0 012-2h8a2 2 0 012 2v4a2 2 0 01-2 2H8a2 2 0 01-2-2v-4zm6 4a2 2 0 100-4 2 2 0 000 4z',
                        ],
                        [
                            'title' => 'Verified Service',
                            'description' => 'Trusted by thousands with verified customer reviews',
                            'iconBgColor' => 'bg-yellow-100',
                            'iconColor' => 'text-yellow-600',
                            'iconPath' => 'M6.267 3.455a3.066 3.066 0 001.745-.723 3.066 3.066 0 013.976 0 3.066 3.066 0 001.745.723 3.066 3.066 0 012.812 2.812c.051.643.304 1.254.723 1.745a3.066 3.066 0 010 3.976 3.066 3.066 0 00-.723 1.745 3.066 3.066 0 01-2.812 2.812 3.066 3.066 0 00-1.745.723 3.066 3.066 0 01-3.976 0 3.066 3.066 0 00-1.745-.723 3.066 3.066 0 01-2.812-2.812 3.066 3.066 0 00-.723-1.745 3.066 3.066 0 010-3.976 3.066 3.066 0 00.723-1.745 3.066 3.066 0 012.812-2.812zm7.44 5.252a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z',
                        ],
                    ],
                    'paymentMethods' => [
                        'title' => 'Accepted Payment Methods',
                        'methods' => [
                            ['name' => 'VISA', 'color' => 'text-blue-600'],
                            ['name' => 'MasterCard', 'color' => 'text-red-600'],
                            ['name' => 'PayPal', 'color' => 'text-blue-800'],
                        ],
                    ],
                ],
            ],

            // 12. Pricing Contact
            [
                'block_type' => 'pricing_contact',
                'order' => 12,
                'content' => [
                    'title' => 'Still Have Questions About Pricing?',
                    'description' => 'Our friendly support team is here to help you choose the right service and pricing option',
                    'contactMethods' => [
                        [
                            'title' => 'Call Us',
                            'description' => 'Speak with our pricing experts',
                            'link' => 'tel:+1-800-123-4567',
                            'linkText' => '+1 (800) 123-4567',
                            'iconBgColor' => 'bg-blue-100',
                            'iconColor' => 'text-blue-600',
                            'iconPath' => 'M2 3a1 1 0 011-1h2.153a1 1 0 01.986.836l.74 4.435a1 1 0 01-.54 1.06l-1.548.773a11.037 11.037 0 006.105 6.105l.774-1.548a1 1 0 011.059-.54l4.435.74a1 1 0 01.836.986V17a1 1 0 01-1 1h-2C7.82 18 2 12.18 2 5V3z',
                        ],
                        [
                            'title' => 'Email Us',
                            'description' => 'Get detailed pricing information',
                            'link' => 'mailto:info@academicscribe.com',
                            'linkText' => 'info@academicscribe.com',
                            'iconBgColor' => 'bg-green-100',
                            'iconColor' => 'text-green-600',
                            'iconPath' => 'M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z',
                        ],
                        [
                            'title' => 'Live Chat',
                            'description' => 'Chat with us right now',
                            'link' => '#',
                            'linkText' => 'Start Chat',
                            'iconBgColor' => 'bg-purple-100',
                            'iconColor' => 'text-purple-600',
                            'iconPath' => 'M18 10c0 3.866-3.582 7-8 7a8.841 8.841 0 01-4.083-.98L2 17l1.338-3.123C2.493 12.767 2 11.434 2 10c0-3.866 3.582-7 8-7s8 3.134 8 7zM7 9H5v2h2V9zm8 0h-2v2h2V9zM9 9h2v2H9V9z',
                        ],
                    ],
                    'customQuoteSection' => [
                        'title' => '💡 Pro Tip: Custom Quote Available',
                        'description' => 'Need a custom solution or have a large project? Contact us for a personalized quote that fits your specific requirements and budget.',
                        'link' => '/contact',
                        'linkText' => 'Get Custom Quote',
                    ],
                ],
            ],
        ];

        // Create all content blocks
        foreach ($blocks as $block) {
            PageContent::create([
                'page_id' => $page->id,
                'block_type' => $block['block_type'],
                'order' => $block['order'],
                'content' => $block['content'],
                'is_active' => true,
            ]);
        }

        $this->command->info('Pricing page with all content blocks created successfully!');
    }
}
