<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageSeo;
use App\Models\PageContent;

class SeedServiceAssignments extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Update existing page for Assignments service
        $page = Page::updateOrCreate(
            ['slug' => 'assignments'],
            [
                'title' => 'Assignment Writing Service',
                'page_type' => 'service',
                'status' => 'published',
                'template' => 'Services/Assignments',
                'seo_priority' => 85,
                'published_at' => now(),
            ]
        );

        // Structured data
        $structuredData = [
            'service' => [
                '@context' => 'https://schema.org',
                '@type' => 'Service',
                'name' => 'Professional Assignment Writing Service',
                'description' => 'Expert assignment writing service providing custom assignment help with professional writers, original research, comprehensive analysis, and perfect academic formatting for all educational levels.',
                'provider' => [
                    '@type' => 'Organization',
                    'name' => 'Academic Scribe',
                    'url' => 'https://academicscribe.com',
                    'logo' => 'https://academicscribe.com/images/logo.png',
                    'contactPoint' => [
                        '@type' => 'ContactPoint',
                        'telephone' => '+1-555-123-4567',
                        'contactType' => 'customer service',
                        'availableLanguage' => ['English'],
                        'areaServed' => 'Worldwide',
                    ],
                    'address' => [
                        '@type' => 'PostalAddress',
                        'addressCountry' => 'US',
                        'addressRegion' => 'Global',
                    ],
                    'sameAs' => [
                        'https://facebook.com/academicscribe',
                        'https://twitter.com/academicscribe',
                        'https://linkedin.com/company/academicscribe',
                    ],
                ],
                'serviceType' => 'Academic Writing Service',
                'areaServed' => 'Worldwide',
                'availableChannel' => [
                    '@type' => 'ServiceChannel',
                    'serviceUrl' => 'https://academicscribe.com/services/assignments',
                    'servicePhone' => '+1-555-123-4567',
                    'availableLanguage' => 'English',
                ],
                'hasOfferCatalog' => [
                    '@type' => 'OfferCatalog',
                    'name' => 'Assignment Writing Services',
                    'itemListElement' => [
                        [
                            '@type' => 'Offer',
                            'itemOffered' => [
                                '@type' => 'Service',
                                'name' => 'Custom Assignment Help',
                                'description' => 'Personalized assignment writing assistance with original research and analysis',
                            ],
                            'price' => 'Starting at $12.99',
                            'priceCurrency' => 'USD',
                            'availability' => 'https://schema.org/InStock',
                        ],
                        [
                            '@type' => 'Offer',
                            'itemOffered' => [
                                '@type' => 'Service',
                                'name' => 'Academic Assignment Service',
                                'description' => 'Professional assignment writing for all academic disciplines and levels',
                            ],
                            'price' => 'Starting at $12.99',
                            'priceCurrency' => 'USD',
                            'availability' => 'https://schema.org/InStock',
                        ],
                        [
                            '@type' => 'Offer',
                            'itemOffered' => [
                                '@type' => 'Service',
                                'name' => 'Assignment Writing Assistance',
                                'description' => 'Expert guidance and support for assignment projects with methodology help',
                            ],
                            'price' => 'Starting at $12.99',
                            'priceCurrency' => 'USD',
                            'availability' => 'https://schema.org/InStock',
                        ],
                    ],
                ],
            ],
            'breadcrumb' => [
                '@context' => 'https://schema.org',
                '@type' => 'BreadcrumbList',
                'itemListElement' => [
                    [
                        '@type' => 'ListItem',
                        'position' => 1,
                        'name' => 'Home',
                        'item' => 'https://academicscribe.com',
                    ],
                    [
                        '@type' => 'ListItem',
                        'position' => 2,
                        'name' => 'Services',
                        'item' => 'https://academicscribe.com/services',
                    ],
                    [
                        '@type' => 'ListItem',
                        'position' => 3,
                        'name' => 'Assignment Writing Service',
                        'item' => 'https://academicscribe.com/services/assignments',
                    ],
                ],
            ],
            'organization' => [
                '@context' => 'https://schema.org',
                '@type' => 'Organization',
                'name' => 'Academic Scribe',
                'description' => 'Professional academic writing services with expert assignment writers providing custom assignment help and comprehensive academic writing support for students worldwide.',
                'url' => 'https://academicscribe.com',
                'logo' => 'https://academicscribe.com/images/logo.png',
                'image' => 'https://academicscribe.com/images/assignment-writing-service.jpg',
                'contactPoint' => [
                    '@type' => 'ContactPoint',
                    'telephone' => '+1-555-123-4567',
                    'contactType' => 'customer service',
                    'availableLanguage' => ['English'],
                    'areaServed' => 'Worldwide',
                ],
                'address' => [
                    '@type' => 'PostalAddress',
                    'addressCountry' => 'US',
                    'addressRegion' => 'Global',
                ],
                'sameAs' => [
                    'https://facebook.com/academicscribe',
                    'https://twitter.com/academicscribe',
                    'https://linkedin.com/company/academicscribe',
                ],
            ],
            'website' => [
                '@context' => 'https://schema.org',
                '@type' => 'WebSite',
                'name' => 'Academic Scribe - Assignment Writing Service',
                'description' => 'Professional assignment writers providing custom assignment help and comprehensive academic assignment writing service for students at all educational levels.',
                'url' => 'https://academicscribe.com/services/assignments',
                'potentialAction' => [
                    '@type' => 'SearchAction',
                    'target' => 'https://academicscribe.com/search?q={search_term_string}',
                    'query-input' => 'required name=search_term_string',
                ],
            ],
            'webpage' => [
                '@context' => 'https://schema.org',
                '@type' => 'WebPage',
                'name' => 'Professional Assignment Writing Service | Expert Assignment Help',
                'description' => 'Expert assignment writing service with professional writers. Get custom assignment help for all academic levels with original research, comprehensive analysis, and guaranteed results.',
                'url' => 'https://academicscribe.com/services/assignments',
                'isPartOf' => [
                    '@type' => 'WebSite',
                    'name' => 'Academic Scribe',
                    'url' => 'https://academicscribe.com',
                ],
                'about' => [
                    '@type' => 'Service',
                    'name' => 'Assignment Writing Service',
                ],
                'mainEntity' => [
                    '@type' => 'Service',
                    'name' => 'Professional Assignment Writing Service',
                ],
            ],
        ];

        // SEO data
        PageSeo::updateOrCreate(
            ['page_id' => $page->id],
            [
                'meta_title' => 'Professional Assignment Writing Service | Expert Assignment Help | Academic Scribe',
                'meta_description' => 'Get expert assignment writing service with professional writers. Custom assignment help for all academic levels with original research, perfect formatting, and 24/7 support. Order now!',
                'meta_keywords' => 'assignment writing service, professional assignment help, custom assignment writing, academic assignment service, assignment writers, assignment writing assistance, college assignment help, university assignment service, assignment writing for students, professional academic writing service, assignment help online, custom assignments, academic assignment writing, assignment writing company, assignment writing experts',
                'canonical_url' => 'https://academicscribe.com/services/assignments',
                'og_url' => 'https://academicscribe.com/services/assignments',
                'robots' => 'index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1',
                'language' => 'en-US',
                'structured_data' => $structuredData,
                'twitter_card' => 'summary_large_image',
                'twitter_title' => 'Professional Assignment Writing Service | Expert Assignment Help',
                'twitter_description' => 'Expert assignment writing service with professional writers. Get custom assignment help with original research, perfect formatting, and guaranteed results.',
                'twitter_image' => 'https://academicscribe.com/images/assignment-writing-service-twitter.jpg',
                'og_title' => 'Professional Assignment Writing Service | Expert Assignment Help',
                'og_description' => 'Expert assignment writing service with professional writers. Get custom assignment help for all academic levels with original research and comprehensive analysis. Trusted by 10,000+ students worldwide.',
                'og_image' => 'https://academicscribe.com/images/assignment-writing-service-og.jpg',
                'og_type' => 'website',
            ]
        );

        // Delete old blocks first
        PageContent::where('page_id', $page->id)->delete();

        // Content blocks
        $blocks = [
            [
                'block_type' => 'service_hero',
                'block_key' => 'assignment_hero',
                'order' => 1,
                'content' => [
                    'title' => 'Professional Assignment Writing Service | Expert Custom Assignment Help',
                    'description' => 'Get expert assignment writing service from professional writers with advanced degrees. Our custom assignment help covers all academic levels with original research, comprehensive analysis, and perfect formatting. Trusted by 10,000+ students worldwide with 24/7 support and guaranteed results.',
                    'keyPoints' => [
                        'Professional assignment writers with expertise in your field',
                        'Custom assignment help with 100% original content and plagiarism-free work',
                        'Academic assignment service covering all subjects with proper methodology',
                        'Assignment writing assistance with perfect formatting and citations',
                    ],
                    'ctaText' => 'Get Professional Assignment Help Now',
                    'ctaLink' => '/contact',
                    'trustSignals' => [
                        '10,000+ satisfied students',
                        '4.8/5 average rating',
                        '24/7 customer support',
                        'Money-back guarantee',
                    ],
                ],
            ],
            [
                'block_type' => 'service_overview',
                'block_key' => 'assignment_overview',
                'order' => 2,
                'content' => [
                    'title' => 'Our Comprehensive Assignment Writing Service',
                    'description' => 'We provide professional assignment writing across all academic disciplines with expert research methodology and academic excellence. Our custom assignment help includes original research, data analysis, and comprehensive academic writing support for students at all educational levels.',
                    'features' => [
                        [
                            'title' => 'Professional Assignment Writers',
                            'description' => 'Expert assignment writers with advanced degrees who understand academic standards, research methodologies, and discipline-specific requirements for quality assignment writing service',
                            'icon' => 'Award',
                        ],
                        [
                            'title' => 'Original Research & Analysis',
                            'description' => 'Custom assignment help with original research, primary source analysis, data collection, and comprehensive analysis tailored to your specific academic requirements',
                            'icon' => 'Search',
                        ],
                        [
                            'title' => 'All Academic Subjects Covered',
                            'description' => 'Academic assignment service covering sciences, humanities, business, engineering, social sciences, and specialized fields with subject-matter experts',
                            'icon' => 'BookOpen',
                        ],
                        [
                            'title' => 'Perfect Academic Formatting',
                            'description' => 'Professional assignment writing with proper citations, references, and formatting in APA, MLA, Chicago, Harvard, and other academic styles',
                            'icon' => 'FileText',
                        ],
                    ],
                ],
            ],
            [
                'block_type' => 'service_process',
                'block_key' => 'assignment_process',
                'order' => 3,
                'content' => [
                    'title' => 'Our Professional Assignment Writing Process',
                    'description' => 'We follow a structured, academic approach to deliver exceptional assignment writing service with thorough research methodology, original analysis, and academic excellence that meets your institution\'s highest standards.',
                    'steps' => [
                        ['number' => 1, 'title' => 'Assignment Requirements Analysis', 'description' => 'Comprehensive analysis of your assignment requirements, academic objectives, institutional guidelines, and project scope to establish clear direction for your custom assignment help.', 'icon' => 'Target'],
                        ['number' => 2, 'title' => 'Research Strategy Development', 'description' => 'Develop comprehensive research strategy with relevant academic sources, database selection, and analytical frameworks for professional assignment writing service excellence.', 'icon' => 'Search'],
                        ['number' => 3, 'title' => 'Academic Source Collection', 'description' => 'Conduct extensive research using scholarly databases, peer-reviewed journals, and credible sources for your academic assignment service with quality assessment.', 'icon' => 'Database'],
                        ['number' => 4, 'title' => 'Content Development & Writing', 'description' => 'Professional assignment writers craft your assignment with clear academic structure, logical flow, compelling arguments, and adherence to academic writing standards.', 'icon' => 'Edit'],
                        ['number' => 5, 'title' => 'Citation & Formatting', 'description' => 'Apply proper academic citations, reference lists, and formatting according to your required style guide for assignment writing assistance with institutional compliance.', 'icon' => 'FileText'],
                        ['number' => 6, 'title' => 'Quality Review & Editing', 'description' => 'Comprehensive review, editing, and proofreading to ensure your assignment meets academic standards and excellence expectations for professional assignment writing service delivery.', 'icon' => 'CheckCircle'],
                    ],
                ],
            ],
            [
                'block_type' => 'service_benefits',
                'block_key' => 'assignment_benefits',
                'order' => 4,
                'content' => [
                    'title' => 'Why Choose Our Professional Assignment Writing Service',
                    'description' => 'Discover why over 10,000 students choose our expert assignment writing assistance for their academic success',
                    'benefits' => [
                        ['title' => 'Subject-Specific Assignment Writers', 'description' => 'Professional assignment writers with advanced degrees in your specific field who understand discipline-specific requirements and academic standards for exceptional results', 'icon' => 'Award'],
                        ['title' => '100% Original Content & Custom Work', 'description' => 'Custom assignment help with completely original content, unique analysis, plagiarism-free work, and comprehensive originality reports tailored to your academic requirements', 'icon' => 'Shield'],
                        ['title' => 'Comprehensive Research Support', 'description' => 'Academic assignment service with proper research methodology, advanced analysis techniques, and evidence-based conclusions that meet rigorous academic standards', 'icon' => 'Search'],
                        ['title' => 'Perfect Academic Standards', 'description' => 'Assignment writing assistance that meets all academic standards with proper structure, perfect citations, formatting requirements, and adherence to academic integrity', 'icon' => 'CheckCircle'],
                        ['title' => 'Guaranteed Timely Delivery', 'description' => 'Professional assignment writing service with reliable delivery schedules, 24/7 customer support, unlimited revisions, and money-back guarantee for complete satisfaction', 'icon' => 'Clock'],
                    ],
                    'imageAlt' => 'Professional Assignment Writing Service Benefits - Custom Assignment Help with Expert Writers and Original Research',
                    'ctaText' => 'Order Professional Assignment Now',
                    'ctaLink' => '/place-order',
                    'guarantees' => [
                        '100% Original Content',
                        'On-Time Delivery',
                        '24/7 Support',
                        'Money-Back Guarantee',
                        'Unlimited Revisions',
                    ],
                ],
            ],
            [
                'block_type' => 'service_testimonials',
                'block_key' => 'assignment_testimonials',
                'order' => 5,
                'content' => [
                    'title' => 'What Our Assignment Writing Service Clients Say',
                    'description' => 'Read authentic testimonials from students who\'ve achieved academic success with our professional assignment writing assistance',
                    'testimonials' => [
                        ['text' => 'The assignment writing service I received was outstanding. The writer conducted thorough research and provided excellent analysis that impressed my professor. The custom assignment help included perfect citations and met all my university\'s requirements. I received an A+ grade!', 'author' => 'Jessica M.', 'role' => 'Undergraduate Student, Business', 'rating' => 5, 'verified' => true, 'university' => 'University of California, Berkeley'],
                        ['text' => 'I needed professional assignment writing for my marketing course, and the quality exceeded my expectations. The academic assignment service provided original research with comprehensive analysis and clear presentation. The writer was knowledgeable and responsive throughout the process.', 'author' => 'Michael L.', 'role' => 'Graduate Student, Marketing', 'rating' => 5, 'verified' => true, 'university' => 'Northwestern University'],
                        ['text' => 'As an international student, I struggled with academic writing standards. The assignment writing assistance helped me understand proper formatting and citation styles while delivering a high-quality assignment that earned me an A grade. The support team was available 24/7.', 'author' => 'Priya R.', 'role' => 'Undergraduate Student, Computer Science', 'rating' => 5, 'verified' => true, 'university' => 'Carnegie Mellon University'],
                    ],
                    'trustMetrics' => [
                        'totalReviews' => '2,156',
                        'averageRating' => '4.8',
                        'satisfactionRate' => '98%',
                        'repeatCustomers' => '87%',
                    ],
                ],
            ],
            [
                'block_type' => 'service_faqs',
                'block_key' => 'assignment_faqs',
                'order' => 6,
                'content' => [
                    'title' => 'Assignment Writing Service FAQs',
                    'description' => 'Get answers to common questions about our professional assignment writing assistance and custom assignment help services',
                    'faqs' => [
                        ['question' => 'What types of assignments does your assignment writing service handle?', 'answer' => 'Our professional assignment writing service handles all types of academic assignments including essays, research papers, case studies, lab reports, book reviews, literature reviews, analytical assignments, argumentative assignments, and specialized projects. Our custom assignment help covers all academic levels from high school to graduate studies, across all disciplines including sciences, humanities, business, engineering, social sciences, and specialized fields. We also handle specific formats and institutional requirements.'],
                        ['question' => 'How do you ensure original content in your assignment writing service?', 'answer' => 'Our assignment writing service guarantees 100% original content through comprehensive research, custom writing approaches, and original analysis. Our professional assignment writers create fresh content for each project, avoiding pre-written materials and template-based approaches. We use advanced plagiarism detection tools and provide detailed originality reports with every custom assignment help order. Additionally, we maintain a strict no-resale policy to ensure complete originality.'],
                        ['question' => 'What qualifications do your assignment writers have?', 'answer' => 'Our assignment writers hold advanced degrees (Bachelor\'s, Master\'s, and PhD) in their respective fields with extensive academic writing experience. Each professional assignment writer undergoes rigorous screening including academic credential verification, writing portfolio review, and subject expertise testing. Our academic assignment service team includes subject specialists, former educators, and industry professionals with proven track records in their fields.'],
                        ['question' => 'How do you handle citations and formatting in assignments?', 'answer' => 'Our professional assignment writing service includes expert citation and formatting in all major academic styles including APA, MLA, Chicago/Turabian, Harvard, and other specialized formats. Our assignment writers are trained in academic citation standards and use professional tools to ensure accuracy. Every custom assignment help order includes properly formatted citations, reference lists, and adherence to your institution\'s specific formatting requirements.'],
                        ['question' => 'What is your revision policy for assignment writing service?', 'answer' => 'Our assignment writing service includes unlimited free revisions within 14 days of delivery to ensure complete satisfaction. If your custom assignment help doesn\'t meet your requirements or needs adjustments based on professor feedback, our professional assignment writers will revise it at no additional cost. We\'re committed to your academic success and will work with you until your assignment meets all requirements and expectations.'],
                        ['question' => 'How do you ensure confidentiality in your assignment writing service?', 'answer' => 'Our professional assignment writing service maintains strict confidentiality through encrypted communication systems, secure payment processing, and comprehensive non-disclosure agreements. We never share client information, assignment topics, or completed work with third parties. All custom assignment help orders are processed with complete anonymity, and we delete all client files after project completion. Our assignment writers sign confidentiality agreements, and our platform uses SSL encryption to protect all communications.'],
                        ['question' => 'What support do you provide after delivering my assignment?', 'answer' => 'Our assignment writing service includes comprehensive post-delivery support including free revisions, formatting adjustments, citation corrections, and academic guidance. Our 24/7 customer support team is available to address any questions or concerns about your custom assignment help order. We also provide additional guidance on professor feedback implementation and academic writing improvement tips for your future assignments.'],
                    ],
                ],
            ],
            [
                'block_type' => 'service_cta',
                'block_key' => 'assignment_cta',
                'order' => 7,
                'content' => [
                    'title' => 'Ready to Get Professional Assignment Help That Guarantees Results?',
                    'description' => 'Join over 10,000 successful students who\'ve achieved academic excellence with our expert assignment writing service. Get custom assignment help from professional writers with advanced degrees today.',
                    'benefits' => [
                        ['text' => 'Professional assignment writers with subject expertise', 'icon' => '🏆'],
                        ['text' => '100% original content with comprehensive analysis', 'icon' => '🔍'],
                        ['text' => 'Perfect formatting and academic citations guaranteed', 'icon' => '📄'],
                        ['text' => '24/7 support with money-back guarantee', 'icon' => '🛡️'],
                    ],
                    'primaryButtonText' => 'Get Professional Assignment Help Now',
                    'primaryButtonLink' => '/place-order',
                    'secondaryButtonText' => 'Free Assignment Consultation',
                    'secondaryButtonLink' => '/contact',
                    'bgColor' => 'blue',
                    'urgencyText' => 'Limited Time: 15% OFF for new customers',
                    'guarantees' => [
                        '100% Original Content',
                        'On-Time Delivery',
                        'Money-Back Guarantee',
                        'Unlimited Revisions',
                        '24/7 Support',
                    ],
                    'trustBadges' => [
                        'SSL Secured',
                        'Privacy Protected',
                        'Verified Writers',
                        'Academic Excellence',
                    ],
                ],
            ],
            [
                'block_type' => 'internal_links',
                'block_key' => 'assignment_related_services',
                'order' => 8,
                'content' => [
                    'title' => 'Related Academic Writing Services',
                    'description' => 'Explore our comprehensive range of academic writing services',
                    'links' => [
                        ['title' => 'Essay Writing Service', 'url' => '/services/essay-writing', 'description' => 'Professional essay writing for all academic levels'],
                        ['title' => 'Research Paper Writing Service', 'url' => '/services/research-papers', 'description' => 'Expert research paper writing with comprehensive analysis'],
                        ['title' => 'Dissertation Writing Service', 'url' => '/services/dissertation-writing', 'description' => 'PhD dissertation help and doctoral thesis writing'],
                        ['title' => 'Thesis Writing Help', 'url' => '/services/thesis-proposals', 'description' => 'Master\'s thesis writing assistance and support'],
                    ],
                ],
            ],
            [
                'block_type' => 'internal_links',
                'block_key' => 'assignment_support_pages',
                'order' => 9,
                'content' => [
                    'title' => 'Learn More About Our Assignment Writing Service',
                    'description' => 'Get detailed information about our assignment writing specialists and pricing',
                    'links' => [
                        ['title' => 'Our Writers', 'url' => '/writers', 'description' => 'Meet our assignment writing specialists'],
                        ['title' => 'Pricing', 'url' => '/pricing-page', 'description' => 'Transparent assignment writing pricing'],
                        ['title' => 'Guarantees', 'url' => '/guarantees', 'description' => 'Our quality and satisfaction guarantees'],
                        ['title' => 'Reviews', 'url' => '/reviews', 'description' => 'Read customer reviews and testimonials'],
                    ],
                ],
            ],
            [
                'block_type' => 'internal_links',
                'block_key' => 'assignment_resource_links',
                'order' => 10,
                'content' => [
                    'title' => 'Professional Assignment Writing Service Resources',
                    'links' => [
                        ['title' => 'Assignment Writing Guide', 'url' => '/blog/assignment-writing-guide', 'description' => 'Complete guide to writing academic assignments'],
                        ['title' => 'Academic Writing Tips', 'url' => '/blog/academic-writing-tips', 'description' => 'Essential tips for academic writing success'],
                        ['title' => 'Academic Citations Style Guide', 'url' => '/blog/academic-citation-guide', 'description' => 'Master APA, MLA, and Chicago citation styles'],
                        ['title' => 'Assignment Topics', 'url' => '/blog/assignment-topics', 'description' => 'Inspiring assignment topic ideas by subject'],
                    ],
                ],
            ],
        ];

        // Upsert content blocks
        foreach ($blocks as $i => $block) {
            PageContent::create([
                'page_id' => $page->id,
                'block_type' => $block['block_type'],
                'block_key' => $block['block_key'],
                'content' => $block['content'],
                'order' => $block['order'] ?? ($i + 1),
                'is_active' => true,
            ]);
        }

        $this->command->info('Assignments service content seeded successfully!');
    }
}
