<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageSeo;
use App\Models\PageContent;

class SeedServiceCaseStudies extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create/update the page for Case Studies service
        $page = Page::updateOrCreate(
            ['slug' => 'case-studies'],
            [
                'title' => 'Case Study Writing Service',
                'page_type' => 'service',
                'status' => 'published',
                'template' => 'Services/CaseStudies',
                'seo_priority' => 85,
                'published_at' => now(),
            ]
        );

        // Structured data
        $structuredData = [
            'service' => [
                '@context' => 'https://schema.org',
                '@type' => 'Service',
                'name' => 'Professional Case Study Writing Service',
                'description' => 'Expert case study writing service providing comprehensive case study analysis for business, medical, legal, and academic case studies with professional writers and structured methodology.',
                'provider' => [
                    '@type' => 'Organization',
                    'name' => 'Academic Scribe',
                    'url' => 'https://academicscribe.com',
                    'logo' => 'https://academicscribe.com/images/logo.png',
                    'contactPoint' => [
                        '@type' => 'ContactPoint',
                        'telephone' => '+1-555-123-4567',
                        'contactType' => 'customer service',
                        'availableLanguage' => ['English'],
                        'areaServed' => 'Worldwide',
                    ],
                    'address' => [
                        '@type' => 'PostalAddress',
                        'addressCountry' => 'US',
                        'addressRegion' => 'Global',
                    ],
                    'sameAs' => [
                        'https://facebook.com/academicscribe',
                        'https://twitter.com/academicscribe',
                        'https://linkedin.com/company/academicscribe',
                    ],
                ],
                'serviceType' => 'Academic Writing Service',
                'areaServed' => 'Worldwide',
                'availableChannel' => [
                    '@type' => 'ServiceChannel',
                    'serviceUrl' => 'https://academicscribe.com/services/case-studies',
                    'servicePhone' => '+1-555-123-4567',
                    'availableLanguage' => 'English',
                ],
                'hasOfferCatalog' => [
                    '@type' => 'OfferCatalog',
                    'name' => 'Case Study Writing Services',
                    'itemListElement' => [
                        [
                            '@type' => 'Offer',
                            'itemOffered' => [
                                '@type' => 'Service',
                                'name' => 'Business Case Study Writing',
                                'description' => 'Professional business case studies with strategic analysis and comprehensive methodology',
                            ],
                            'price' => 'Starting at $18.99',
                            'priceCurrency' => 'USD',
                            'availability' => 'https://schema.org/InStock',
                        ],
                        [
                            '@type' => 'Offer',
                            'itemOffered' => [
                                '@type' => 'Service',
                                'name' => 'Medical Case Study Analysis',
                                'description' => 'Expert medical case studies with clinical assessments and evidence-based analysis',
                            ],
                            'price' => 'Starting at $18.99',
                            'priceCurrency' => 'USD',
                            'availability' => 'https://schema.org/InStock',
                        ],
                        [
                            '@type' => 'Offer',
                            'itemOffered' => [
                                '@type' => 'Service',
                                'name' => 'Academic Case Study Help',
                                'description' => 'Comprehensive academic case study writing with theoretical framework integration',
                            ],
                            'price' => 'Starting at $18.99',
                            'priceCurrency' => 'USD',
                            'availability' => 'https://schema.org/InStock',
                        ],
                    ],
                ],
            ],
            'breadcrumb' => [
                '@context' => 'https://schema.org',
                '@type' => 'BreadcrumbList',
                'itemListElement' => [
                    [
                        '@type' => 'ListItem',
                        'position' => 1,
                        'name' => 'Home',
                        'item' => 'https://academicscribe.com',
                    ],
                    [
                        '@type' => 'ListItem',
                        'position' => 2,
                        'name' => 'Services',
                        'item' => 'https://academicscribe.com/services',
                    ],
                    [
                        '@type' => 'ListItem',
                        'position' => 3,
                        'name' => 'Case Study Writing Service',
                        'item' => 'https://academicscribe.com/services/case-studies',
                    ],
                ],
            ],
            'organization' => [
                '@context' => 'https://schema.org',
                '@type' => 'Organization',
                'name' => 'Academic Scribe',
                'description' => 'Professional academic writing services with expert case study writers providing comprehensive case study analysis for business, medical, legal, and academic fields worldwide.',
                'url' => 'https://academicscribe.com',
                'logo' => 'https://academicscribe.com/images/logo.png',
                'image' => 'https://academicscribe.com/images/case-study-writing-service.jpg',
                'contactPoint' => [
                    '@type' => 'ContactPoint',
                    'telephone' => '+1-555-123-4567',
                    'contactType' => 'customer service',
                    'availableLanguage' => ['English'],
                    'areaServed' => 'Worldwide',
                ],
                'address' => [
                    '@type' => 'PostalAddress',
                    'addressCountry' => 'US',
                    'addressRegion' => 'Global',
                ],
                'sameAs' => [
                    'https://facebook.com/academicscribe',
                    'https://twitter.com/academicscribe',
                    'https://linkedin.com/company/academicscribe',
                ],
            ],
            'website' => [
                '@context' => 'https://schema.org',
                '@type' => 'WebSite',
                'name' => 'Academic Scribe - Case Study Writing Service',
                'description' => 'Professional case study writers providing expert case study analysis and comprehensive case study writing service for students and professionals at all levels.',
                'url' => 'https://academicscribe.com/services/case-studies',
                'potentialAction' => [
                    '@type' => 'SearchAction',
                    'target' => 'https://academicscribe.com/search?q={search_term_string}',
                    'query-input' => 'required name=search_term_string',
                ],
            ],
            'webpage' => [
                '@context' => 'https://schema.org',
                '@type' => 'WebPage',
                'name' => 'Professional Case Study Writing Service | Expert Case Study Help',
                'description' => 'Expert case study writing service with professional writers. Get comprehensive case study analysis for business, medical, legal, and academic case studies with guaranteed results.',
                'url' => 'https://academicscribe.com/services/case-studies',
                'isPartOf' => [
                    '@type' => 'WebSite',
                    'name' => 'Academic Scribe',
                    'url' => 'https://academicscribe.com',
                ],
                'about' => [
                    '@type' => 'Service',
                    'name' => 'Case Study Writing Service',
                ],
                'mainEntity' => [
                    '@type' => 'Service',
                    'name' => 'Professional Case Study Writing Service',
                ],
            ],
        ];

        // SEO data
        PageSeo::updateOrCreate(
            ['page_id' => $page->id],
            [
                'meta_title' => 'Professional Case Study Writing Service | Business & Medical Case Studies | Academic Scribe',
                'meta_description' => 'Expert case study writing service for business, medical, legal, and academic case studies. Professional case study help with analysis, methodology, and structured formatting. 24/7 support available.',
                'meta_keywords' => 'case study writing service, professional case study writing service for students, business case study writing help, medical case study analysis service, legal case study writing assistance, custom case study help with methodology, case study writers, academic case study writing service, case study analysis help, MBA case study writing service, nursing case study help, case study research methodology, case study report writing, case study presentation help, expert case study writing',
                'canonical_url' => 'https://academicscribe.com/services/case-studies',
                'og_url' => 'https://academicscribe.com/services/case-studies',
                'robots' => 'index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1',
                'language' => 'en-US',
                'structured_data' => $structuredData,
                'twitter_card' => 'summary_large_image',
                'twitter_title' => 'Professional Case Study Writing Service | Expert Case Study Help',
                'twitter_description' => 'Expert case study writing service with professional writers. Get comprehensive case study analysis with guaranteed results and 24/7 support.',
                'twitter_image' => 'https://academicscribe.com/images/case-study-writing-service-twitter.jpg',
                'og_title' => 'Professional Case Study Writing Service | Expert Case Study Help',
                'og_description' => 'Expert case study writing service with professional writers. Get comprehensive case study analysis for business, medical, legal, and academic case studies with guaranteed results.',
                'og_image' => 'https://academicscribe.com/images/case-study-writing-service-og.jpg',
                'og_type' => 'website',
            ]
        );

        // Content blocks
        $blocks = [
            [
                'block_type' => 'service_hero',
                'block_key' => 'case_study_hero',
                'order' => 1,
                'content' => [
                    'title' => 'Professional Case Study Writing Service | Expert Case Study Help',
                    'description' => 'Get expert case study writing service across all disciplines. Our professional case study writers deliver comprehensive analysis for business, medical, legal, and academic case studies with proper methodology and structured formatting.',
                    'keyPoints' => [
                        'Professional case study writers with discipline-specific expertise',
                        'Comprehensive case study analysis with proper theoretical frameworks',
                        'Custom case study help for business, medical, legal, and academic fields',
                        'Expert case study methodology and data visualization support',
                    ],
                    'ctaText' => 'Get Professional Case Study Help',
                    'ctaLink' => '/contact',
                    'trustSignals' => [
                        '8,500+ satisfied students',
                        '4.9/5 average rating',
                        '24/7 customer support',
                        'Money-back guarantee',
                    ],
                ],
            ],
            [
                'block_type' => 'service_overview',
                'block_key' => 'case_study_overview',
                'order' => 2,
                'content' => [
                    'title' => 'Our Comprehensive Case Study Writing Service',
                    'description' => 'We provide professional case study writing service across multiple disciplines with expert analysis and methodology. Our case study help covers all types of case studies with industry-specific expertise.',
                    'features' => [
                        [
                            'title' => 'Business Case Study Writing',
                            'description' => 'Professional business case studies with strategic analysis, SWOT methodology, Porter\'s Five Forces, and comprehensive business model evaluations',
                            'icon' => 'Briefcase',
                        ],
                        [
                            'title' => 'Medical Case Study Analysis',
                            'description' => 'Expert medical case studies with patient history analysis, clinical assessments, treatment evaluations, and evidence-based medical accuracy',
                            'icon' => 'Activity',
                        ],
                        [
                            'title' => 'Legal Case Study Help',
                            'description' => 'Professional legal case analysis with precedent research, case briefs, judicial reasoning analysis, and proper legal citations',
                            'icon' => 'FileText',
                        ],
                        [
                            'title' => 'Academic Case Studies',
                            'description' => 'Comprehensive academic case study writing with qualitative and quantitative analysis, theoretical framework integration, and scholarly methodology',
                            'icon' => 'Users',
                        ],
                    ],
                ],
            ],
            [
                'block_type' => 'service_process',
                'block_key' => 'case_study_process',
                'order' => 3,
                'content' => [
                    'title' => 'Our Professional Case Study Writing Process',
                    'description' => 'We follow a structured methodology to develop comprehensive case studies with expert analysis and professional formatting across all disciplines.',
                    'steps' => [
                        ['number' => 1, 'title' => 'Case Study Assessment', 'description' => 'Evaluate your case study requirements, discipline-specific needs, and analytical frameworks to establish clear objectives for your case study project.', 'icon' => 'Search'],
                        ['number' => 2, 'title' => 'Expert Case Study Writer Assignment', 'description' => 'Match your case study with a professional writer who has specialized experience in your specific field and case study methodology.', 'icon' => 'User'],
                        ['number' => 3, 'title' => 'Research & Case Analysis', 'description' => 'Gather relevant case study information, identify key issues, and select appropriate analytical frameworks for comprehensive case study analysis.', 'icon' => 'FileText'],
                        ['number' => 4, 'title' => 'Case Study Development', 'description' => 'Structure the case study with professional formatting including background, methodology, findings, analysis, and actionable recommendations.', 'icon' => 'Edit'],
                        ['number' => 5, 'title' => 'Evidence Integration & Data Visualization', 'description' => 'Incorporate supporting evidence, create professional data visualization, charts, and integrate relevant theoretical concepts for case study analysis.', 'icon' => 'BarChart'],
                        ['number' => 6, 'title' => 'Quality Review & Methodology Verification', 'description' => 'Verify analytical rigor, theoretical soundness, and adherence to discipline-specific conventions for professional case study standards.', 'icon' => 'CheckCircle'],
                        ['number' => 7, 'title' => 'Case Study Delivery & Support', 'description' => 'Provide the completed case study with follow-up support for questions, revisions, and presentation materials if needed.', 'icon' => 'Send'],
                    ],
                ],
            ],
            [
                'block_type' => 'service_benefits',
                'block_key' => 'case_study_benefits',
                'order' => 4,
                'content' => [
                    'title' => 'Benefits of Our Professional Case Study Writing Service',
                    'description' => 'Discover why students and professionals choose our expert case study help for their academic and business success',
                    'benefits' => [
                        ['title' => 'Industry-Specific Case Study Specialists', 'description' => 'Professional case study writers with real-world experience in your field who understand industry applications and case study methodology', 'icon' => 'Briefcase'],
                        ['title' => 'Advanced Analytical Frameworks', 'description' => 'Expert application of discipline-specific frameworks, analytical models, and case study methodology for comprehensive analysis', 'icon' => 'Layers'],
                        ['title' => 'Professional Data Visualization', 'description' => 'Custom charts, graphs, diagrams, and visual elements to enhance case study presentation and analysis clarity', 'icon' => 'BarChart'],
                        ['title' => 'Solution-Oriented Case Studies', 'description' => 'Practical recommendations and actionable solutions based on thorough case study analysis and evidence-based conclusions', 'icon' => 'Target'],
                        ['title' => 'Multidisciplinary Case Study Approach', 'description' => 'Integration of concepts across relevant disciplines for comprehensive case study analysis and cross-functional insights', 'icon' => 'Grid'],
                    ],
                    'imageAlt' => 'Professional Case Study Writing Service Benefits - Expert Case Study Help with Comprehensive Analysis and Professional Writers',
                    'ctaText' => 'Order Professional Case Study',
                    'ctaLink' => '/place-order',
                    'guarantees' => [
                        '100% Original Analysis',
                        'On-Time Delivery',
                        '24/7 Support',
                        'Money-Back Guarantee',
                        'Unlimited Revisions',
                    ],
                ],
            ],
            [
                'block_type' => 'service_testimonials',
                'block_key' => 'case_study_testimonials',
                'order' => 5,
                'content' => [
                    'title' => 'What Our Case Study Writing Service Clients Say',
                    'description' => 'Read authentic testimonials from students and professionals who\'ve used our expert case study help',
                    'testimonials' => [
                        ['text' => 'The business case study writing service I received was exceptional. The SWOT analysis was comprehensive, and the strategic recommendations were backed by solid market research and industry analysis. My professor specifically praised the quality of the competitive analysis and case study methodology.', 'author' => 'Michael R.', 'role' => 'MBA Student, Strategic Management', 'rating' => 5, 'verified' => true, 'university' => 'Wharton School of Business'],
                        ['text' => 'As a nursing student, I needed professional help with a complex medical case study. The writer provided detailed patient analysis, evidence-based treatment evaluations, and proper medical terminology. The case study methodology and clinical reasoning were perfectly structured for my healthcare program.', 'author' => 'Sarah L.', 'role' => 'Nursing Student, Clinical Practice', 'rating' => 5, 'verified' => true, 'university' => 'Johns Hopkins School of Nursing'],
                        ['text' => 'The legal case study analysis was outstanding. The writer clearly identified key legal issues, applied relevant statutes and precedents, and provided well-reasoned arguments. The proper legal citations and case study formatting were perfect for my law course requirements.', 'author' => 'James K.', 'role' => 'Law Student, Constitutional Law', 'rating' => 5, 'verified' => true, 'university' => 'Harvard Law School'],
                    ],
                    'trustMetrics' => [
                        'totalReviews' => '1,847',
                        'averageRating' => '4.9',
                        'satisfactionRate' => '99%',
                        'repeatCustomers' => '91%',
                    ],
                ],
            ],
            [
                'block_type' => 'service_faqs',
                'block_key' => 'case_study_faqs',
                'order' => 6,
                'content' => [
                    'title' => 'Case Study Writing Service FAQs',
                    'description' => 'Common questions about our professional case study help and case study writing services',
                    'faqs' => [
                        ['question' => 'What types of case studies can your case study writing service handle?', 'answer' => 'Our professional case study writing service handles all types of case studies across disciplines including business case studies (company analysis, marketing strategy, operations management), medical case studies (patient cases, clinical evaluations), legal case studies (precedent analysis, case briefs), academic case studies (research methodology, theoretical analysis), and specialized case studies in psychology, engineering, education, and social sciences. Our case study writers have relevant professional experience in each field.'],
                        ['question' => 'How do you ensure proper case study analysis and structure?', 'answer' => 'Our case study writing service follows discipline-specific formats and analytical frameworks. For business case studies, we use structured approaches like situation analysis, problem identification, alternative solutions, and implementation recommendations. Medical case studies follow clinical assessment protocols with patient history, examination, assessment, and treatment plans. Legal case studies use IRAC methodology (Issue, Rule, Application, Conclusion). We adapt our case study methodology to meet your specific institutional requirements.'],
                        ['question' => 'Can you include specific analytical frameworks in case study writing?', 'answer' => 'Yes, our case study writing service incorporates appropriate analytical frameworks for comprehensive analysis. For business case studies, we commonly apply SWOT analysis, Porter\'s Five Forces, PESTEL analysis, BCG matrix, value chain analysis, and other strategic frameworks. For healthcare case studies, we use clinical assessment tools, treatment protocols, and outcome measurement frameworks. Our professional case study writers are trained in proper application of these analytical tools.'],
                        ['question' => 'Do you provide data visualization in case study writing services?', 'answer' => 'Yes, our case study writing service includes professional data visualization elements like charts, graphs, diagrams, and tables to enhance case study presentation and analysis. For business case studies, this includes market share charts, financial trend graphs, and organizational diagrams. For medical case studies, we incorporate patient data charts, treatment comparison graphs, and clinical illustrations. All visual elements are properly labeled, referenced, and integrated into the case study analysis.'],
                        ['question' => 'How do you handle confidential information in case study writing?', 'answer' => 'Our case study writing service prioritizes confidentiality and ethical handling of sensitive information. For business case studies using real company data, we ensure proper anonymization when required and follow academic integrity guidelines. For medical case studies, we strictly adhere to HIPAA compliance and patient privacy protocols. All case study writers sign comprehensive confidentiality agreements, and we use secure systems for data handling. We can work with anonymized data or help create composite cases that maintain analytical value while protecting sensitive information.'],
                        ['question' => 'What qualifications do your case study writers have?', 'answer' => 'Our case study writers hold advanced degrees in their respective fields with practical industry experience. Business case study writers typically have MBA degrees and corporate experience in strategy, consulting, or management. Medical case study writers include healthcare professionals with clinical experience and advanced medical degrees. Legal case study writers have JD degrees and legal practice experience. All writers undergo rigorous screening including credential verification, writing samples evaluation, and case study methodology assessment to ensure expert-level case study analysis capabilities.'],
                        ['question' => 'Can you help with case study presentations and visual materials?', 'answer' => 'Yes, our case study writing service includes presentation support and visual materials development. We can create PowerPoint presentations, executive summaries, case study briefs, and visual aids to accompany your written case study. For business case studies, this includes strategic recommendation slides, financial analysis charts, and implementation timelines. For academic case studies, we provide presentation outlines, key findings summaries, and discussion points. All presentation materials maintain consistency with your written case study analysis.'],
                        ['question' => 'How do you ensure originality in case study writing services?', 'answer' => 'Our case study writing service guarantees 100% original analysis and content. Each case study is developed from scratch using fresh research, original analysis, and custom methodology application. We never reuse previous case studies or use template-based approaches. All case study work undergoes plagiarism checking using advanced detection tools (Turnitin, Copyscape), and we provide detailed originality reports. Our case study writers conduct independent research and analysis to ensure completely original insights and recommendations for every project.'],
                    ],
                ],
            ],
            [
                'block_type' => 'service_cta',
                'block_key' => 'case_study_cta',
                'order' => 7,
                'content' => [
                    'title' => 'Ready to Get Professional Case Study Help That Delivers Results?',
                    'description' => 'Join over 8,500 successful students and professionals who\'ve achieved excellence with our expert case study writing service. Get comprehensive case study analysis from industry specialists today.',
                    'benefits' => [
                        ['text' => 'Professional case study writers with industry expertise', 'icon' => '🏆'],
                        ['text' => 'Comprehensive analysis with proven methodologies', 'icon' => '🔍'],
                        ['text' => 'Professional data visualization and formatting', 'icon' => '📊'],
                        ['text' => '24/7 support with satisfaction guarantee', 'icon' => '🛡️'],
                    ],
                    'primaryButtonText' => 'Get Professional Case Study Help Now',
                    'primaryButtonLink' => '/place-order',
                    'secondaryButtonText' => 'Free Case Study Consultation',
                    'secondaryButtonLink' => '/contact',
                    'bgColor' => 'blue',
                    'urgencyText' => 'Limited Time: 15% OFF for new customers',
                    'guarantees' => [
                        '100% Original Analysis',
                        'On-Time Delivery',
                        'Money-Back Guarantee',
                        'Unlimited Revisions',
                        '24/7 Support',
                    ],
                    'trustBadges' => [
                        'SSL Secured',
                        'Privacy Protected',
                        'Verified Writers',
                        'Industry Expertise',
                    ],
                ],
            ],
            [
                'block_type' => 'internal_links',
                'block_key' => 'case_study_related_services',
                'order' => 8,
                'content' => [
                    'title' => 'Related Academic Writing Services',
                    'description' => 'Explore our comprehensive range of academic writing services',
                    'links' => [
                        ['title' => 'Essay Writing Service', 'url' => '/services/essay-writing', 'description' => 'Professional essay writing for all academic levels'],
                        ['title' => 'Research Paper Writing Service', 'url' => '/services/research-papers', 'description' => 'Expert research paper writing with comprehensive analysis'],
                        ['title' => 'Dissertation Writing Service', 'url' => '/services/dissertation-writing', 'description' => 'PhD dissertation help and doctoral thesis writing'],
                    ],
                ],
            ],
            [
                'block_type' => 'internal_links',
                'block_key' => 'case_study_support_pages',
                'order' => 9,
                'content' => [
                    'title' => 'Learn More About Our Case Study Writing Service',
                    'description' => 'Get detailed information about our case study writing specialists and pricing',
                    'links' => [
                        ['title' => 'Our Writers', 'url' => '/writers', 'description' => 'Meet our case study writing specialists'],
                        ['title' => 'Pricing', 'url' => '/pricing-page', 'description' => 'Transparent case study writing pricing'],
                        ['title' => 'Guarantees', 'url' => '/guarantees', 'description' => 'Our quality and satisfaction guarantees'],
                        ['title' => 'Reviews', 'url' => '/reviews', 'description' => 'Read customer reviews and testimonials'],
                    ],
                ],
            ],
            [
                'block_type' => 'internal_links',
                'block_key' => 'case_study_resource_links',
                'order' => 10,
                'content' => [
                    'title' => 'Professional Case Study Writing Service Resources',
                    'links' => [
                        ['title' => 'Case Study Writing Guide', 'url' => '/blog/case-study-writing-guide', 'description' => 'Complete guide to writing effective case studies'],
                        ['title' => 'Business Case Study Analysis', 'url' => '/blog/business-case-study-analysis', 'description' => 'How to analyze business cases effectively'],
                        ['title' => 'Medical Case Study Format', 'url' => '/blog/medical-case-study-format', 'description' => 'Proper formatting for medical case studies'],
                        ['title' => 'Case Study Presentation Tips', 'url' => '/blog/case-study-presentation-tips', 'description' => 'Tips for presenting case study findings'],
                    ],
                ],
            ],
        ];

        // Upsert content blocks
        foreach ($blocks as $i => $block) {
            PageContent::updateOrCreate(
                [
                    'page_id' => $page->id,
                    'block_key' => $block['block_key'],
                ],
                [
                    'block_type' => $block['block_type'],
                    'content' => $block['content'],
                    'order' => $block['order'] ?? ($i + 1),
                    'is_active' => true,
                ]
            );
        }

        $this->command->info('Case Studies service content seeded successfully!');
    }
}
