<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageSeo;
use App\Models\PageContent;

class SeedServicePersonalStatements extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Update existing page for Personal Statements service
        $page = Page::updateOrCreate(
            ['slug' => 'personal-statements'],
            [
                'title' => 'Personal Statement Writing Service',
                'page_type' => 'service',
                'status' => 'published',
                'template' => 'Services/PersonalStatements',
                'seo_priority' => 90,
                'published_at' => now(),
            ]
        );

        // Structured data with all schemas including FAQ
        $structuredData = [
            'service' => [
                '@context' => 'https://schema.org',
                '@type' => 'Service',
                'name' => 'Professional Personal Statement Writing Service',
                'description' => 'Expert personal statement writing service providing custom personal statement help with professional writers, original content, comprehensive analysis, and cultural expertise for college, graduate school, medical school, law school, MBA, scholarship, and international student applications.',
                'provider' => [
                    '@type' => 'Organization',
                    'name' => 'Academic Scribe',
                    'url' => 'https://academicscribe.com',
                    'logo' => 'https://academicscribe.com/images/logo.png',
                    'contactPoint' => [
                        '@type' => 'ContactPoint',
                        'telephone' => '+1-555-123-4567',
                        'contactType' => 'customer service',
                        'availableLanguage' => ['English'],
                        'areaServed' => 'Worldwide',
                    ],
                    'address' => [
                        '@type' => 'PostalAddress',
                        'addressCountry' => 'US',
                        'addressRegion' => 'Global',
                    ],
                    'sameAs' => [
                        'https://facebook.com/academicscribe',
                        'https://twitter.com/academicscribe',
                        'https://linkedin.com/company/academicscribe',
                    ],
                ],
                'serviceType' => 'Personal Statement Writing Service',
                'areaServed' => 'Worldwide',
                'availableChannel' => [
                    '@type' => 'ServiceChannel',
                    'serviceUrl' => 'https://academicscribe.com/services/personal-statements',
                    'servicePhone' => '+1-555-123-4567',
                    'availableLanguage' => 'English',
                ],
                'hasOfferCatalog' => [
                    '@type' => 'OfferCatalog',
                    'name' => 'Personal Statement Writing Services',
                    'itemListElement' => [
                        [
                            '@type' => 'Offer',
                            'itemOffered' => [
                                '@type' => 'Service',
                                'name' => 'College Personal Statement Help',
                                'description' => 'Professional personal statement writing for undergraduate admissions with compelling storytelling',
                            ],
                            'price' => 'Starting at $15.99',
                            'priceCurrency' => 'USD',
                            'availability' => 'https://schema.org/InStock',
                        ],
                        [
                            '@type' => 'Offer',
                            'itemOffered' => [
                                '@type' => 'Service',
                                'name' => 'Graduate School Personal Statement',
                                'description' => 'Expert personal statement writing for Master\'s and PhD program applications',
                            ],
                            'price' => 'Starting at $18.99',
                            'priceCurrency' => 'USD',
                            'availability' => 'https://schema.org/InStock',
                        ],
                        [
                            '@type' => 'Offer',
                            'itemOffered' => [
                                '@type' => 'Service',
                                'name' => 'Medical School Personal Statement',
                                'description' => 'Specialized personal statement writing for medical school admissions with healthcare focus',
                            ],
                            'price' => 'Starting at $22.99',
                            'priceCurrency' => 'USD',
                            'availability' => 'https://schema.org/InStock',
                        ],
                        [
                            '@type' => 'Offer',
                            'itemOffered' => [
                                '@type' => 'Service',
                                'name' => 'International Student Personal Statement',
                                'description' => 'Cultural bridge personal statement writing for Chinese, Arab, and international students',
                            ],
                            'price' => 'Starting at $19.99',
                            'priceCurrency' => 'USD',
                            'availability' => 'https://schema.org/InStock',
                        ],
                    ],
                ],
            ],
            'organization' => [
                '@context' => 'https://schema.org',
                '@type' => 'Organization',
                'name' => 'Academic Scribe',
                'description' => 'Professional personal statement writing services with expert writers providing custom personal statement help and comprehensive application assistance for students worldwide, specializing in college, graduate school, medical school, and international student applications.',
                'url' => 'https://academicscribe.com',
                'logo' => 'https://academicscribe.com/images/logo.png',
                'image' => 'https://academicscribe.com/images/personal-statement-writing-service.jpg',
                'contactPoint' => [
                    '@type' => 'ContactPoint',
                    'telephone' => '+1-555-123-4567',
                    'contactType' => 'customer service',
                    'availableLanguage' => ['English'],
                    'areaServed' => 'Worldwide',
                ],
                'address' => [
                    '@type' => 'PostalAddress',
                    'addressCountry' => 'US',
                    'addressRegion' => 'Global',
                ],
                'sameAs' => [
                    'https://facebook.com/academicscribe',
                    'https://twitter.com/academicscribe',
                    'https://linkedin.com/company/academicscribe',
                ],
            ],
            'faq' => [
                '@context' => 'https://schema.org',
                '@type' => 'FAQPage',
                'mainEntity' => [
                    [
                        '@type' => 'Question',
                        'name' => 'What types of personal statements does your writing service handle?',
                        'acceptedAnswer' => [
                            '@type' => 'Answer',
                            'text' => 'Our professional personal statement writing service handles all types of personal statements including college application personal statements, graduate school personal statements, medical school personal statements, law school personal statements, MBA personal statements, PhD personal statements, nursing school personal statements, scholarship personal statements, and transfer student personal statements. Our custom personal statement help covers all academic levels and program types, with specialized expertise for international students including Chinese and Arab students applying to US, UK, Canadian, and Australian universities.',
                        ],
                    ],
                    [
                        '@type' => 'Question',
                        'name' => 'How do you help international students with personal statements?',
                        'acceptedAnswer' => [
                            '@type' => 'Answer',
                            'text' => 'Our personal statement writing service specializes in helping international students, particularly Chinese students and Arab students from Kuwait, UAE, Saudi Arabia, and Qatar. We provide cultural bridge writing that translates international experiences for Western admissions committees, address language barriers with native English expression, help overcome cultural modesty challenges, and provide 24/7 support across different time zones. Our writers understand different educational systems (Gaokao, British curriculum, IB, CBSE) and help students present their unique backgrounds, family expectations, cultural values, and international perspectives compellingly to admissions committees at US, UK, Canadian, and Australian universities.',
                        ],
                    ],
                ],
            ],
            'breadcrumb' => [
                '@context' => 'https://schema.org',
                '@type' => 'BreadcrumbList',
                'itemListElement' => [
                    [
                        '@type' => 'ListItem',
                        'position' => 1,
                        'name' => 'Home',
                        'item' => 'https://academicscribe.com',
                    ],
                    [
                        '@type' => 'ListItem',
                        'position' => 2,
                        'name' => 'Services',
                        'item' => 'https://academicscribe.com/services',
                    ],
                    [
                        '@type' => 'ListItem',
                        'position' => 3,
                        'name' => 'Personal Statement Writing Service',
                        'item' => 'https://academicscribe.com/services/personal-statements',
                    ],
                ],
            ],
            'website' => [
                '@context' => 'https://schema.org',
                '@type' => 'WebSite',
                'name' => 'Academic Scribe - Personal Statement Writing Service',
                'description' => 'Professional personal statement writers providing custom personal statement help and comprehensive application assistance for college, graduate school, medical school, and international student admissions.',
                'url' => 'https://academicscribe.com/services/personal-statements',
                'potentialAction' => [
                    '@type' => 'OrderAction',
                    'target' => 'https://academicscribe.com/place-order',
                    'object' => [
                        '@type' => 'Service',
                        'name' => 'Personal Statement Writing Service',
                    ],
                ],
            ],
            'webpage' => [
                '@context' => 'https://schema.org',
                '@type' => 'WebPage',
                'name' => 'Professional Personal Statement Writing Service | Custom Personal Statement Help',
                'description' => 'Expert personal statement writing service with professional writers. Get custom personal statement help for college, graduate school, medical school, and scholarship applications with original content, cultural expertise, and guaranteed results.',
                'url' => 'https://academicscribe.com/services/personal-statements',
                'isPartOf' => [
                    '@type' => 'WebSite',
                    'name' => 'Academic Scribe',
                    'url' => 'https://academicscribe.com',
                ],
                'about' => [
                    '@type' => 'Service',
                    'name' => 'Personal Statement Writing Service',
                ],
                'mainEntity' => [
                    '@type' => 'Service',
                    'name' => 'Professional Personal Statement Writing Service',
                ],
            ],
        ];

        // SEO data
        PageSeo::updateOrCreate(
            ['page_id' => $page->id],
            [
                'meta_title' => 'Professional Personal Statement Writing Service | Custom Personal Statement Help | Expert Writers | Academic Scribe',
                'meta_description' => 'Get expert personal statement writing service with professional writers. Custom personal statement help for college, graduate school, medical school, and scholarship applications with original content, cultural expertise, and 24/7 support. Order now for guaranteed acceptance!',
                'meta_keywords' => 'personal statement writing service, professional personal statement writing, custom personal statement help, personal statement writer, college application personal statement, graduate school personal statement, medical school personal statement, personal statement assistance, scholarship personal statement, personal statement editing, MBA personal statement, law school personal statement, personal statement examples, personal statement for international students, Chinese students personal statement, Arab students personal statement',
                'canonical_url' => 'https://academicscribe.com/services/personal-statements',
                'og_url' => 'https://academicscribe.com/services/personal-statements',
                'robots' => 'index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1',
                'language' => 'en-US',
                'structured_data' => $structuredData,
                'twitter_card' => 'summary_large_image',
                'twitter_title' => 'Professional Personal Statement Writing Service | Custom Personal Statement Help | Expert Writers',
                'twitter_description' => 'Expert personal statement writing service with professional writers. Get custom personal statement help with original content, cultural expertise, and guaranteed results for your applications.',
                'twitter_image' => 'https://academicscribe.com/images/personal-statement-writing-service-twitter.jpg',
                'og_title' => 'Professional Personal Statement Writing Service | Custom Personal Statement Help | Expert Writers',
                'og_description' => 'Expert personal statement writing service with professional writers. Get custom personal statement help for college, graduate school, medical school, and scholarship applications with original content and cultural expertise. Trusted by 15,000+ students worldwide.',
                'og_image' => 'https://academicscribe.com/images/personal-statement-writing-service-og.jpg',
                'og_type' => 'website',
            ]
        );

        // Delete old blocks first
        PageContent::where('page_id', $page->id)->delete();

        // Content blocks
        $blocks = [
            [
                'block_type' => 'service_hero',
                'block_key' => 'personal_statement_hero',
                'order' => 1,
                'content' => [
                    'title' => 'Professional Personal Statement Writing Service | Expert Custom Personal Statement Help',
                    'description' => 'Get expert personal statement writing service from professional writers with advanced degrees. Our custom personal statement help covers college admissions, graduate school, medical school, law school, MBA, and scholarship applications with original content, compelling storytelling, and cultural expertise. Trusted by 15,000+ students worldwide with 24/7 support and guaranteed acceptance results.',
                    'keyPoints' => [
                        'Professional personal statement writers with expertise in your target program and field',
                        'Custom personal statement help with 100% original content and compelling storytelling',
                        'Specialized assistance for international students including Chinese and Arab students',
                        'Complete application support for college, graduate school, medical school, and scholarship programs',
                        'Cultural bridge writing that translates your unique experiences for admissions committees',
                    ],
                    'ctaText' => 'Get Professional Personal Statement Help Now',
                    'ctaLink' => '/contact',
                    'trustSignals' => [
                        '15,000+ successful applications',
                        '4.9/5 average rating',
                        '24/7 cultural expertise support',
                        'Acceptance guarantee or money back',
                    ],
                ],
            ],
            [
                'block_type' => 'service_overview',
                'block_key' => 'personal_statement_overview',
                'order' => 2,
                'content' => [
                    'title' => 'Our Comprehensive Personal Statement Writing Service',
                    'description' => 'We provide professional personal statement writing across all application types with expert storytelling and cultural sensitivity. Our custom personal statement help includes original content, compelling narratives, and comprehensive application support for students at all educational levels and backgrounds.',
                    'features' => [
                        [
                            'title' => 'Expert Personal Statement Writers',
                            'description' => 'Professional personal statement writers with advanced degrees and admissions expertise who understand what colleges, graduate schools, and professional programs seek in compelling personal statements',
                            'icon' => 'Award',
                        ],
                        [
                            'title' => 'Cultural Bridge Writing Expertise',
                            'description' => 'Specialized personal statement help for international students, particularly Chinese and Arab students, with cultural sensitivity and experience translating diverse backgrounds for Western admissions committees',
                            'icon' => 'Users',
                        ],
                        [
                            'title' => 'All Application Types Covered',
                            'description' => 'Personal statement writing service covering college admissions, graduate school, medical school, law school, MBA, PhD, nursing, scholarship, and transfer applications with program-specific expertise',
                            'icon' => 'BookOpen',
                        ],
                        [
                            'title' => 'Compelling Storytelling & Formatting',
                            'description' => 'Professional personal statement assistance with engaging narratives, perfect structure, authentic voice, and admissions-focused content that showcases your unique qualifications and experiences',
                            'icon' => 'FileText',
                        ],
                    ],
                ],
            ],
            [
                'block_type' => 'service_process',
                'block_key' => 'personal_statement_process',
                'order' => 3,
                'content' => [
                    'title' => 'Our Professional Personal Statement Writing Process',
                    'description' => 'We follow a structured, personalized approach to deliver exceptional personal statement writing service with compelling storytelling, cultural sensitivity, and admissions expertise that maximizes your acceptance chances.',
                    'steps' => [
                        ['number' => 1, 'title' => 'Application Analysis & Goal Setting', 'description' => 'Comprehensive analysis of your target programs, admission requirements, application deadlines, and personal background to establish clear direction for your custom personal statement help project with strategic planning.', 'icon' => 'Target'],
                        ['number' => 2, 'title' => 'Personal Story Development & Interview', 'description' => 'In-depth consultation to understand your unique experiences, motivations, achievements, and goals, developing compelling personal narratives that resonate with admissions committees for your personal statement writing service.', 'icon' => 'Users'],
                        ['number' => 3, 'title' => 'Research & Program Alignment', 'description' => 'Thorough research of your target programs, institutional values, and admission preferences to align your personal statement with specific requirements and demonstrate perfect fit for custom personal statement help.', 'icon' => 'Search'],
                        ['number' => 4, 'title' => 'Professional Personal Statement Writing', 'description' => 'Expert personal statement writers craft your compelling narrative with authentic voice, engaging storytelling, clear structure, and program-specific focus that showcases your unique qualifications and potential.', 'icon' => 'Edit'],
                        ['number' => 5, 'title' => 'Cultural Bridge & Language Enhancement', 'description' => 'Specialized editing for international students to ensure natural English expression, cultural translation, and effective presentation of diverse experiences for Western admissions committees.', 'icon' => 'Globe'],
                        ['number' => 6, 'title' => 'Quality Review & Final Delivery', 'description' => 'Comprehensive review, editing, and proofreading to ensure your personal statement meets admission standards, program requirements, and excellence expectations for professional personal statement writing service delivery.', 'icon' => 'CheckCircle'],
                    ],
                ],
            ],
            [
                'block_type' => 'service_benefits',
                'block_key' => 'personal_statement_benefits',
                'order' => 4,
                'content' => [
                    'title' => 'Why Choose Our Professional Personal Statement Writing Service',
                    'description' => 'Discover why over 15,000 students choose our expert personal statement assistance for their academic success and admission to top programs worldwide',
                    'benefits' => [
                        ['title' => 'Program-Specific Personal Statement Writers', 'description' => 'Professional personal statement writers with advanced degrees and admissions expertise in your specific field who understand program requirements, selection criteria, and what admissions committees seek in compelling applications', 'icon' => 'Award'],
                        ['title' => 'Cultural Expertise for International Students', 'description' => 'Specialized personal statement help for Chinese students, Arab students from Kuwait/UAE/Saudi/Qatar, and other international students with cultural bridge writing that translates diverse experiences effectively', 'icon' => 'Globe'],
                        ['title' => 'All Application Types & Academic Levels', 'description' => 'Personal statement writing service covering undergraduate, graduate, professional school, scholarship, and transfer applications with expertise in college, medical school, law school, MBA, PhD, and nursing programs', 'icon' => 'BookOpen'],
                        ['title' => 'Compelling Storytelling & Authentic Voice', 'description' => 'Custom personal statement help with engaging narratives, authentic voice development, compelling opening hooks, and memorable conclusions that showcase your unique personality and qualifications', 'icon' => 'FileText'],
                        ['title' => 'Guaranteed Results & Complete Support', 'description' => 'Professional personal statement writing service with acceptance guarantee, unlimited revisions, 24/7 customer support, deadline compliance, and money-back guarantee for your complete satisfaction and admission success', 'icon' => 'Shield'],
                    ],
                    'imageAlt' => 'Professional Personal Statement Writing Service Benefits - Custom Personal Statement Help with Expert Writers and Cultural Expertise',
                    'ctaText' => 'Order Professional Personal Statement Now',
                    'ctaLink' => '/place-order',
                    'guarantees' => [
                        '100% Original Content',
                        'Acceptance Guarantee',
                        '24/7 Support',
                        'Money-Back Guarantee',
                        'Unlimited Revisions',
                    ],
                ],
            ],
            [
                'block_type' => 'service_testimonials',
                'block_key' => 'personal_statement_testimonials',
                'order' => 5,
                'content' => [
                    'title' => 'What Our Personal Statement Writing Service Clients Say',
                    'description' => 'Read authentic testimonials from students who\'ve achieved admission success with our professional personal statement assistance',
                    'testimonials' => [
                        ['text' => 'The personal statement writing service exceeded my expectations! As a Chinese student, I struggled with expressing my experiences in a way that would resonate with American admissions committees. The writer helped me craft a compelling narrative that got me into Harvard Medical School. The cultural bridge writing was exactly what I needed.', 'author' => 'Wei Chen', 'role' => 'Medical School Student', 'rating' => 5, 'verified' => true, 'university' => 'Harvard Medical School'],
                        ['text' => 'I needed help with my MBA personal statement and was impressed by the quality of writing and strategic approach. The custom personal statement help included detailed consultation, multiple revisions, and perfect alignment with Wharton\'s values. The writer understood exactly what business schools look for.', 'author' => 'Sarah M.', 'role' => 'MBA Student', 'rating' => 5, 'verified' => true, 'university' => 'Wharton School'],
                        ['text' => 'As a student from Kuwait applying to law schools in the United Kingdom, I needed professional personal statement assistance that could bridge my Arab background with American legal education. The personal statement writing service delivered an outstanding essay that helped me get accepted to multiple top law schools with scholarship offers.', 'author' => 'Omar Al-Rashid', 'role' => 'Law School Student', 'rating' => 5, 'verified' => true, 'university' => 'Columbia Law School'],
                    ],
                    'trustMetrics' => [
                        'totalReviews' => '2,134',
                        'averageRating' => '4.9',
                        'satisfactionRate' => '98%',
                        'repeatCustomers' => '94%',
                    ],
                ],
            ],
            [
                'block_type' => 'service_faqs',
                'block_key' => 'personal_statement_faqs',
                'order' => 6,
                'content' => [
                    'title' => 'Personal Statement Writing Service FAQs',
                    'description' => 'Get answers to common questions about our professional personal statement assistance and custom personal statement help services',
                    'faqs' => [
                        ['question' => 'What types of personal statements does your writing service handle?', 'answer' => 'Our professional personal statement writing service handles all types of personal statements including college application personal statements, graduate school personal statements, medical school personal statements, law school personal statements, MBA personal statements, PhD personal statements, nursing school personal statements, scholarship personal statements, transfer student personal statements, and professional program applications. Our custom personal statement help covers all academic levels from undergraduate to doctoral programs, across all disciplines including STEM, humanities, business, healthcare, and specialized fields. We also handle specific application types like AMCAS, AACOMAS, TMDSAS for medical school, LSAC for law school, and Common Application essays.'],
                        ['question' => 'How do you help international students with personal statements?', 'answer' => 'Our personal statement writing service specializes in helping international students, particularly Chinese students and Arab students from Kuwait, UAE, Saudi Arabia, and Qatar. We provide cultural bridge writing that translates international experiences for Western admissions committees, address language barriers with native English expression, help overcome cultural modesty challenges, and provide 24/7 support across different time zones. Our writers understand different educational systems (Gaokao, British curriculum, IB, CBSE) and help students present their unique backgrounds, family expectations, cultural values, and international perspectives compellingly to admissions committees at US, UK, Canadian, and Australian universities.'],
                        ['question' => 'What makes your personal statement writers qualified?', 'answer' => 'Our personal statement writers hold advanced degrees (Master\'s and PhD) in their respective fields with extensive admissions and application writing experience. Each professional personal statement writer undergoes rigorous screening including academic credential verification, writing portfolio review, admissions expertise testing, and personal statement assessment. Our team includes former admissions officers, published authors, academic specialists, and writing experts with proven track records in successful applications. We match each project with writers who have specific knowledge and experience in your target program type, academic field, and cultural background for optimal results.'],
                        ['question' => 'How do you ensure my personal statement is unique and authentic?', 'answer' => 'Our personal statement writing service guarantees 100% original content through comprehensive plagiarism checks, custom writing from scratch, and authentic voice development. Our professional personal statement writers create unique content for each client through detailed consultations, personal story development, and individual narrative crafting. We avoid template-based approaches, generic content, and pre-written statements. Every custom personal statement help order includes detailed originality reports, authentic voice coaching, and personalized content that reflects your specific experiences, goals, and personality while meeting program-specific requirements.'],
                        ['question' => 'What is your process for medical school personal statements?', 'answer' => 'Our medical school personal statement writing process includes specialized consultation focused on healthcare motivation, patient interaction experiences, research background, volunteer work, and clinical exposure. Our professional personal statement writers with medical expertise help craft compelling narratives that demonstrate your commitment to medicine, understanding of healthcare challenges, empathy, leadership, and academic readiness for medical education. We understand AMCAS requirements, character limits, and what medical school admissions committees seek in successful applicants, including diversity contributions, overcoming challenges, and future physician qualities.'],
                        ['question' => 'Do you provide personal statement help for scholarship applications?', 'answer' => 'Yes, our personal statement writing service includes specialized scholarship application assistance for merit-based scholarships, need-based financial aid, demographic-specific scholarships (minority, first-generation, international), and prestigious awards like Fulbright, Rhodes, Gates Cambridge, and institutional scholarships. Our custom personal statement help for scholarships focuses on academic achievement, leadership potential, community impact, financial need demonstration, and alignment with scholarship values and objectives. We understand different scholarship requirements and help craft compelling narratives that maximize your funding opportunities.'],
                        ['question' => 'How do you handle tight deadlines for personal statement writing?', 'answer' => 'Our professional personal statement writing service offers expedited delivery options with rush services available for urgent deadlines. We maintain 24/7 operations with writers across different time zones to accommodate last-minute application deadlines, rolling admissions, and emergency situations. Our custom personal statement help includes priority processing, dedicated writer assignment, accelerated review cycles, and immediate customer support for urgent projects. However, we recommend starting early to allow sufficient time for consultation, revision, and optimization of your personal statement for best results.'],
                        ['question' => 'What support do you provide after delivering my personal statement?', 'answer' => 'Our personal statement writing service includes comprehensive post-delivery support with unlimited free revisions within 30 days, formatting adjustments, content modifications based on program feedback, and additional consultation for related applications. Our 24/7 customer support team provides ongoing assistance with submission questions, application guidance, and follow-up support throughout your admission process. We also offer interview preparation, supplemental essay assistance, and guidance on leveraging your personal statement for scholarship applications and other opportunities. Our commitment extends beyond delivery to ensure your complete admission success.'],
                    ],
                ],
            ],
            [
                'block_type' => 'service_cta',
                'block_key' => 'personal_statement_cta',
                'order' => 7,
                'content' => [
                    'title' => 'Ready to Get Professional Personal Statement Help That Guarantees Admission Success?',
                    'description' => 'Join over 15,000 successful students who\'ve achieved their dream admissions with our expert personal statement writing service. Get custom personal statement help from professional writers with program-specific expertise today.',
                    'benefits' => [
                        ['text' => 'Professional personal statement writers with program-specific expertise', 'icon' => '🏆'],
                        ['text' => 'Cultural bridge writing for international students worldwide', 'icon' => '🌍'],
                        ['text' => '100% original content with compelling storytelling guaranteed', 'icon' => '📄'],
                        ['text' => '24/7 support with acceptance guarantee or money back', 'icon' => '🛡️'],
                    ],
                    'primaryButtonText' => 'Get Professional Personal Statement Help Now',
                    'primaryButtonLink' => '/place-order',
                    'secondaryButtonText' => 'Free Personal Statement Consultation',
                    'secondaryButtonLink' => '/contact',
                    'bgColor' => 'blue',
                    'urgencyText' => 'Limited Time: 20% OFF for new customers + Free consultation',
                    'guarantees' => [
                        '100% Original Content',
                        'Acceptance Guarantee',
                        'Money-Back Guarantee',
                        'Unlimited Revisions',
                        '24/7 Support',
                    ],
                    'trustBadges' => [
                        'SSL Secured',
                        'Privacy Protected',
                        'Verified Writers',
                        'Admission Success',
                    ],
                ],
            ],
            [
                'block_type' => 'internal_links',
                'block_key' => 'personal_statement_related_services',
                'order' => 8,
                'content' => [
                    'title' => 'Related Academic Writing Services',
                    'description' => 'Explore our comprehensive range of academic writing services',
                    'links' => [
                        ['title' => 'Essay Writing Service', 'url' => '/services/essay-writing', 'description' => 'Professional essay writing help for all academic levels and subjects'],
                        ['title' => 'Research Paper Writing Service', 'url' => '/services/research-papers', 'description' => 'Expert research paper assistance with thorough analysis and citations'],
                        ['title' => 'Dissertation Writing Service', 'url' => '/services/dissertation-writing', 'description' => 'PhD dissertation help and comprehensive thesis writing support'],
                        ['title' => 'Assignment Help Service', 'url' => '/services/assignments', 'description' => 'Professional assignment assistance for all academic subjects'],
                    ],
                ],
            ],
            [
                'block_type' => 'internal_links',
                'block_key' => 'personal_statement_support_pages',
                'order' => 9,
                'content' => [
                    'title' => 'Learn More About Our Personal Statement Writing Service',
                    'description' => 'Get detailed information about our personal statement specialists',
                    'links' => [
                        ['title' => 'Our Writers', 'url' => '/writers', 'description' => 'Meet our personal statement writing specialists'],
                        ['title' => 'Pricing', 'url' => '/pricing-page', 'description' => 'Transparent personal statement writing pricing'],
                        ['title' => 'Guarantees', 'url' => '/guarantees', 'description' => 'Our quality and satisfaction guarantees'],
                        ['title' => 'Reviews', 'url' => '/reviews', 'description' => 'Read customer reviews and success stories'],
                    ],
                ],
            ],
            [
                'block_type' => 'internal_links',
                'block_key' => 'personal_statement_resource_links',
                'order' => 10,
                'content' => [
                    'title' => 'Professional Personal Statement Writing Service Resources',
                    'links' => [
                        ['title' => 'Personal Statement Writing Guide for Chinese Students: Overcoming Cultural and Language Barriers', 'url' => '/blog/personal-statement-guide-chinese-students-cultural-language-barriers', 'description' => 'Complete guide for Chinese students applying to Western universities'],
                        ['title' => 'Arab Students\' Personal Statement Success: Complete Guide for Kuwait, UAE, Saudi Arabia & Qatar Applications', 'url' => '/blog/arab-students-personal-statement-kuwait-uae-saudi-qatar-guide', 'description' => 'Specialized guidance for Arab students from Gulf countries'],
                        ['title' => 'How to Write a Personal Statement That Gets You Accepted: 2025 Complete Guide', 'url' => '/blog/how-to-write-personal-statement-ultimate-2025-complete-guide', 'description' => 'Comprehensive guide to writing winning personal statements in 2025'],
                        ['title' => 'Medical School Personal Statement Examples: What Admissions Committees Really Want to See', 'url' => '/blog/medical-school-personal-statement-examples-admissions-guide', 'description' => 'Expert guidance and examples for medical school applications'],
                        ['title' => '10 Personal Statement Mistakes That Will Destroy Your Application (And How to Fix Them)', 'url' => '/blog/personal-statement-mistakes-destroy-application-how-to-fix', 'description' => 'Common personal statement errors and how to avoid them'],
                    ],
                ],
            ],
        ];

        // Create content blocks
        foreach ($blocks as $i => $block) {
            PageContent::create([
                'page_id' => $page->id,
                'block_type' => $block['block_type'],
                'block_key' => $block['block_key'],
                'content' => $block['content'],
                'order' => $block['order'] ?? ($i + 1),
                'is_active' => true,
            ]);
        }

        $this->command->info('Personal Statements service content seeded successfully!');
    }
}
