<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageSeo;
use App\Models\PageContent;

class SeedServiceProgrammingAssignments extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Update existing page for Programming Assignments service
        $page = Page::updateOrCreate(
            ['slug' => 'programming-assignments'],
            [
                'title' => 'Programming Assignment Help',
                'page_type' => 'service',
                'status' => 'published',
                'template' => 'Services/ProgrammingAssignments',
                'seo_priority' => 85,
                'published_at' => now(),
            ]
        );

        // Structured data
        $structuredData = [
            'service' => [
                '@context' => 'https://schema.org',
                '@type' => 'Service',
                'name' => 'Professional Programming Assignment Help',
                'description' => 'Expert programming assignment help providing custom coding assignment assistance with professional programmers, original code, comprehensive explanations, and perfect academic formatting for all programming languages and educational levels.',
                'provider' => [
                    '@type' => 'Organization',
                    'name' => 'Academic Scribe',
                    'url' => 'https://academicscribe.com',
                    'logo' => 'https://academicscribe.com/images/logo.png',
                    'contactPoint' => [
                        '@type' => 'ContactPoint',
                        'telephone' => '+1-555-123-4567',
                        'contactType' => 'customer service',
                        'availableLanguage' => ['English'],
                        'areaServed' => 'Worldwide',
                    ],
                    'address' => [
                        '@type' => 'PostalAddress',
                        'addressCountry' => 'US',
                        'addressRegion' => 'Global',
                    ],
                    'sameAs' => [
                        'https://facebook.com/academicscribe',
                        'https://twitter.com/academicscribe',
                        'https://linkedin.com/company/academicscribe',
                    ],
                ],
                'serviceType' => 'Academic Programming Service',
                'areaServed' => 'Worldwide',
                'availableChannel' => [
                    '@type' => 'ServiceChannel',
                    'serviceUrl' => 'https://academicscribe.com/services/programming-assignments',
                    'servicePhone' => '+1-555-123-4567',
                    'availableLanguage' => 'English',
                ],
                'hasOfferCatalog' => [
                    '@type' => 'OfferCatalog',
                    'name' => 'Programming Assignment Services',
                    'itemListElement' => [
                        [
                            '@type' => 'Offer',
                            'itemOffered' => [
                                '@type' => 'Service',
                                'name' => 'Python Programming Assignment Help',
                                'description' => 'Expert Python programming assistance with code writing and debugging',
                            ],
                            'price' => 'Starting at $15.99',
                            'priceCurrency' => 'USD',
                            'availability' => 'https://schema.org/InStock',
                        ],
                        [
                            '@type' => 'Offer',
                            'itemOffered' => [
                                '@type' => 'Service',
                                'name' => 'Java Programming Assignment Help',
                                'description' => 'Professional Java coding assistance with object-oriented programming',
                            ],
                            'price' => 'Starting at $15.99',
                            'priceCurrency' => 'USD',
                            'availability' => 'https://schema.org/InStock',
                        ],
                        [
                            '@type' => 'Offer',
                            'itemOffered' => [
                                '@type' => 'Service',
                                'name' => 'C++ Programming Assignment Help',
                                'description' => 'Expert C++ programming help with system-level programming',
                            ],
                            'price' => 'Starting at $15.99',
                            'priceCurrency' => 'USD',
                            'availability' => 'https://schema.org/InStock',
                        ],
                    ],
                ],
            ],
            'breadcrumb' => [
                '@context' => 'https://schema.org',
                '@type' => 'BreadcrumbList',
                'itemListElement' => [
                    [
                        '@type' => 'ListItem',
                        'position' => 1,
                        'name' => 'Home',
                        'item' => 'https://academicscribe.com',
                    ],
                    [
                        '@type' => 'ListItem',
                        'position' => 2,
                        'name' => 'Services',
                        'item' => 'https://academicscribe.com/services',
                    ],
                    [
                        '@type' => 'ListItem',
                        'position' => 3,
                        'name' => 'Programming Assignment Help',
                        'item' => 'https://academicscribe.com/services/programming-assignments',
                    ],
                ],
            ],
            'organization' => [
                '@context' => 'https://schema.org',
                '@type' => 'Organization',
                'name' => 'Academic Scribe',
                'description' => 'Professional academic writing services with expert programming assignment helpers providing custom coding assistance and comprehensive programming support for students worldwide.',
                'url' => 'https://academicscribe.com',
                'logo' => 'https://academicscribe.com/images/logo.png',
                'image' => 'https://academicscribe.com/images/programming-assignment-help.jpg',
                'contactPoint' => [
                    '@type' => 'ContactPoint',
                    'telephone' => '+1-555-123-4567',
                    'contactType' => 'customer service',
                    'availableLanguage' => ['English'],
                    'areaServed' => 'Worldwide',
                ],
                'address' => [
                    '@type' => 'PostalAddress',
                    'addressCountry' => 'US',
                    'addressRegion' => 'Global',
                ],
                'sameAs' => [
                    'https://facebook.com/academicscribe',
                    'https://twitter.com/academicscribe',
                    'https://linkedin.com/company/academicscribe',
                ],
            ],
            'website' => [
                '@context' => 'https://schema.org',
                '@type' => 'WebSite',
                'name' => 'Academic Scribe - Programming Assignment Help',
                'description' => 'Professional programming assignment helpers providing custom coding assistance and comprehensive programming assignment help service for students at all educational levels.',
                'url' => 'https://academicscribe.com/services/programming-assignments',
                'potentialAction' => [
                    '@type' => 'SearchAction',
                    'target' => 'https://academicscribe.com/search?q={search_term_string}',
                    'query-input' => 'required name=search_term_string',
                ],
            ],
            'webpage' => [
                '@context' => 'https://schema.org',
                '@type' => 'WebPage',
                'name' => 'Professional Programming Assignment Help | Expert Coding Assignment Service',
                'description' => 'Expert programming assignment help with professional coders. Get custom coding assignment help for Python, Java, C++, and all programming languages with guaranteed results.',
                'url' => 'https://academicscribe.com/services/programming-assignments',
                'isPartOf' => [
                    '@type' => 'WebSite',
                    'name' => 'Academic Scribe',
                    'url' => 'https://academicscribe.com',
                ],
                'about' => [
                    '@type' => 'Service',
                    'name' => 'Programming Assignment Help',
                ],
                'mainEntity' => [
                    '@type' => 'Service',
                    'name' => 'Professional Programming Assignment Help',
                ],
            ],
        ];

        // SEO data
        PageSeo::updateOrCreate(
            ['page_id' => $page->id],
            [
                'meta_title' => 'Professional Programming Assignment Help | Expert Coding Assignment Service | Academic Scribe',
                'meta_description' => 'Get expert programming assignment help with professional coders. Custom coding assignment help for Python, Java, C++, and more with original code, detailed explanations, and 24/7 support. Order now!',
                'meta_keywords' => 'programming assignment help, coding assignment help, python assignments help, help with programming assignment, coding homework help, do my programming assignment for me, java programming help, c++ assignment help, computer science homework, programming project help, coding assignment service, programming homework assistance',
                'canonical_url' => 'https://academicscribe.com/services/programming-assignments',
                'og_url' => 'https://academicscribe.com/services/programming-assignments',
                'robots' => 'index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1',
                'language' => 'en-US',
                'structured_data' => $structuredData,
                'twitter_card' => 'summary_large_image',
                'twitter_title' => 'Professional Programming Assignment Help | Expert Coding Assignment Service',
                'twitter_description' => 'Expert programming assignment help with professional coders. Get custom coding assignment help with original code, detailed explanations, and guaranteed results.',
                'twitter_image' => 'https://academicscribe.com/images/programming-assignment-help-twitter.jpg',
                'og_title' => 'Professional Programming Assignment Help | Expert Coding Assignment Service',
                'og_description' => 'Expert programming assignment help with professional coders. Get custom coding assignment help for Python, Java, C++, and more with original code and detailed explanations. Trusted by 10,000+ students worldwide.',
                'og_image' => 'https://academicscribe.com/images/programming-assignment-help-og.jpg',
                'og_type' => 'website',
            ]
        );

        // Delete old blocks first
        PageContent::where('page_id', $page->id)->delete();

        // Content blocks
        $blocks = [
            [
                'block_type' => 'service_hero',
                'block_key' => 'programming_hero',
                'order' => 1,
                'content' => [
                    'title' => 'Professional Programming Assignment Help | Expert Coding Assignment Service',
                    'description' => 'Get expert programming assignment help from professional coders with advanced degrees in computer science. Our custom coding assignment help covers Python, Java, C++, and all programming languages with original code, detailed explanations, and perfect formatting. Trusted by 10,000+ students worldwide with 24/7 support and guaranteed results.',
                    'keyPoints' => [
                        'Professional programming experts with computer science degrees',
                        'Custom coding assignment help with 100% original code and plagiarism-free work',
                        'Programming assignment service covering Python, Java, C++, and all languages',
                        'Coding assignment assistance with detailed code explanations and comments',
                    ],
                    'ctaText' => 'Get Professional Programming Help Now',
                    'ctaLink' => '/contact',
                    'trustSignals' => [
                        '10,000+ satisfied students',
                        '4.8/5 average rating',
                        '24/7 customer support',
                        'Money-back guarantee',
                    ],
                ],
            ],
            [
                'block_type' => 'service_overview',
                'block_key' => 'programming_overview',
                'order' => 2,
                'content' => [
                    'title' => 'Our Comprehensive Programming Assignment Help Service',
                    'description' => 'We provide professional programming assignment help across all programming languages and computer science disciplines with expert coding methodology and academic excellence. Our custom programming assignment help includes original code development, algorithm design, debugging assistance, and comprehensive programming support for students at all educational levels.',
                    'features' => [
                        [
                            'title' => 'Professional Programming Experts',
                            'description' => 'Expert programming assignment helpers with advanced computer science degrees who understand coding standards, software development methodologies, and programming language requirements for quality programming assignment help',
                            'icon' => 'Award',
                        ],
                        [
                            'title' => 'Original Code Development',
                            'description' => 'Custom programming assignment help with original code writing, algorithm implementation, data structure design, and comprehensive programming solutions tailored to your specific academic requirements',
                            'icon' => 'Code',
                        ],
                        [
                            'title' => 'All Programming Languages Covered',
                            'description' => 'Programming assignment service covering Python, Java, C++, JavaScript, SQL, and specialized programming languages with language-specific experts and best practices',
                            'icon' => 'BookOpen',
                        ],
                        [
                            'title' => 'Perfect Code Documentation',
                            'description' => 'Professional programming assignment help with proper code comments, documentation, testing procedures, and formatting in academic programming standards',
                            'icon' => 'FileText',
                        ],
                    ],
                ],
            ],
            [
                'block_type' => 'service_process',
                'block_key' => 'programming_process',
                'order' => 3,
                'content' => [
                    'title' => 'Our Professional Programming Assignment Help Process',
                    'description' => 'We follow a structured, academic approach to deliver exceptional programming assignment help with thorough code development methodology, original algorithm design, and programming excellence that meets your institution\'s highest standards.',
                    'steps' => [
                        ['number' => 1, 'title' => 'Programming Requirements Analysis', 'description' => 'Comprehensive analysis of your programming assignment requirements, coding objectives, institutional guidelines, and project scope to establish clear direction for your custom programming assignment help.', 'icon' => 'Target'],
                        ['number' => 2, 'title' => 'Algorithm & Data Structure Design', 'description' => 'Develop comprehensive programming strategy with efficient algorithms, optimal data structures, and analytical frameworks for professional programming assignment help excellence.', 'icon' => 'Code'],
                        ['number' => 3, 'title' => 'Programming Language Selection', 'description' => 'Select appropriate programming language based on assignment requirements, performance needs, and academic standards for your programming assignment help with quality assessment.', 'icon' => 'Database'],
                        ['number' => 4, 'title' => 'Code Development & Implementation', 'description' => 'Professional programming experts craft your assignment with clean code structure, logical flow, efficient algorithms, and adherence to programming best practices.', 'icon' => 'Edit'],
                        ['number' => 5, 'title' => 'Testing & Debugging', 'description' => 'Apply comprehensive testing procedures, error handling, and debugging techniques according to your required programming standards for programming assignment help with institutional compliance.', 'icon' => 'CheckCircle'],
                        ['number' => 6, 'title' => 'Code Review & Documentation', 'description' => 'Comprehensive code review, documentation, and commenting to ensure your programming assignment meets academic standards and excellence expectations for professional programming assignment help delivery.', 'icon' => 'FileText'],
                    ],
                ],
            ],
            [
                'block_type' => 'service_benefits',
                'block_key' => 'programming_benefits',
                'order' => 4,
                'content' => [
                    'title' => 'Why Choose Our Professional Programming Assignment Help Service',
                    'description' => 'Discover why over 10,000 students choose our expert programming assignment assistance for their computer science success',
                    'benefits' => [
                        ['title' => 'Computer Science Expert Programmers', 'description' => 'Professional programming assignment helpers with advanced degrees in computer science who understand programming paradigms, software engineering principles, and academic standards for exceptional results', 'icon' => 'Award'],
                        ['title' => '100% Original Code & Custom Solutions', 'description' => 'Custom programming assignment help with completely original code, unique algorithms, plagiarism-free work, and comprehensive originality reports tailored to your programming requirements', 'icon' => 'Shield'],
                        ['title' => 'Comprehensive Programming Support', 'description' => 'Programming assignment service with proper software development methodology, advanced coding techniques, and evidence-based solutions that meet rigorous academic standards', 'icon' => 'Code'],
                        ['title' => 'Perfect Programming Standards', 'description' => 'Programming assignment help that meets all academic standards with proper code structure, perfect documentation, formatting requirements, and adherence to programming integrity', 'icon' => 'CheckCircle'],
                        ['title' => 'Guaranteed Timely Delivery', 'description' => 'Professional programming assignment help service with reliable delivery schedules, 24/7 customer support, unlimited revisions, and money-back guarantee for complete satisfaction', 'icon' => 'Clock'],
                    ],
                    'imageAlt' => 'Professional Programming Assignment Help Benefits - Custom Coding Assignment Service with Expert Programmers and Original Code',
                    'ctaText' => 'Order Professional Programming Help Now',
                    'ctaLink' => '/place-order',
                    'guarantees' => [
                        '100% Original Code',
                        'On-Time Delivery',
                        '24/7 Support',
                        'Money-Back Guarantee',
                        'Unlimited Revisions',
                    ],
                ],
            ],
            [
                'block_type' => 'service_testimonials',
                'block_key' => 'programming_testimonials',
                'order' => 5,
                'content' => [
                    'title' => 'What Our Programming Assignment Help Clients Say',
                    'description' => 'Read authentic testimonials from students who\'ve achieved computer science success with our professional programming assignment assistance',
                    'testimonials' => [
                        ['text' => 'The programming assignment help I received was outstanding. The programmer conducted thorough analysis and provided excellent code that impressed my professor. The custom programming assignment help included perfect documentation and met all my university\'s requirements. I received an A+ grade!', 'author' => 'Alex K.', 'role' => 'Undergraduate Student, Computer Science', 'rating' => 5, 'verified' => true, 'university' => 'Massachusetts Institute of Technology'],
                        ['text' => 'I needed professional programming assignment help for my Python course, and the quality exceeded my expectations. The programming assignment service provided original code with comprehensive explanations and clear documentation. The programmer was knowledgeable and responsive throughout the process.', 'author' => 'Sarah L.', 'role' => 'Graduate Student, Software Engineering', 'rating' => 5, 'verified' => true, 'university' => 'Stanford University'],
                        ['text' => 'As an international student, I struggled with programming standards. The programming assignment assistance helped me understand proper coding practices and documentation while delivering a high-quality assignment that earned me an A grade. The support team was available 24/7.', 'author' => 'Raj P.', 'role' => 'Undergraduate Student, Computer Engineering', 'rating' => 5, 'verified' => true, 'university' => 'University of California, Berkeley'],
                    ],
                    'trustMetrics' => [
                        'totalReviews' => '1,847',
                        'averageRating' => '4.9',
                        'satisfactionRate' => '99%',
                        'repeatCustomers' => '91%',
                    ],
                ],
            ],
            [
                'block_type' => 'service_faqs',
                'block_key' => 'programming_faqs',
                'order' => 6,
                'content' => [
                    'title' => 'Programming Assignment Help FAQs',
                    'description' => 'Get answers to common questions about our professional programming assignment assistance and custom programming assignment help services',
                    'faqs' => [
                        ['question' => 'What programming languages does your programming assignment help service cover?', 'answer' => 'Our professional programming assignment help service covers all major programming languages including Python, Java, C++, JavaScript, C#, PHP, Ruby, Swift, Kotlin, SQL, and specialized languages like R, MATLAB, and Assembly. Our custom programming assignment help covers all academic levels from high school to graduate studies, across all computer science disciplines including software engineering, computer engineering, data science, artificial intelligence, cybersecurity, and specialized fields. We also handle specific programming paradigms and institutional requirements.'],
                        ['question' => 'How do you ensure original code in your programming assignment help service?', 'answer' => 'Our programming assignment help service guarantees 100% original code through comprehensive algorithm design, custom programming approaches, and original implementation. Our professional programming assignment helpers create fresh code for each project, avoiding pre-written solutions and template-based approaches. We use advanced code similarity detection tools and provide detailed originality reports with every custom programming assignment help order. Additionally, we maintain a strict no-resale policy to ensure complete originality.'],
                        ['question' => 'What qualifications do your programming assignment helpers have?', 'answer' => 'Our programming assignment helpers hold advanced degrees (Bachelor\'s, Master\'s, and PhD) in Computer Science, Software Engineering, and related fields with extensive programming experience. Each professional programming assignment helper undergoes rigorous screening including academic credential verification, programming portfolio review, and technical expertise testing. Our programming assignment service team includes software engineers, former educators, and industry professionals with proven track records in their programming fields.'],
                        ['question' => 'How do you handle code documentation and comments in programming assignments?', 'answer' => 'Our professional programming assignment help service includes expert code documentation and commenting in all major programming standards including industry best practices, academic requirements, and institutional guidelines. Our programming assignment helpers are trained in programming documentation standards and use professional tools to ensure accuracy. Every custom programming assignment help order includes properly documented code, comprehensive comments, and adherence to your institution\'s specific programming requirements.'],
                        ['question' => 'What is your revision policy for programming assignment help service?', 'answer' => 'Our programming assignment help service includes unlimited free revisions within 14 days of delivery to ensure complete satisfaction. If your custom programming assignment help doesn\'t meet your requirements or needs adjustments based on professor feedback, our professional programming assignment helpers will revise it at no additional cost. We\'re committed to your programming success and will work with you until your assignment meets all requirements and expectations.'],
                        ['question' => 'How do you ensure confidentiality in your programming assignment help service?', 'answer' => 'Our professional programming assignment help service maintains strict confidentiality through encrypted communication systems, secure payment processing, and comprehensive non-disclosure agreements. We never share client information, assignment topics, or completed code with third parties. All custom programming assignment help orders are processed with complete anonymity, and we delete all client files after project completion. Our programming assignment helpers sign confidentiality agreements, and our platform uses SSL encryption to protect all communications.'],
                        ['question' => 'What support do you provide after delivering my programming assignment?', 'answer' => 'Our programming assignment help service includes comprehensive post-delivery support including free revisions, code optimization, debugging assistance, and programming guidance. Our 24/7 customer support team is available to address any questions or concerns about your custom programming assignment help order. We also provide additional guidance on professor feedback implementation and programming improvement tips for your future assignments.'],
                    ],
                ],
            ],
            [
                'block_type' => 'service_cta',
                'block_key' => 'programming_cta',
                'order' => 7,
                'content' => [
                    'title' => 'Ready to Get Professional Programming Assignment Help That Guarantees Results?',
                    'description' => 'Join over 10,000 successful students who\'ve achieved computer science excellence with our expert programming assignment help service. Get custom programming assignment help from professional programmers with advanced degrees today.',
                    'benefits' => [
                        ['text' => 'Professional programming experts with computer science expertise', 'icon' => '🏆'],
                        ['text' => '100% original code with comprehensive explanations', 'icon' => '💻'],
                        ['text' => 'Perfect documentation and academic standards guaranteed', 'icon' => '📄'],
                        ['text' => '24/7 support with money-back guarantee', 'icon' => '🛡️'],
                    ],
                    'primaryButtonText' => 'Get Professional Programming Help Now',
                    'primaryButtonLink' => '/place-order',
                    'secondaryButtonText' => 'Free Programming Consultation',
                    'secondaryButtonLink' => '/contact',
                    'bgColor' => 'blue',
                    'urgencyText' => 'Limited Time: 15% OFF for new customers',
                    'guarantees' => [
                        '100% Original Code',
                        'On-Time Delivery',
                        'Money-Back Guarantee',
                        'Unlimited Revisions',
                        '24/7 Support',
                    ],
                    'trustBadges' => [
                        'SSL Secured',
                        'Privacy Protected',
                        'Verified Programmers',
                        'Academic Excellence',
                    ],
                ],
            ],
            [
                'block_type' => 'internal_links',
                'block_key' => 'programming_related_services',
                'order' => 8,
                'content' => [
                    'title' => 'Related Academic Services',
                    'description' => 'Explore our comprehensive range of academic services',
                    'links' => [
                        ['title' => 'Assignment Writing Service', 'url' => '/services/assignments', 'description' => 'Professional assignment writing for all academic levels'],
                        ['title' => 'Computer Science Assignment Help', 'url' => '/services/assignments', 'description' => 'Expert computer science assignment assistance'],
                        ['title' => 'Software Engineering Project Help', 'url' => '/services/assignments', 'description' => 'Professional software engineering assistance'],
                        ['title' => 'Data Science Assignment Help', 'url' => '/services/assignments', 'description' => 'Expert data science and analysis assistance'],
                    ],
                ],
            ],
            [
                'block_type' => 'internal_links',
                'block_key' => 'programming_support_pages',
                'order' => 9,
                'content' => [
                    'title' => 'Learn More About Our Programming Assignment Help',
                    'description' => 'Get detailed information about our programming specialists and pricing',
                    'links' => [
                        ['title' => 'Our Writers', 'url' => '/writers', 'description' => 'Meet our programming assignment specialists'],
                        ['title' => 'Pricing', 'url' => '/pricing-page', 'description' => 'Transparent programming assignment pricing'],
                        ['title' => 'Guarantees', 'url' => '/guarantees', 'description' => 'Our quality and satisfaction guarantees'],
                        ['title' => 'Reviews', 'url' => '/reviews', 'description' => 'Read customer reviews and testimonials'],
                    ],
                ],
            ],
            [
                'block_type' => 'internal_links',
                'block_key' => 'programming_resource_links',
                'order' => 10,
                'content' => [
                    'title' => 'Professional Programming Assignment Help Resources',
                    'links' => [
                        ['title' => 'Programming Assignment Guide', 'url' => '/blog/programming-assignment-guide', 'description' => 'Complete guide to programming assignments'],
                        ['title' => 'Python Programming Tips', 'url' => '/blog/python-programming-tips', 'description' => 'Essential tips for Python programming success'],
                        ['title' => 'Java Programming Best Practices', 'url' => '/blog/java-programming-best-practices', 'description' => 'Master Java programming standards and practices'],
                        ['title' => 'Programming Assignment Topics', 'url' => '/blog/programming-assignment-topics', 'description' => 'Inspiring programming assignment ideas by language'],
                    ],
                ],
            ],
        ];

        // Create content blocks
        foreach ($blocks as $i => $block) {
            PageContent::create([
                'page_id' => $page->id,
                'block_type' => $block['block_type'],
                'block_key' => $block['block_key'],
                'content' => $block['content'],
                'order' => $block['order'] ?? ($i + 1),
                'is_active' => true,
            ]);
        }

        $this->command->info('Programming Assignments service content seeded successfully!');
    }
}
