<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Page;
use App\Models\PageContent;
use App\Models\PageSeo;
use App\Models\PageMedia;
use App\Services\PageService;
use Carbon\Carbon;

class ServicePageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $pageService = app(PageService::class);

        // Define service pages data
        $services = [
            [
                'slug' => 'services',
                'title' => 'Academic Writing Services',
                'page_type' => 'service_index',
                'template' => 'services.index',
                'seo_priority' => 1,
                'content_blocks' => [
                    [
                        'block_type' => 'hero',
                        'block_key' => 'main_hero',
                        'content' => [
                            'title' => 'Professional Academic Writing Services',
                            'description' => 'Get expert help with all your academic writing needs. Our PhD writers deliver high-quality, original content tailored to your requirements.',
                            'cta_buttons' => [
                                [
                                    'text' => 'Get Started',
                                    'url' => '/order',
                                    'style' => 'primary'
                                ],
                                [
                                    'text' => 'View Pricing',
                                    'url' => '/pricing',
                                    'style' => 'secondary'
                                ]
                            ]
                        ],
                        'order' => 1,
                        'is_active' => true
                    ],
                    [
                        'block_type' => 'overview',
                        'block_key' => 'services_overview',
                        'content' => [
                            'title' => 'Our Academic Writing Services',
                            'description' => 'We offer comprehensive academic writing assistance across all disciplines and academic levels.',
                            'features' => [
                                'Expert PhD Writers',
                                '100% Original Content',
                                'Unlimited Free Revisions',
                                '24/7 Customer Support',
                                'Plagiarism-Free Guarantee',
                                'On-Time Delivery'
                            ]
                        ],
                        'order' => 2,
                        'is_active' => true
                    ]
                ],
                'seo_data' => [
                    'meta_title' => 'Academic Writing Services - Professional Essay & Research Paper Help',
                    'meta_description' => 'Get professional academic writing help from PhD experts. Essays, research papers, dissertations, and more. 100% original, plagiarism-free content with unlimited revisions.',
                    'meta_keywords' => 'academic writing, essay help, research papers, dissertation writing, assignment help',
                    'canonical_url' => url('/services'),
                    'og_title' => 'Academic Writing Services - Expert Help Available',
                    'og_description' => 'Professional academic writing assistance from PhD writers. Get help with essays, research papers, and more.',
                    'og_type' => 'website',
                    'robots' => 'index, follow'
                ]
            ],
            [
                'slug' => 'research-papers',
                'title' => 'Research Paper Writing Service',
                'page_type' => 'service_page',
                'template' => 'services.research_papers',
                'seo_priority' => 2,
                'content_blocks' => [
                    [
                        'block_type' => 'hero',
                        'block_key' => 'research_hero',
                        'content' => [
                            'title' => 'Professional Research Paper Writing Service',
                            'description' => 'Get expert research paper help from PhD writers. Original research, comprehensive analysis, and proper formatting guaranteed.',
                            'cta_buttons' => [
                                [
                                    'text' => 'Order Research Paper',
                                    'url' => '/order',
                                    'style' => 'primary'
                                ]
                            ]
                        ],
                        'order' => 1,
                        'is_active' => true
                    ],
                    [
                        'block_type' => 'benefits',
                        'block_key' => 'research_benefits',
                        'content' => [
                            'title' => 'Why Choose Our Research Paper Service',
                            'benefits' => [
                                [
                                    'title' => 'Expert Researchers',
                                    'description' => 'PhD writers with subject expertise',
                                    'icon' => 'GraduationCap'
                                ],
                                [
                                    'title' => 'Original Research',
                                    'description' => 'Fresh perspectives and unique insights',
                                    'icon' => 'Search'
                                ],
                                [
                                    'title' => 'Proper Formatting',
                                    'description' => 'APA, MLA, Chicago, and Harvard styles',
                                    'icon' => 'FileText'
                                ],
                                [
                                    'title' => 'Quality Guarantee',
                                    'description' => 'Unlimited revisions until satisfied',
                                    'icon' => 'Shield'
                                ]
                            ]
                        ],
                        'order' => 2,
                        'is_active' => true
                    ],
                    [
                        'block_type' => 'process',
                        'block_key' => 'research_process',
                        'content' => [
                            'title' => 'Our Research Paper Process',
                            'steps' => [
                                [
                                    'step' => 1,
                                    'title' => 'Topic Analysis',
                                    'description' => 'We analyze your requirements and research objectives'
                                ],
                                [
                                    'step' => 2,
                                    'title' => 'Research & Planning',
                                    'description' => 'Thorough research and detailed outline creation'
                                ],
                                [
                                    'step' => 3,
                                    'title' => 'Writing & Analysis',
                                    'description' => 'Expert writing with comprehensive analysis'
                                ],
                                [
                                    'step' => 4,
                                    'title' => 'Review & Delivery',
                                    'description' => 'Quality review and on-time delivery'
                                ]
                            ]
                        ],
                        'order' => 3,
                        'is_active' => true
                    ]
                ],
                'seo_data' => [
                    'meta_title' => 'Research Paper Writing Service - Expert Help with Original Research',
                    'meta_description' => 'Professional research paper writing service with PhD experts. Original research, proper formatting, and comprehensive analysis. Get help with your research papers today.',
                    'meta_keywords' => 'research paper writing, academic research, PhD writers, research help',
                    'canonical_url' => url('/services/research-papers'),
                    'og_title' => 'Research Paper Writing Service - Expert Academic Help',
                    'og_description' => 'Get professional research paper help from PhD writers. Original research and comprehensive analysis.',
                    'og_type' => 'website',
                    'robots' => 'index, follow'
                ]
            ],
            [
                'slug' => 'assignments',
                'title' => 'Assignment Help Service',
                'page_type' => 'service_page',
                'template' => 'services.assignments',
                'seo_priority' => 2,
                'content_blocks' => [
                    [
                        'block_type' => 'hero',
                        'block_key' => 'assignment_hero',
                        'content' => [
                            'title' => 'Professional Assignment Help Service',
                            'description' => 'Expert assistance with all types of academic assignments. Get help with homework, projects, and complex problems.',
                            'cta_buttons' => [
                                [
                                    'text' => 'Get Assignment Help',
                                    'url' => '/order',
                                    'style' => 'primary'
                                ]
                            ]
                        ],
                        'order' => 1,
                        'is_active' => true
                    ],
                    [
                        'block_type' => 'benefits',
                        'block_key' => 'assignment_benefits',
                        'content' => [
                            'title' => 'Assignment Help Benefits',
                            'benefits' => [
                                [
                                    'title' => 'All Subjects Covered',
                                    'description' => 'Expert help across all academic disciplines',
                                    'icon' => 'BookOpen'
                                ],
                                [
                                    'title' => 'Quick Turnaround',
                                    'description' => 'Fast delivery for urgent assignments',
                                    'icon' => 'Clock'
                                ],
                                [
                                    'title' => 'Step-by-Step Solutions',
                                    'description' => 'Detailed explanations for better understanding',
                                    'icon' => 'List'
                                ],
                                [
                                    'title' => '24/7 Support',
                                    'description' => 'Round-the-clock assistance available',
                                    'icon' => 'MessageCircle'
                                ]
                            ]
                        ],
                        'order' => 2,
                        'is_active' => true
                    ]
                ],
                'seo_data' => [
                    'meta_title' => 'Assignment Help Service - Expert Academic Assistance',
                    'meta_description' => 'Professional assignment help service for all academic levels. Expert solutions for homework, projects, and complex problems. Get help today.',
                    'meta_keywords' => 'assignment help, homework help, academic assistance, project help',
                    'canonical_url' => url('/services/assignments'),
                    'og_title' => 'Assignment Help Service - Expert Academic Support',
                    'og_description' => 'Get professional assignment help from academic experts. All subjects covered with quick turnaround.',
                    'og_type' => 'website',
                    'robots' => 'index, follow'
                ]
            ],
            [
                'slug' => 'personal-statements',
                'title' => 'Personal Statement Writing Service',
                'page_type' => 'service_page',
                'template' => 'services.personal_statements',
                'seo_priority' => 2,
                'content_blocks' => [
                    [
                        'block_type' => 'hero',
                        'block_key' => 'personal_statement_hero',
                        'content' => [
                            'title' => 'Professional Personal Statement Writing Service',
                            'description' => 'Expert personal statement help for university applications. Compelling narratives that showcase your unique strengths.',
                            'cta_buttons' => [
                                [
                                    'text' => 'Write My Personal Statement',
                                    'url' => '/order',
                                    'style' => 'primary'
                                ]
                            ]
                        ],
                        'order' => 1,
                        'is_active' => true
                    ],
                    [
                        'block_type' => 'benefits',
                        'block_key' => 'personal_statement_benefits',
                        'content' => [
                            'title' => 'Personal Statement Writing Benefits',
                            'benefits' => [
                                [
                                    'title' => 'Admission Experts',
                                    'description' => 'Writers with university admission experience',
                                    'icon' => 'Award'
                                ],
                                [
                                    'title' => 'Compelling Narratives',
                                    'description' => 'Stories that make you stand out',
                                    'icon' => 'PenTool'
                                ],
                                [
                                    'title' => 'Cultural Expertise',
                                    'description' => 'Understanding of different cultural contexts',
                                    'icon' => 'Globe'
                                ],
                                [
                                    'title' => 'Multiple Revisions',
                                    'description' => 'Unlimited edits until perfect',
                                    'icon' => 'RefreshCw'
                                ]
                            ]
                        ],
                        'order' => 2,
                        'is_active' => true
                    ]
                ],
                'seo_data' => [
                    'meta_title' => 'Personal Statement Writing Service - Expert University Application Help',
                    'meta_description' => 'Professional personal statement writing service for university applications. Expert writers help create compelling narratives that stand out.',
                    'meta_keywords' => 'personal statement writing, university application, admission essay, college application',
                    'canonical_url' => url('/services/personal-statements'),
                    'og_title' => 'Personal Statement Writing Service - University Application Help',
                    'og_description' => 'Expert personal statement writing for university applications. Create compelling narratives that showcase your strengths.',
                    'og_type' => 'website',
                    'robots' => 'index, follow'
                ]
            ],
            [
                'slug' => 'programming-assignments',
                'title' => 'Programming Assignment Help',
                'page_type' => 'service_page',
                'template' => 'services.programming_assignments',
                'seo_priority' => 2,
                'content_blocks' => [
                    [
                        'block_type' => 'hero',
                        'block_key' => 'programming_hero',
                        'content' => [
                            'title' => 'Professional Programming Assignment Help',
                            'description' => 'Expert programming assistance with Python, Java, C++, and all programming languages. Professional coders with computer science degrees.',
                            'cta_buttons' => [
                                [
                                    'text' => 'Get Programming Help',
                                    'url' => '/order',
                                    'style' => 'primary'
                                ]
                            ]
                        ],
                        'order' => 1,
                        'is_active' => true
                    ],
                    [
                        'block_type' => 'benefits',
                        'block_key' => 'programming_benefits',
                        'content' => [
                            'title' => 'Programming Help Benefits',
                            'benefits' => [
                                [
                                    'title' => 'All Languages Covered',
                                    'description' => 'Python, Java, C++, JavaScript, and more',
                                    'icon' => 'Code'
                                ],
                                [
                                    'title' => 'Computer Science Experts',
                                    'description' => 'Professional programmers with CS degrees',
                                    'icon' => 'GraduationCap'
                                ],
                                [
                                    'title' => 'Clean Code',
                                    'description' => 'Well-documented and optimized solutions',
                                    'icon' => 'FileCode'
                                ],
                                [
                                    'title' => 'Algorithm Expertise',
                                    'description' => 'Complex algorithms and data structures',
                                    'icon' => 'Cpu'
                                ]
                            ]
                        ],
                        'order' => 2,
                        'is_active' => true
                    ]
                ],
                'seo_data' => [
                    'meta_title' => 'Programming Assignment Help - Expert Coding Assistance',
                    'meta_description' => 'Professional programming assignment help with Python, Java, C++, and all languages. Expert coders with computer science degrees provide clean, documented code.',
                    'meta_keywords' => 'programming help, coding assignment, computer science help, Python, Java, C++',
                    'canonical_url' => url('/services/programming-assignments'),
                    'og_title' => 'Programming Assignment Help - Expert Coding Solutions',
                    'og_description' => 'Get professional programming help from expert coders. All languages covered with clean, documented solutions.',
                    'og_type' => 'website',
                    'robots' => 'index, follow'
                ]
            ]
        ];

        // Create each service page
        foreach ($services as $serviceData) {
            $contentBlocks = $serviceData['content_blocks'];
            $seoData = $serviceData['seo_data'];
            
            // Remove content_blocks and seo_data from page data
            unset($serviceData['content_blocks']);
            unset($serviceData['seo_data']);
            
            // Add common page fields
            $serviceData['status'] = 'published';
            $serviceData['published_at'] = Carbon::now();
            
            // Create the page with all related data
            $pageService->createPage($serviceData, $contentBlocks, $seoData);
            
            $this->command->info("Created service page: {$serviceData['title']}");
        }

        $this->command->info('Service pages seeded successfully!');
    }
}