<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\OrderFile;

class UpdateExistingOrderFilesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Update existing order files to have proper categorization
        $existingFiles = OrderFile::whereNull('file_category')->orWhere('file_category', '')->get();
        
        foreach ($existingFiles as $file) {
            // Determine file category based on existing file_status or uploader type
            $fileCategory = 'general';
            $accessControl = 'admin_only';
            
            if ($file->file_status === 'instructions') {
                $fileCategory = 'instructions';
                $accessControl = 'client_admin';
            } elseif ($file->uploader_user_type === 'client') {
                $fileCategory = 'instructions';
                $accessControl = 'client_admin';
            } elseif ($file->uploader_user_type === 'writer') {
                if ($file->file_status === 'complete') {
                    $fileCategory = 'complete';
                } else {
                    $fileCategory = 'draft';
                }
                $accessControl = 'writer_admin';
            }
            
            // Update the file
            $file->update([
                'file_category' => $fileCategory,
                'access_control' => $accessControl,
                'description' => $file->description ?: 'File uploaded for this order'
            ]);
        }
        
        $this->command->info('Updated ' . $existingFiles->count() . ' existing order files with proper categorization.');
    }
}
