<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ContentBlock;

class UpdateServicesSeeder extends Seeder
{
    /**
     * Update ONLY the services section without affecting other homepage content
     */
    public function run(): void
    {
        $this->command->info('Updating services section only...');

        // Find the existing services block
        $servicesBlock = ContentBlock::where('block_type', 'services')
            ->where('block_key', 'services_section')
            ->first();

        if (!$servicesBlock) {
            $this->command->error('Services block not found! Please create homepage first.');
            return;
        }

        // Get existing content and update only the services array
        $content = $servicesBlock->content;
        
        // Update with new structure including color and features
        $content['services'] = [
            [
                'title' => 'Essay Writing',
                'description' => '<p>Professional essay writing service with expert writers specializing in all academic levels and subjects.</p>',
                'icon' => 'file-text',
                'link' => '/services/essay-writing',
                'color' => 'blue',
                'features' => [
                    'All Academic Levels',
                    '24/7 Support',
                    'Plagiarism-Free'
                ]
            ],
            [
                'title' => 'Research Papers',
                'description' => '<p>Comprehensive research paper writing service with thorough analysis and proper citations.</p>',
                'icon' => 'search',
                'link' => '/services/research-papers',
                'color' => 'green',
                'features' => [
                    'In-depth Research',
                    'Proper Citations',
                    'Quality Assurance'
                ]
            ],
            [
                'title' => 'Dissertation Writing',
                'description' => '<p>Expert dissertation writing help from PhD-qualified writers with extensive research experience.</p>',
                'icon' => 'graduation-cap',
                'link' => '/services/dissertation-writing',
                'color' => 'purple',
                'features' => [
                    'PhD Writers',
                    'Original Research',
                    'Timely Delivery'
                ]
            ],
            [
                'title' => 'Assignments',
                'description' => '<p>Custom assignment writing service covering all subjects and academic requirements.</p>',
                'icon' => 'clipboard-list',
                'link' => '/services/assignments',
                'color' => 'orange',
                'features' => [
                    'All Subjects',
                    'Custom Solutions',
                    'Fast Turnaround'
                ]
            ],
            [
                'title' => 'Case Studies',
                'description' => '<p>Professional case study analysis and writing service with detailed insights and solutions.</p>',
                'icon' => 'bar-chart-3',
                'link' => '/services/case-studies',
                'color' => 'indigo',
                'features' => [
                    'Detailed Analysis',
                    'Real Examples',
                    'Expert Insights'
                ]
            ],
            [
                'title' => 'Literature Reviews',
                'description' => '<p>Comprehensive literature review writing service with systematic analysis and synthesis.</p>',
                'icon' => 'book-open',
                'link' => '/services/literature-reviews',
                'color' => 'teal',
                'features' => [
                    'Systematic Review',
                    'Critical Analysis',
                    'Academic Standards'
                ]
            ],
            [
                'title' => 'Thesis Proposals',
                'description' => '<p>Professional thesis and research proposals with clear methodology and compelling research questions.</p>',
                'icon' => 'target',
                'link' => '/services/thesis-proposals',
                'color' => 'pink',
                'features' => [
                    'Research Proposals',
                    'Methodology Design',
                    'Literature Gap Analysis'
                ]
            ],
            [
                'title' => 'Programming Assignments',
                'description' => '<p>Expert programming assistance with Python, Java, C++, and all programming languages. Professional coders with computer science degrees.</p>',
                'icon' => 'code',
                'link' => '/services/programming-assignments',
                'color' => 'red',
                'features' => [
                    'Python, Java, C++',
                    'Algorithm Design',
                    'Code Documentation'
                ]
            ]
        ];

        // Update only the services block
        $servicesBlock->update(['content' => $content]);

        $this->command->info('Services section updated successfully!');
        $this->command->info('All other homepage sections remain unchanged.');
    }
}
