<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class WriterLevelsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        \DB::table('writer_levels')->insert([
            [
                'id' => 1,
                'name' => 'Entry Level',
                'description' => 'Writers who have recently passed our qualification tests. They handle simpler assignments such as short essays, summaries, and basic research papers. Suitable for high school and introductory undergraduate work.',
                'rank' => 1,
                'created_at' => '2025-04-28 14:18:32',
                'updated_at' => '2025-04-28 14:18:32',
            ],
            [
                'id' => 2,
                'name' => 'Standard Writer',
                'description' => 'Experienced writers who have successfully completed at least 20 assignments with positive feedback. They can handle most undergraduate assignments and provide reliable, quality work across various subjects.',
                'rank' => 2,
                'created_at' => '2025-04-28 14:18:32',
                'updated_at' => '2025-04-28 14:18:32',
            ],
            [
                'id' => 3,
                'name' => 'Advanced Writer',
                'description' => 'Highly skilled writers with at least one year on our platform and a minimum of 50 completed assignments. They maintain a 4.5+ star rating and can handle complex undergraduate and graduate-level assignments with specialized knowledge in their fields.',
                'rank' => 3,
                'created_at' => '2025-04-28 14:18:32',
                'updated_at' => '2025-04-28 14:18:32',
            ],
            [
                'id' => 4,
                'name' => 'Expert Writer',
                'description' => 'Top-performing writers with Masters or PhD degrees in their specialization areas. They have maintained a 4.8+ star rating over at least 100 completed assignments and excel at complex research papers, analytical reports, and technical content.',
                'rank' => 4,
                'created_at' => '2025-04-28 14:18:32',
                'updated_at' => '2025-04-28 14:18:32',
            ],
            [
                'id' => 5,
                'name' => 'Premium Writer',
                'description' => 'Elite writers with exceptional academic credentials and consistent 4.9+ ratings. They specialize in sophisticated graduate-level work, dissertations, theses, and complex research papers requiring extensive knowledge and research capabilities.',
                'rank' => 5,
                'created_at' => '2025-04-28 14:18:32',
                'updated_at' => '2025-04-28 14:18:32',
            ],
            [
                'id' => 6,
                'name' => 'Distinguished Scholar',
                'description' => 'By invitation only. These writers represent the pinnacle of academic excellence with verified credentials as published academics, researchers, or industry experts. They handle the most demanding specialized projects and maintain perfect client satisfaction ratings.',
                'rank' => 6,
                'created_at' => '2025-04-28 14:18:32',
                'updated_at' => '2025-04-28 14:18:32',
            ],
        ]);
    }
}
