<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class WriterSpecializationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $now = Carbon::now();

        $specializations = [
            // Academic Subject-Based Specializations
            [
                'name' => 'English Literature & Composition',
                'description' => 'Specialization in analyzing literary works, writing essays, and creating composition pieces related to English literature.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'History & Political Science',
                'description' => 'Focus on historical research papers, political analysis, and related academic content.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Business & Economics',
                'description' => 'Expertise in business case studies, economic analysis, and related business academic writing.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Psychology & Social Sciences',
                'description' => 'Specialization in psychological studies, social research papers, and behavioral science content.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Computer Science & Information Technology',
                'description' => 'Technical writing related to computer science concepts, programming, and IT systems.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Engineering & Technical Writing',
                'description' => 'Focus on engineering reports, technical documentation, and scientific papers.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Medical & Health Sciences',
                'description' => 'Medical research papers, health studies, and related scientific content in healthcare.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Law & Legal Writing',
                'description' => 'Legal case studies, law reviews, and academic papers related to legal concepts.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Education & Pedagogy',
                'description' => 'Academic writing focused on educational theories, teaching methodologies, and learning concepts.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Natural Sciences',
                'description' => 'Scientific papers in physics, chemistry, biology, and other natural science disciplines.',
                'created_at' => $now,
                'updated_at' => $now,
            ],

            // Format-Based Specializations
            [
                'name' => 'Research Paper Specialist',
                'description' => 'Expert in structured academic research papers across multiple disciplines.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Essay Writing',
                'description' => 'Focus on argumentative, analytical, and expository essays for various subjects.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Case Study Analysis',
                'description' => 'Specialized in analyzing case studies and producing detailed reports, primarily in business, law, and social sciences.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Dissertation & Thesis',
                'description' => 'Expert assistance with complex, long-form academic works at graduate and postgraduate levels.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Technical Documentation',
                'description' => 'Creation of technical guides, manuals, and documentation for scientific and technical contexts.',
                'created_at' => $now,
                'updated_at' => $now,
            ],

            // Level-Based Specializations
            [
                'name' => 'Undergraduate Academic Writing',
                'description' => 'Focus on producing content suitable for bachelor-level academic requirements.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Graduate-Level Research',
                'description' => 'Specialized in master\'s level research papers and academic requirements.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'PhD & Doctoral Dissertation Support',
                'description' => 'Advanced academic writing assistance for doctoral candidates and PhD level research.',
                'created_at' => $now,
                'updated_at' => $now,
            ],

            // Industry-Specific Specializations
            [
                'name' => 'STEM Research',
                'description' => 'Focused on Science, Technology, Engineering, and Mathematics academic content.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'name' => 'Humanities & Arts',
                'description' => 'Specialized in philosophy, arts, cultural studies, and other humanities disciplines.',
                'created_at' => $now,
                'updated_at' => $now,
            ],
        ];

        DB::table('writer_specializations')->insert($specializations);
    }
}
