<?php

namespace Database\Seeders;

use App\Models\WriterTestQuestion;
use Illuminate\Database\Seeder;

class WriterTestQuestionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Clear existing questions if needed
        // WriterTestQuestion::truncate();

        // Question 1: Grammar and Punctuation
        WriterTestQuestion::create([
            'question' => 'Which of the following sentences uses the semicolon correctly?',
            'option_a' => 'The conference has been postponed; due to the weather conditions.',
            'option_b' => 'The manuscript was excellent; however, it needed some minor revisions.',
            'option_c' => 'The professor asked for; additional research on the topic.',
            'option_d' => 'The student completed the assignment; and submitted it early.',
            'correct_answer' => 'b',
            'category' => 'Grammar and Punctuation',
            'is_active' => true,
        ]);

        // Question 2: Vocabulary and Word Choice
        WriterTestQuestion::create([
            'question' => 'Which word is most appropriate to fill in the blank? "The researcher\'s findings were ________, challenging the established theory with substantial evidence."',
            'option_a' => 'redundant',
            'option_b' => 'ambiguous',
            'option_c' => 'conclusive',
            'option_d' => 'tentative',
            'correct_answer' => 'c',
            'category' => 'Vocabulary and Word Choice',
            'is_active' => true,
        ]);

        // Question 3: Citation Styles
        WriterTestQuestion::create([
            'question' => 'According to APA 7th edition guidelines, which of the following in-text citations is correctly formatted?',
            'option_a' => 'According to Smith, "the results were significant" (2019, p. 45).',
            'option_b' => 'According to Smith (2019), "the results were significant." (p. 45)',
            'option_c' => 'According to Smith (2019, p. 45), "the results were significant."',
            'option_d' => 'According to Smith, "the results were significant." (2019, pg. 45)',
            'correct_answer' => 'c',
            'category' => 'Citation Styles',
            'is_active' => true,
        ]);

        // Question 4: Research Methodology
        WriterTestQuestion::create([
            'question' => 'Which research method would be most appropriate for studying changes in behavior over a 10-year period?',
            'option_a' => 'Cross-sectional study',
            'option_b' => 'Longitudinal study',
            'option_c' => 'Case study',
            'option_d' => 'Randomized controlled trial',
            'correct_answer' => 'b',
            'category' => 'Research Methodology',
            'is_active' => true,
        ]);

        // Question 5: Academic Writing Standards
        WriterTestQuestion::create([
            'question' => 'Which of the following is NOT a characteristic of academic writing?',
            'option_a' => 'Use of formal language and technical terminology',
            'option_b' => 'Incorporation of personal anecdotes and emotional appeals',
            'option_c' => 'Clear structure with introduction, body, and conclusion',
            'option_d' => 'Critical analysis of evidence and sources',
            'correct_answer' => 'b',
            'category' => 'Academic Writing Standards',
            'is_active' => true,
        ]);
    }
}
