var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  Deferred: () => Deferred_default,
  Form: () => Form_default,
  Head: () => Head_default,
  Link: () => Link_default,
  WhenVisible: () => WhenVisible_default,
  createInertiaApp: () => createInertiaApp,
  router: () => router3,
  useForm: () => useForm,
  usePage: () => usePage,
  usePoll: () => usePoll,
  usePrefetch: () => usePrefetch,
  useRemember: () => useRemember
});
module.exports = __toCommonJS(index_exports);
var import_core10 = require("@inertiajs/core");

// src/createInertiaApp.ts
var import_core2 = require("@inertiajs/core");
var import_react4 = require("react");

// src/App.ts
var import_core = require("@inertiajs/core");
var import_react3 = require("react");

// src/HeadContext.ts
var import_react = require("react");
var headContext = (0, import_react.createContext)(void 0);
headContext.displayName = "InertiaHeadContext";
var HeadContext_default = headContext;

// src/PageContext.ts
var import_react2 = require("react");
var pageContext = (0, import_react2.createContext)(void 0);
pageContext.displayName = "InertiaPageContext";
var PageContext_default = pageContext;

// src/App.ts
var currentIsInitialPage = true;
var routerIsInitialized = false;
var swapComponent = async () => {
  currentIsInitialPage = false;
};
function App({
  children,
  initialPage,
  initialComponent,
  resolveComponent,
  titleCallback,
  onHeadUpdate
}) {
  const [current, setCurrent] = (0, import_react3.useState)({
    component: initialComponent || null,
    page: initialPage,
    key: null
  });
  const headManager = (0, import_react3.useMemo)(() => {
    return (0, import_core.createHeadManager)(
      typeof window === "undefined",
      titleCallback || ((title) => title),
      onHeadUpdate || (() => {
      })
    );
  }, []);
  if (!routerIsInitialized) {
    import_core.router.init({
      initialPage,
      resolveComponent,
      swapComponent: async (args) => swapComponent(args)
    });
    routerIsInitialized = true;
  }
  (0, import_react3.useEffect)(() => {
    swapComponent = async ({ component, page, preserveState }) => {
      if (currentIsInitialPage) {
        currentIsInitialPage = false;
        return;
      }
      setCurrent((current2) => ({
        component,
        page,
        key: preserveState ? current2.key : Date.now()
      }));
    };
    import_core.router.on("navigate", () => headManager.forceUpdate());
  }, []);
  if (!current.component) {
    return (0, import_react3.createElement)(
      HeadContext_default.Provider,
      { value: headManager },
      (0, import_react3.createElement)(PageContext_default.Provider, { value: current.page }, null)
    );
  }
  const renderChildren = children || (({ Component, props, key }) => {
    const child = (0, import_react3.createElement)(Component, { key, ...props });
    if (typeof Component.layout === "function") {
      return Component.layout(child);
    }
    if (Array.isArray(Component.layout)) {
      return Component.layout.concat(child).reverse().reduce((children2, Layout) => (0, import_react3.createElement)(Layout, { children: children2, ...props }));
    }
    return child;
  });
  return (0, import_react3.createElement)(
    HeadContext_default.Provider,
    { value: headManager },
    (0, import_react3.createElement)(
      PageContext_default.Provider,
      { value: current.page },
      renderChildren({
        Component: current.component,
        key: current.key,
        props: current.page.props
      })
    )
  );
}
App.displayName = "Inertia";

// src/createInertiaApp.ts
async function createInertiaApp({
  id = "app",
  resolve,
  setup,
  title,
  progress = {},
  page,
  render
}) {
  const isServer = typeof window === "undefined";
  const el = isServer ? null : document.getElementById(id);
  const initialPage = page || JSON.parse(el.dataset.page);
  const resolveComponent = (name) => Promise.resolve(resolve(name)).then((module2) => module2.default || module2);
  let head = [];
  const reactApp = await Promise.all([
    resolveComponent(initialPage.component),
    import_core2.router.decryptHistory().catch(() => {
    })
  ]).then(([initialComponent]) => {
    return setup({
      // @ts-expect-error
      el,
      App,
      props: {
        initialPage,
        initialComponent,
        resolveComponent,
        titleCallback: title,
        onHeadUpdate: isServer ? (elements) => head = elements : null
      }
    });
  });
  if (!isServer && progress) {
    (0, import_core2.setupProgress)(progress);
  }
  if (isServer) {
    const body = await render(
      (0, import_react4.createElement)(
        "div",
        {
          id,
          "data-page": JSON.stringify(initialPage)
        },
        // @ts-expect-error
        reactApp
      )
    );
    return { head, body };
  }
}

// src/Deferred.ts
var import_react6 = require("react");

// src/usePage.ts
var import_react5 = require("react");
function usePage() {
  const page = (0, import_react5.useContext)(PageContext_default);
  if (!page) {
    throw new Error("usePage must be used within the Inertia component");
  }
  return page;
}

// src/Deferred.ts
var urlWithoutHash = (url) => {
  url = new URL(url.href);
  url.hash = "";
  return url;
};
var isSameUrlWithoutHash = (url1, url2) => {
  return urlWithoutHash(url1).href === urlWithoutHash(url2).href;
};
var Deferred = ({ children, data, fallback }) => {
  if (!data) {
    throw new Error("`<Deferred>` requires a `data` prop to be a string or array of strings");
  }
  const [loaded, setLoaded] = (0, import_react6.useState)(false);
  const pageProps = usePage().props;
  const keys = (0, import_react6.useMemo)(() => Array.isArray(data) ? data : [data], [data]);
  (0, import_react6.useEffect)(() => {
    const removeListener = router3.on("start", (e) => {
      const isPartialVisit = e.detail.visit.only.length > 0 || e.detail.visit.except.length > 0;
      const isReloadingKey = e.detail.visit.only.find((key) => keys.includes(key));
      if (isSameUrlWithoutHash(e.detail.visit.url, window.location) && (!isPartialVisit || isReloadingKey)) {
        setLoaded(false);
      }
    });
    return () => {
      removeListener();
    };
  }, []);
  (0, import_react6.useEffect)(() => {
    setLoaded(keys.every((key) => pageProps[key] !== void 0));
  }, [pageProps, keys]);
  if (loaded) {
    return typeof children === "function" ? children() : children;
  }
  return typeof fallback === "function" ? fallback() : fallback;
};
Deferred.displayName = "InertiaDeferred";
var Deferred_default = Deferred;

// src/Form.ts
var import_core5 = require("@inertiajs/core");
var import_lodash_es2 = require("lodash-es");
var import_react9 = __toESM(require("react"), 1);

// src/useForm.ts
var import_core4 = require("@inertiajs/core");
var import_lodash_es = require("lodash-es");
var import_react8 = require("react");

// src/useRemember.ts
var import_core3 = require("@inertiajs/core");
var import_react7 = require("react");
function useRemember(initialState, key) {
  const [state, setState] = (0, import_react7.useState)(() => {
    const restored = import_core3.router.restore(key);
    return restored !== void 0 ? restored : initialState;
  });
  (0, import_react7.useEffect)(() => {
    import_core3.router.remember(state, key);
  }, [state, key]);
  return [state, setState];
}

// src/useForm.ts
function useForm(rememberKeyOrInitialValues, maybeInitialValues) {
  const isMounted = (0, import_react8.useRef)(null);
  const rememberKey = typeof rememberKeyOrInitialValues === "string" ? rememberKeyOrInitialValues : null;
  const [defaults, setDefaults] = (0, import_react8.useState)(
    (typeof rememberKeyOrInitialValues === "string" ? maybeInitialValues : rememberKeyOrInitialValues) || {}
  );
  const cancelToken = (0, import_react8.useRef)(null);
  const recentlySuccessfulTimeoutId = (0, import_react8.useRef)(null);
  const [data, setData] = rememberKey ? useRemember(defaults, `${rememberKey}:data`) : (0, import_react8.useState)(defaults);
  const [errors, setErrors] = rememberKey ? useRemember({}, `${rememberKey}:errors`) : (0, import_react8.useState)({});
  const [hasErrors, setHasErrors] = (0, import_react8.useState)(false);
  const [processing, setProcessing] = (0, import_react8.useState)(false);
  const [progress, setProgress] = (0, import_react8.useState)(null);
  const [wasSuccessful, setWasSuccessful] = (0, import_react8.useState)(false);
  const [recentlySuccessful, setRecentlySuccessful] = (0, import_react8.useState)(false);
  const transform = (0, import_react8.useRef)((data2) => data2);
  const isDirty = (0, import_react8.useMemo)(() => !(0, import_lodash_es.isEqual)(data, defaults), [data, defaults]);
  (0, import_react8.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
    };
  }, []);
  const setDefaultsCalledInOnSuccess = (0, import_react8.useRef)(false);
  const submit = (0, import_react8.useCallback)(
    (...args) => {
      const objectPassed = args[0] !== null && typeof args[0] === "object";
      const method = objectPassed ? args[0].method : args[0];
      const url = objectPassed ? args[0].url : args[1];
      const options = (objectPassed ? args[1] : args[2]) ?? {};
      setDefaultsCalledInOnSuccess.current = false;
      const _options = {
        ...options,
        onCancelToken: (token) => {
          cancelToken.current = token;
          if (options.onCancelToken) {
            return options.onCancelToken(token);
          }
        },
        onBefore: (visit) => {
          setWasSuccessful(false);
          setRecentlySuccessful(false);
          clearTimeout(recentlySuccessfulTimeoutId.current);
          if (options.onBefore) {
            return options.onBefore(visit);
          }
        },
        onStart: (visit) => {
          setProcessing(true);
          if (options.onStart) {
            return options.onStart(visit);
          }
        },
        onProgress: (event) => {
          setProgress(event);
          if (options.onProgress) {
            return options.onProgress(event);
          }
        },
        onSuccess: async (page) => {
          if (isMounted.current) {
            setProcessing(false);
            setProgress(null);
            setErrors({});
            setHasErrors(false);
            setWasSuccessful(true);
            setRecentlySuccessful(true);
            recentlySuccessfulTimeoutId.current = setTimeout(() => {
              if (isMounted.current) {
                setRecentlySuccessful(false);
              }
            }, 2e3);
          }
          const onSuccess = options.onSuccess ? await options.onSuccess(page) : null;
          if (isMounted.current && !setDefaultsCalledInOnSuccess.current) {
            setData((data2) => {
              setDefaults((0, import_lodash_es.cloneDeep)(data2));
              return data2;
            });
          }
          return onSuccess;
        },
        onError: (errors2) => {
          if (isMounted.current) {
            setProcessing(false);
            setProgress(null);
            setErrors(errors2);
            setHasErrors(true);
          }
          if (options.onError) {
            return options.onError(errors2);
          }
        },
        onCancel: () => {
          if (isMounted.current) {
            setProcessing(false);
            setProgress(null);
          }
          if (options.onCancel) {
            return options.onCancel();
          }
        },
        onFinish: (visit) => {
          if (isMounted.current) {
            setProcessing(false);
            setProgress(null);
          }
          cancelToken.current = null;
          if (options.onFinish) {
            return options.onFinish(visit);
          }
        }
      };
      if (method === "delete") {
        import_core4.router.delete(url, { ..._options, data: transform.current(data) });
      } else {
        import_core4.router[method](url, transform.current(data), _options);
      }
    },
    [data, setErrors, transform]
  );
  const setDataFunction = (0, import_react8.useCallback)(
    (keyOrData, maybeValue) => {
      if (typeof keyOrData === "string") {
        setData((data2) => (0, import_lodash_es.set)((0, import_lodash_es.cloneDeep)(data2), keyOrData, maybeValue));
      } else if (typeof keyOrData === "function") {
        setData((data2) => keyOrData(data2));
      } else {
        setData(keyOrData);
      }
    },
    [setData]
  );
  const [dataAsDefaults, setDataAsDefaults] = (0, import_react8.useState)(false);
  const dataRef = (0, import_react8.useRef)(data);
  (0, import_react8.useEffect)(() => {
    dataRef.current = data;
  });
  const setDefaultsFunction = (0, import_react8.useCallback)(
    (fieldOrFields, maybeValue) => {
      setDefaultsCalledInOnSuccess.current = true;
      if (typeof fieldOrFields === "undefined") {
        setDefaults(dataRef.current);
        setDataAsDefaults(true);
      } else {
        setDefaults((defaults2) => {
          return typeof fieldOrFields === "string" ? (0, import_lodash_es.set)((0, import_lodash_es.cloneDeep)(defaults2), fieldOrFields, maybeValue) : Object.assign((0, import_lodash_es.cloneDeep)(defaults2), fieldOrFields);
        });
      }
    },
    [setDefaults]
  );
  (0, import_react8.useLayoutEffect)(() => {
    if (!dataAsDefaults) {
      return;
    }
    if (isDirty) {
      setDefaults(data);
    }
    setDataAsDefaults(false);
  }, [dataAsDefaults]);
  const reset = (0, import_react8.useCallback)(
    (...fields) => {
      if (fields.length === 0) {
        setData(defaults);
      } else {
        setData(
          (data2) => fields.filter((key) => (0, import_lodash_es.has)(defaults, key)).reduce(
            (carry, key) => {
              return (0, import_lodash_es.set)(carry, key, (0, import_lodash_es.get)(defaults, key));
            },
            { ...data2 }
          )
        );
      }
    },
    [setData, defaults]
  );
  const setError = (0, import_react8.useCallback)(
    (fieldOrFields, maybeValue) => {
      setErrors((errors2) => {
        const newErrors = {
          ...errors2,
          ...typeof fieldOrFields === "string" ? { [fieldOrFields]: maybeValue } : fieldOrFields
        };
        setHasErrors(Object.keys(newErrors).length > 0);
        return newErrors;
      });
    },
    [setErrors, setHasErrors]
  );
  const clearErrors = (0, import_react8.useCallback)(
    (...fields) => {
      setErrors((errors2) => {
        const newErrors = Object.keys(errors2).reduce(
          (carry, field) => ({
            ...carry,
            ...fields.length > 0 && !fields.includes(field) ? { [field]: errors2[field] } : {}
          }),
          {}
        );
        setHasErrors(Object.keys(newErrors).length > 0);
        return newErrors;
      });
    },
    [setErrors, setHasErrors]
  );
  const resetAndClearErrors = (0, import_react8.useCallback)(
    (...fields) => {
      reset(...fields);
      clearErrors(...fields);
    },
    [reset, clearErrors]
  );
  const createSubmitMethod = (method) => (url, options) => {
    submit(method, url, options);
  };
  const getMethod = (0, import_react8.useCallback)(createSubmitMethod("get"), [submit]);
  const post = (0, import_react8.useCallback)(createSubmitMethod("post"), [submit]);
  const put = (0, import_react8.useCallback)(createSubmitMethod("put"), [submit]);
  const patch = (0, import_react8.useCallback)(createSubmitMethod("patch"), [submit]);
  const deleteMethod = (0, import_react8.useCallback)(createSubmitMethod("delete"), [submit]);
  const cancel = (0, import_react8.useCallback)(() => {
    if (cancelToken.current) {
      cancelToken.current.cancel();
    }
  }, []);
  const transformFunction = (0, import_react8.useCallback)((callback) => {
    transform.current = callback;
  }, []);
  return {
    data,
    setData: setDataFunction,
    isDirty,
    errors,
    hasErrors,
    processing,
    progress,
    wasSuccessful,
    recentlySuccessful,
    transform: transformFunction,
    setDefaults: setDefaultsFunction,
    reset,
    setError,
    clearErrors,
    resetAndClearErrors,
    submit,
    get: getMethod,
    post,
    put,
    patch,
    delete: deleteMethod,
    cancel
  };
}

// src/Form.ts
var deferStateUpdate = (callback) => {
  typeof import_react9.default.startTransition === "function" ? import_react9.default.startTransition(callback) : setTimeout(callback, 0);
};
var noop = () => void 0;
var Form = (0, import_react9.forwardRef)(
  ({
    action = "",
    method = "get",
    headers = {},
    queryStringArrayFormat = "brackets",
    errorBag = null,
    showProgress = true,
    transform = (data) => data,
    options = {},
    onStart = noop,
    onProgress = noop,
    onFinish = noop,
    onBefore = noop,
    onCancel = noop,
    onSuccess = noop,
    onError = noop,
    onCancelToken = noop,
    onSubmitComplete = noop,
    disableWhileProcessing = false,
    resetOnError = false,
    resetOnSuccess = false,
    setDefaultsOnSuccess = false,
    invalidateCacheTags = [],
    children,
    ...props
  }, ref) => {
    const form = useForm({});
    const formElement = (0, import_react9.useRef)(null);
    const resolvedMethod = (0, import_react9.useMemo)(() => {
      return (0, import_core5.isUrlMethodPair)(action) ? action.method : method.toLowerCase();
    }, [action, method]);
    const [isDirty, setIsDirty] = (0, import_react9.useState)(false);
    const defaultData = (0, import_react9.useRef)(new FormData());
    const getFormData = () => new FormData(formElement.current);
    const getData = () => (0, import_core5.formDataToObject)(getFormData());
    const updateDirtyState = (event) => deferStateUpdate(
      () => setIsDirty(event.type === "reset" ? false : !(0, import_lodash_es2.isEqual)(getData(), (0, import_core5.formDataToObject)(defaultData.current)))
    );
    (0, import_react9.useEffect)(() => {
      defaultData.current = getFormData();
      const formEvents = ["input", "change", "reset"];
      formEvents.forEach((e) => formElement.current.addEventListener(e, updateDirtyState));
      return () => formEvents.forEach((e) => formElement.current?.removeEventListener(e, updateDirtyState));
    }, []);
    const reset = (...fields) => {
      (0, import_core5.resetFormFields)(formElement.current, defaultData.current, fields);
    };
    const resetAndClearErrors = (...fields) => {
      form.clearErrors(...fields);
      reset(...fields);
    };
    const maybeReset = (resetOption) => {
      if (!resetOption) {
        return;
      }
      if (resetOption === true) {
        reset();
      } else if (resetOption.length > 0) {
        reset(...resetOption);
      }
    };
    const submit = () => {
      const [url, _data] = (0, import_core5.mergeDataIntoQueryString)(
        resolvedMethod,
        (0, import_core5.isUrlMethodPair)(action) ? action.url : action,
        getData(),
        queryStringArrayFormat
      );
      const submitOptions = {
        headers,
        errorBag,
        showProgress,
        invalidateCacheTags,
        onCancelToken,
        onBefore,
        onStart,
        onProgress,
        onFinish,
        onCancel,
        onSuccess: (...args) => {
          onSuccess(...args);
          onSubmitComplete({
            reset,
            defaults
          });
          maybeReset(resetOnSuccess);
          if (setDefaultsOnSuccess === true) {
            defaults();
          }
        },
        onError(...args) {
          onError(...args);
          maybeReset(resetOnError);
        },
        ...options
      };
      form.transform(() => transform(_data));
      form.submit(resolvedMethod, url, submitOptions);
    };
    const defaults = () => {
      defaultData.current = getFormData();
      setIsDirty(false);
    };
    const exposed = () => ({
      errors: form.errors,
      hasErrors: form.hasErrors,
      processing: form.processing,
      progress: form.progress,
      wasSuccessful: form.wasSuccessful,
      recentlySuccessful: form.recentlySuccessful,
      isDirty,
      clearErrors: form.clearErrors,
      resetAndClearErrors,
      setError: form.setError,
      reset,
      submit,
      defaults
    });
    (0, import_react9.useImperativeHandle)(ref, exposed, [form, isDirty, submit]);
    return (0, import_react9.createElement)(
      "form",
      {
        ...props,
        ref: formElement,
        action: (0, import_core5.isUrlMethodPair)(action) ? action.url : action,
        method: resolvedMethod,
        onSubmit: (event) => {
          event.preventDefault();
          submit();
        },
        // Only React 19 supports passing a boolean to the `inert` attribute.
        // To support earlier versions as well, we use the string 'true'.
        // Unfortunately, React 19 treats an empty string as `false`.
        // See: https://github.com/inertiajs/inertia/pull/2536
        inert: disableWhileProcessing && form.processing && "true"
      },
      typeof children === "function" ? children(exposed()) : children
    );
  }
);
Form.displayName = "InertiaForm";
var Form_default = Form;

// src/Head.ts
var import_lodash_es3 = require("lodash-es");
var import_react10 = __toESM(require("react"), 1);
var Head = function({ children, title }) {
  const headManager = (0, import_react10.useContext)(HeadContext_default);
  const provider = (0, import_react10.useMemo)(() => headManager.createProvider(), [headManager]);
  const isServer = typeof window === "undefined";
  (0, import_react10.useEffect)(() => {
    provider.reconnect();
    provider.update(renderNodes(children));
    return () => {
      provider.disconnect();
    };
  }, [provider, children, title]);
  function isUnaryTag(node) {
    return [
      "area",
      "base",
      "br",
      "col",
      "embed",
      "hr",
      "img",
      "input",
      "keygen",
      "link",
      "meta",
      "param",
      "source",
      "track",
      "wbr"
    ].indexOf(node.type) > -1;
  }
  function renderTagStart(node) {
    const attrs = Object.keys(node.props).reduce((carry, name) => {
      if (["head-key", "children", "dangerouslySetInnerHTML"].includes(name)) {
        return carry;
      }
      const value = String(node.props[name]);
      if (value === "") {
        return carry + ` ${name}`;
      } else {
        return carry + ` ${name}="${(0, import_lodash_es3.escape)(value)}"`;
      }
    }, "");
    return `<${node.type}${attrs}>`;
  }
  function renderTagChildren(node) {
    return typeof node.props.children === "string" ? node.props.children : node.props.children.reduce((html, child) => html + renderTag(child), "");
  }
  function renderTag(node) {
    let html = renderTagStart(node);
    if (node.props.children) {
      html += renderTagChildren(node);
    }
    if (node.props.dangerouslySetInnerHTML) {
      html += node.props.dangerouslySetInnerHTML.__html;
    }
    if (!isUnaryTag(node)) {
      html += `</${node.type}>`;
    }
    return html;
  }
  function ensureNodeHasInertiaProp(node) {
    return import_react10.default.cloneElement(node, {
      inertia: node.props["head-key"] !== void 0 ? node.props["head-key"] : ""
    });
  }
  function renderNode(node) {
    return renderTag(ensureNodeHasInertiaProp(node));
  }
  function renderNodes(nodes) {
    const computed = import_react10.default.Children.toArray(nodes).filter((node) => node).map((node) => renderNode(node));
    if (title && !computed.find((tag) => tag.startsWith("<title"))) {
      computed.push(`<title inertia>${title}</title>`);
    }
    return computed;
  }
  if (isServer) {
    provider.update(renderNodes(children));
  }
  return null;
};
var Head_default = Head;

// src/Link.ts
var import_core6 = require("@inertiajs/core");
var import_react11 = require("react");
var noop2 = () => void 0;
var Link = (0, import_react11.forwardRef)(
  ({
    children,
    as = "a",
    data = {},
    href = "",
    method = "get",
    preserveScroll = false,
    preserveState = null,
    replace = false,
    only = [],
    except = [],
    headers = {},
    queryStringArrayFormat = "brackets",
    async = false,
    onClick = noop2,
    onCancelToken = noop2,
    onBefore = noop2,
    onStart = noop2,
    onProgress = noop2,
    onFinish = noop2,
    onCancel = noop2,
    onSuccess = noop2,
    onError = noop2,
    onPrefetching = noop2,
    onPrefetched = noop2,
    prefetch = false,
    cacheFor = 0,
    cacheTags = [],
    ...props
  }, ref) => {
    const [inFlightCount, setInFlightCount] = (0, import_react11.useState)(0);
    const hoverTimeout = (0, import_react11.useRef)(null);
    const _method = (0, import_react11.useMemo)(() => {
      return (0, import_core6.isUrlMethodPair)(href) ? href.method : method.toLowerCase();
    }, [href, method]);
    const _as = (0, import_react11.useMemo)(() => {
      if (typeof as !== "string" || as.toLowerCase() !== "a") {
        return as;
      }
      return _method !== "get" ? "button" : as.toLowerCase();
    }, [as, _method]);
    const mergeDataArray = (0, import_react11.useMemo)(
      () => (0, import_core6.mergeDataIntoQueryString)(_method, (0, import_core6.isUrlMethodPair)(href) ? href.url : href, data, queryStringArrayFormat),
      [href, _method, data, queryStringArrayFormat]
    );
    const url = (0, import_react11.useMemo)(() => mergeDataArray[0], [mergeDataArray]);
    const _data = (0, import_react11.useMemo)(() => mergeDataArray[1], [mergeDataArray]);
    const baseParams = (0, import_react11.useMemo)(
      () => ({
        data: _data,
        method: _method,
        preserveScroll,
        preserveState: preserveState ?? _method !== "get",
        replace,
        only,
        except,
        headers,
        async
      }),
      [_data, _method, preserveScroll, preserveState, replace, only, except, headers, async]
    );
    const visitParams = (0, import_react11.useMemo)(
      () => ({
        ...baseParams,
        onCancelToken,
        onBefore,
        onStart(visit) {
          setInFlightCount((count) => count + 1);
          onStart(visit);
        },
        onProgress,
        onFinish(visit) {
          setInFlightCount((count) => count - 1);
          onFinish(visit);
        },
        onCancel,
        onSuccess,
        onError
      }),
      [baseParams, onCancelToken, onBefore, onStart, onProgress, onFinish, onCancel, onSuccess, onError]
    );
    const prefetchModes = (0, import_react11.useMemo)(
      () => {
        if (prefetch === true) {
          return ["hover"];
        }
        if (prefetch === false) {
          return [];
        }
        if (Array.isArray(prefetch)) {
          return prefetch;
        }
        return [prefetch];
      },
      Array.isArray(prefetch) ? prefetch : [prefetch]
    );
    const cacheForValue = (0, import_react11.useMemo)(() => {
      if (cacheFor !== 0) {
        return cacheFor;
      }
      if (prefetchModes.length === 1 && prefetchModes[0] === "click") {
        return 0;
      }
      return 3e4;
    }, [cacheFor, prefetchModes]);
    const doPrefetch = (0, import_react11.useMemo)(() => {
      return () => {
        import_core6.router.prefetch(
          url,
          {
            ...baseParams,
            onPrefetching,
            onPrefetched
          },
          { cacheFor: cacheForValue, cacheTags }
        );
      };
    }, [url, baseParams, onPrefetching, onPrefetched, cacheForValue, cacheTags]);
    (0, import_react11.useEffect)(() => {
      return () => {
        clearTimeout(hoverTimeout.current);
      };
    }, []);
    (0, import_react11.useEffect)(() => {
      if (prefetchModes.includes("mount")) {
        setTimeout(() => doPrefetch());
      }
    }, prefetchModes);
    const regularEvents = {
      onClick: (event) => {
        onClick(event);
        if ((0, import_core6.shouldIntercept)(event)) {
          event.preventDefault();
          import_core6.router.visit(url, visitParams);
        }
      }
    };
    const prefetchHoverEvents = {
      onMouseEnter: () => {
        hoverTimeout.current = window.setTimeout(() => {
          doPrefetch();
        }, 75);
      },
      onMouseLeave: () => {
        clearTimeout(hoverTimeout.current);
      },
      onClick: regularEvents.onClick
    };
    const prefetchClickEvents = {
      onMouseDown: (event) => {
        if ((0, import_core6.shouldIntercept)(event)) {
          event.preventDefault();
          doPrefetch();
        }
      },
      onKeyDown: (event) => {
        if ((0, import_core6.shouldIntercept)(event) && (0, import_core6.shouldNavigate)(event)) {
          event.preventDefault();
          doPrefetch();
        }
      },
      onMouseUp: (event) => {
        event.preventDefault();
        import_core6.router.visit(url, visitParams);
      },
      onKeyUp: (event) => {
        if ((0, import_core6.shouldNavigate)(event)) {
          event.preventDefault();
          import_core6.router.visit(url, visitParams);
        }
      },
      onClick: (event) => {
        onClick(event);
        if ((0, import_core6.shouldIntercept)(event)) {
          event.preventDefault();
        }
      }
    };
    const elProps = (0, import_react11.useMemo)(() => {
      if (_as === "button") {
        return { type: "button" };
      }
      if (_as === "a" || typeof _as !== "string") {
        return { href: url };
      }
      return {};
    }, [_as, url]);
    return (0, import_react11.createElement)(
      _as,
      {
        ...props,
        ...elProps,
        ref,
        ...(() => {
          if (prefetchModes.includes("hover")) {
            return prefetchHoverEvents;
          }
          if (prefetchModes.includes("click")) {
            return prefetchClickEvents;
          }
          return regularEvents;
        })(),
        "data-loading": inFlightCount > 0 ? "" : void 0
      },
      children
    );
  }
);
Link.displayName = "InertiaLink";
var Link_default = Link;

// src/usePoll.ts
var import_core7 = require("@inertiajs/core");
var import_react12 = require("react");
function usePoll(interval, requestOptions = {}, options = {
  keepAlive: false,
  autoStart: true
}) {
  const pollRef = (0, import_react12.useRef)(
    import_core7.router.poll(interval, requestOptions, {
      ...options,
      autoStart: false
    })
  );
  (0, import_react12.useEffect)(() => {
    if (options.autoStart ?? true) {
      pollRef.current.start();
    }
    return () => pollRef.current.stop();
  }, []);
  return {
    stop: pollRef.current.stop,
    start: pollRef.current.start
  };
}

// src/usePrefetch.ts
var import_core8 = require("@inertiajs/core");
var import_react13 = require("react");
function usePrefetch(options = {}) {
  const cached = typeof window === "undefined" ? null : import_core8.router.getCached(window.location.pathname, options);
  const inFlight = typeof window === "undefined" ? null : import_core8.router.getPrefetching(window.location.pathname, options);
  const [lastUpdatedAt, setLastUpdatedAt] = (0, import_react13.useState)(cached?.staleTimestamp || null);
  const [isPrefetching, setIsPrefetching] = (0, import_react13.useState)(inFlight !== null);
  const [isPrefetched, setIsPrefetched] = (0, import_react13.useState)(cached !== null);
  (0, import_react13.useEffect)(() => {
    const onPrefetchingListener = import_core8.router.on("prefetching", (e) => {
      if (e.detail.visit.url.pathname === window.location.pathname) {
        setIsPrefetching(true);
      }
    });
    const onPrefetchedListener = import_core8.router.on("prefetched", (e) => {
      if (e.detail.visit.url.pathname === window.location.pathname) {
        setIsPrefetching(false);
        setIsPrefetched(true);
        setLastUpdatedAt(e.detail.fetchedAt);
      }
    });
    return () => {
      onPrefetchedListener();
      onPrefetchingListener();
    };
  }, []);
  return {
    lastUpdatedAt,
    isPrefetching,
    isPrefetched,
    flush: () => import_core8.router.flush(window.location.pathname, options)
  };
}

// src/WhenVisible.ts
var import_core9 = require("@inertiajs/core");
var import_react14 = require("react");
var WhenVisible = ({ children, data, params, buffer, as, always, fallback }) => {
  always = always ?? false;
  as = as ?? "div";
  fallback = fallback ?? null;
  const [loaded, setLoaded] = (0, import_react14.useState)(false);
  const hasFetched = (0, import_react14.useRef)(false);
  const fetching = (0, import_react14.useRef)(false);
  const ref = (0, import_react14.useRef)(null);
  const getReloadParams = (0, import_react14.useCallback)(() => {
    if (data) {
      return {
        only: Array.isArray(data) ? data : [data]
      };
    }
    if (!params) {
      throw new Error("You must provide either a `data` or `params` prop.");
    }
    return params;
  }, [params, data]);
  (0, import_react14.useEffect)(() => {
    if (!ref.current) {
      return;
    }
    const observer = new IntersectionObserver(
      (entries) => {
        if (!entries[0].isIntersecting) {
          return;
        }
        if (!always && hasFetched.current) {
          observer.disconnect();
        }
        if (fetching.current) {
          return;
        }
        hasFetched.current = true;
        fetching.current = true;
        const reloadParams = getReloadParams();
        import_core9.router.reload({
          ...reloadParams,
          onStart: (e) => {
            fetching.current = true;
            reloadParams.onStart?.(e);
          },
          onFinish: (e) => {
            setLoaded(true);
            fetching.current = false;
            reloadParams.onFinish?.(e);
            if (!always) {
              observer.disconnect();
            }
          }
        });
      },
      {
        rootMargin: `${buffer || 0}px`
      }
    );
    observer.observe(ref.current);
    return () => {
      observer.disconnect();
    };
  }, [ref, getReloadParams, buffer]);
  const resolveChildren = () => typeof children === "function" ? children() : children;
  const resolveFallback = () => typeof fallback === "function" ? fallback() : fallback;
  if (always || !loaded) {
    return (0, import_react14.createElement)(
      as,
      {
        props: null,
        ref
      },
      loaded ? resolveChildren() : resolveFallback()
    );
  }
  return loaded ? resolveChildren() : null;
};
WhenVisible.displayName = "InertiaWhenVisible";
var WhenVisible_default = WhenVisible;

// src/index.ts
var router3 = import_core10.router;
//# sourceMappingURL=index.js.map
