(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@tiptap/core')) :
  typeof define === 'function' && define.amd ? define(['exports', '@tiptap/core'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global["@tiptap/extension-table-header"] = {}, global.core));
})(this, (function (exports, core) { 'use strict';

  /**
   * This extension allows you to create table headers.
   * @see https://www.tiptap.dev/api/nodes/table-header
   */
  const TableHeader = core.Node.create({
      name: 'tableHeader',
      addOptions() {
          return {
              HTMLAttributes: {},
          };
      },
      content: 'block+',
      addAttributes() {
          return {
              colspan: {
                  default: 1,
              },
              rowspan: {
                  default: 1,
              },
              colwidth: {
                  default: null,
                  parseHTML: element => {
                      const colwidth = element.getAttribute('colwidth');
                      const value = colwidth
                          ? colwidth.split(',').map(width => parseInt(width, 10))
                          : null;
                      return value;
                  },
              },
          };
      },
      tableRole: 'header_cell',
      isolating: true,
      parseHTML() {
          return [
              { tag: 'th' },
          ];
      },
      renderHTML({ HTMLAttributes }) {
          return ['th', core.mergeAttributes(this.options.HTMLAttributes, HTMLAttributes), 0];
      },
  });

  exports.TableHeader = TableHeader;
  exports.default = TableHeader;

  Object.defineProperty(exports, '__esModule', { value: true });

}));
//# sourceMappingURL=index.umd.js.map
