import { D as DefaultSizes, M as Module$1, E as Empty } from './interface-BJPeIO0W.js';
import 'vite';


type Module = typeof window['analyzeModule'][number];

declare global {
  interface Window {
    defaultSizes: DefaultSizes
    analyzeModule: Array<Module$1>
    CUSTOM_SIDE_BAR: boolean
  }
}

declare const ALLOWED_MAGIC_TYPE: readonly ["graph:click", "client:ready", "send:ui", "send:filter"];
type AllowedMagicType = typeof ALLOWED_MAGIC_TYPE[number];
declare function createMagicEvent(type: AllowedMagicType, data: Empty): CustomEvent<{}>;
type QueryKind = 'gzip' | 'stat' | 'brotli';
declare const IS_CUSTOM_SIDE_BAR: boolean;
interface SendUIMessage {
    Component: () => JSX.Element;
    type: 'SideBar' | 'Main';
}
interface SendFilterMessage {
    analyzeModule: Module[];
}

export { ALLOWED_MAGIC_TYPE, IS_CUSTOM_SIDE_BAR, createMagicEvent };
export type { AllowedMagicType, QueryKind, SendFilterMessage, SendUIMessage };
