import http from 'http';
import { M as Module, D as DefaultSizes, A as AnalyzerPluginInternalAPI, a as AnalyzerPluginOptions } from './interface-BJPeIO0W.js';
export { b as AnalyzerMode } from './interface-BJPeIO0W.js';
import { Plugin } from 'vite';
import { Readable } from 'stream';
import { Plugin as Plugin$1 } from 'rollup';
// @ts-ignore If rolldown is not used, this import may cause a tsc error. We use `@ts-ignore` to suppress type checking.
import { Plugin as Plugin$2 } from 'rolldown';
import 'zlib';

interface RenderOptions {
    title: string;
    mode: DefaultSizes;
}
declare function renderView(analyzeModule: Module[], options: RenderOptions): Promise<string>;
declare function ensureEmptyPort(preferredPort: number): Promise<number>;
interface C {
    req: http.IncomingMessage;
    res: http.ServerResponse;
    query: Record<string, string>;
    params: Record<string, string>;
}
type Middleware = (c: C, next: () => void) => void;
interface CreateServerContext {
    use: (middleware: Middleware) => void;
    get: (path: string, middleware: Middleware) => void;
    listen: (port: number, callback?: () => void) => void;
}
declare function createServer(): CreateServerContext;
interface Descriptor {
    kind: 'script' | 'style' | 'title';
    text: string;
    attrs?: string[];
}
interface Descriptor {
    kind: 'script' | 'style' | 'title';
    text: string;
    attrs?: string[];
}
interface InjectHTMLTagOptions {
    html: string;
    injectTo: 'body' | 'head';
    descriptors: Descriptor | Descriptor[];
}
declare function injectHTMLTag(options: InjectHTMLTagOptions): string;
interface SSEMessageBody {
    event: string;
    data: string;
}
declare class SSE {
    private activeStreams;
    serverEventStream(req: http.IncomingMessage, res: http.ServerResponse): void;
    sendEvent(event: string, data: string): void;
    private removeStream;
}

declare function arena(): {
    rs: Readable;
    into(b: string | Uint8Array): void;
    refresh(data?: string | Uint8Array): void;
};

declare function adapter(userPlugin: Plugin<AnalyzerPluginInternalAPI>): Pick<Plugin<AnalyzerPluginInternalAPI>, "closeBundle" | "generateBundle" | "name" | "api"> | Plugin$1<any>;

declare function unstableRolldownAdapter(userPlugin: Plugin<AnalyzerPluginInternalAPI>): Pick<Plugin<AnalyzerPluginInternalAPI>, "generateBundle" | "name" | "api"> | Plugin$2<any>;

declare const isCI: boolean;
declare function openBrowser(address: string): void;
declare function handleStaticOutput(analyzeModule: Module[], opts: AnalyzerPluginOptions, defaultWd: string, b: ReturnType<typeof arena>): Promise<{
    filePath: string;
    isJSON: boolean;
    html?: undefined;
} | {
    filePath: string;
    isJSON: boolean;
    html: string;
}>;
declare function createAnalyzerServer(analyzeModule: Module[], opts: AnalyzerPluginOptions, b: ReturnType<typeof arena>, callCount: number, sseHandler?: {
    path: string;
    handler: Middleware;
}, render?: typeof renderView): Promise<{
    server: CreateServerContext;
    port: number;
}>;
declare function analyzer(opts?: AnalyzerPluginOptions): Plugin<AnalyzerPluginInternalAPI>;

export { AnalyzerPluginInternalAPI, AnalyzerPluginOptions, DefaultSizes, Module, SSE, adapter, analyzer, createAnalyzerServer, createServer, analyzer as default, ensureEmptyPort, handleStaticOutput, injectHTMLTag, isCI, openBrowser, renderView, unstableRolldownAdapter };
export type { C, CreateServerContext, Descriptor, Middleware, RenderOptions, SSEMessageBody };
