import React from 'react';

export default function AboutHero({ hero }) {
    if (!hero) return null;

    return (
        <section className="bg-gradient-to-r from-blue-600 to-purple-600 dark:from-blue-800 dark:to-purple-900 py-16 text-white">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                <div className="text-center">
                    <h1 className="text-4xl md:text-5xl font-bold mb-6">
                        {hero.title}
                    </h1>
                    <div 
                        className="text-xl md:text-2xl mb-8 max-w-3xl mx-auto content-area text-blue-50 dark:text-blue-100"
                        dangerouslySetInnerHTML={{ __html: hero.description }}
                    />
                    <div className="flex flex-col sm:flex-row gap-4 justify-center">
                        <a
                            href={hero.primaryButtonLink}
                            className="bg-white text-blue-600 hover:bg-gray-100 dark:bg-gray-100 dark:hover:bg-white px-8 py-4 rounded-lg font-bold text-lg transition-colors"
                        >
                            {hero.primaryButtonText}
                        </a>
                        <a
                            href={hero.secondaryButtonLink}
                            className="border-2 border-white text-white hover:bg-white hover:text-blue-600 dark:hover:bg-gray-100 px-8 py-4 rounded-lg font-bold text-lg transition-colors"
                        >
                            {hero.secondaryButtonText}
                        </a>
                    </div>
                </div>
            </div>
        </section>
    );
}




