import React from 'react';

export default function AboutWhyChoose({ title, description, reasons }) {
    if (!reasons || reasons.length === 0) return null;

    const getIconColor = (index) => {
        const colors = [
            { bg: 'bg-green-100', text: 'text-green-600', darkBg: 'dark:bg-green-900/30', darkText: 'dark:text-green-400' },
            { bg: 'bg-blue-100', text: 'text-blue-600', darkBg: 'dark:bg-blue-900/30', darkText: 'dark:text-blue-400' },
            { bg: 'bg-purple-100', text: 'text-purple-600', darkBg: 'dark:bg-purple-900/30', darkText: 'dark:text-purple-400' },
            { bg: 'bg-yellow-100', text: 'text-yellow-600', darkBg: 'dark:bg-yellow-900/30', darkText: 'dark:text-yellow-400' },
            { bg: 'bg-red-100', text: 'text-red-600', darkBg: 'dark:bg-red-900/30', darkText: 'dark:text-red-400' },
            { bg: 'bg-indigo-100', text: 'text-indigo-600', darkBg: 'dark:bg-indigo-900/30', darkText: 'dark:text-indigo-400' },
        ];
        return colors[index % colors.length];
    };

    return (
        <section className="py-16 bg-gray-50 dark:bg-gray-800">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                {title && (
                    <div className="text-center mb-12">
                        <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                            {title}
                        </h2>
                        {description && (
                            <div 
                                className="text-xl text-gray-600 dark:text-gray-300 content-area"
                                dangerouslySetInnerHTML={{ __html: description }}
                            />
                        )}
                    </div>
                )}

                <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
                    {reasons.map((reason, index) => {
                        const colors = getIconColor(index);
                        return (
                            <div key={index} className="flex items-start">
                                <div className={`flex-shrink-0 w-12 h-12 ${colors.bg} ${colors.darkBg} rounded-lg flex items-center justify-center mr-4`}>
                                    <svg
                                        className={`w-6 h-6 ${colors.text} ${colors.darkText}`}
                                        fill="currentColor"
                                        viewBox="0 0 20 20"
                                    >
                                        <path d={reason.iconPath} />
                                    </svg>
                                </div>
                                <div>
                                    <h3 className="text-lg font-semibold text-gray-900 dark:text-white mb-2">
                                        {reason.title}
                                    </h3>
                                    <div 
                                        className="text-gray-600 dark:text-gray-300 content-area"
                                        dangerouslySetInnerHTML={{ __html: reason.description }}
                                    />
                                </div>
                            </div>
                        );
                    })}
                </div>
            </div>
        </section>
    );
}




