import { Head } from "@inertiajs/react";

export default function Analytics() {
    // Replace these with your actual tracking IDs
    const gtmId = "GT-MKBN4JGT"; // Replace with your Google Tag Manager ID
    const gaId = "G-MM88KHWML5"; // Replace with your GA4 Measurement ID
    const hotjarId = "XXXXXXX"; // Replace with your Hotjar Site ID (optional)

    return (
        <Head>
            {/* Google Tag Manager */}
            <script
                dangerouslySetInnerHTML={{
                    __html: `
                        (function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
                        new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
                        j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
                        'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
                        })(window,document,'script','dataLayer','${gtmId}');
                    `,
                }}
            />

            {/* Google Analytics 4 */}
            <script
                async
                src={`https://www.googletagmanager.com/gtag/js?id=${gaId}`}
            ></script>
            <script
                dangerouslySetInnerHTML={{
                    __html: `
                        window.dataLayer = window.dataLayer || [];
                        function gtag(){dataLayer.push(arguments);}
                        gtag('js', new Date());

                        gtag('config', '${gaId}', {
                            page_title: 'Academic Writing Services | Academic Scribe',
                            page_location: window.location.href,
                            content_group1: 'Academic Writing Services',
                            content_group2: 'Homepage',
                            custom_map: {
                                'dimension1': 'service_type',
                                'dimension2': 'academic_level',
                                'dimension3': 'user_type',
                                'dimension4': 'traffic_source'
                            },
                            // Enhanced ecommerce for academic services
                            send_page_view: true,
                            anonymize_ip: true,
                            allow_google_signals: true,
                            allow_ad_personalization_signals: true
                        });

                        // Track academic writing service interactions
                        window.trackAcademicService = function(action, service_type, academic_level, value) {
                            gtag('event', action, {
                                event_category: 'Academic Writing Services',
                                event_label: service_type,
                                custom_parameter_service_type: service_type,
                                custom_parameter_academic_level: academic_level,
                                value: value || 0,
                                currency: 'USD'
                            });
                        };

                        // Track quote requests for academic writing services
                        window.trackQuoteRequest = function(service_type, academic_level, estimated_value) {
                            gtag('event', 'generate_lead', {
                                event_category: 'Academic Writing Services',
                                event_label: 'Quote Request - ' + service_type,
                                lead_type: 'academic_writing_quote',
                                service_type: service_type,
                                academic_level: academic_level,
                                value: estimated_value || 50,
                                currency: 'USD'
                            });

                            // Also track as conversion
                            gtag('event', 'conversion', {
                                send_to: '${gaId}/quote_request',
                                event_category: 'Academic Writing Services',
                                event_label: service_type,
                                value: estimated_value || 50,
                                currency: 'USD'
                            });
                        };

                        // Track form interactions for academic services
                        window.trackFormInteraction = function(form_name, field_name, service_context) {
                            gtag('event', 'form_interaction', {
                                event_category: 'Form Engagement',
                                event_label: form_name + ' - ' + field_name,
                                form_type: form_name,
                                field_name: field_name,
                                service_context: service_context || 'academic_writing_services'
                            });
                        };

                        // Track service page visits
                        window.trackServiceView = function(service_name, service_category) {
                            gtag('event', 'view_item', {
                                event_category: 'Academic Writing Services',
                                event_label: 'Service View - ' + service_name,
                                item_category: service_category,
                                item_name: service_name,
                                content_type: 'academic_service'
                            });
                        };

                        // Track consultation requests
                        window.trackConsultationRequest = function(consultation_type, preferred_time) {
                            gtag('event', 'schedule_consultation', {
                                event_category: 'Academic Writing Services',
                                event_label: 'Consultation Request - ' + consultation_type,
                                consultation_type: consultation_type,
                                preferred_time: preferred_time,
                                value: 25,
                                currency: 'USD'
                            });
                        };

                        // Track FAQ interactions
                        window.trackFAQInteraction = function(question, section) {
                            gtag('event', 'faq_interaction', {
                                event_category: 'User Engagement',
                                event_label: 'FAQ - ' + question.substring(0, 50),
                                faq_section: section,
                                content_type: 'faq'
                            });
                        };

                        // Track testimonial interactions
                        window.trackTestimonialView = function(testimonial_type, testimonial_id) {
                            gtag('event', 'testimonial_view', {
                                event_category: 'Social Proof',
                                event_label: 'Testimonial View - ' + testimonial_type,
                                testimonial_type: testimonial_type,
                                testimonial_id: testimonial_id
                            });
                        };

                        // Track CTA clicks
                        window.trackCTAClick = function(cta_text, cta_location, target_service) {
                            gtag('event', 'cta_click', {
                                event_category: 'Call to Action',
                                event_label: cta_text + ' - ' + cta_location,
                                cta_text: cta_text,
                                cta_location: cta_location,
                                target_service: target_service || 'academic_writing_services'
                            });
                        };

                        // Track scroll depth for engagement
                        window.trackScrollDepth = function(depth_percentage) {
                            gtag('event', 'scroll', {
                                event_category: 'User Engagement',
                                event_label: 'Scroll Depth - ' + depth_percentage + '%',
                                scroll_depth: depth_percentage,
                                page_type: 'homepage'
                            });
                        };

                        // Track time on page milestones
                        window.trackTimeOnPage = function(time_seconds) {
                            gtag('event', 'time_on_page', {
                                event_category: 'User Engagement',
                                event_label: 'Time on Page - ' + time_seconds + 's',
                                time_seconds: time_seconds,
                                page_type: 'homepage'
                            });
                        };
                    `,
                }}
            />

            {/* Hotjar Tracking Code (Optional - for heatmaps and user recordings) */}
            {hotjarId && (
                <script
                    dangerouslySetInnerHTML={{
                        __html: `
                            (function(h,o,t,j,a,r){
                                h.hj=h.hj||function(){(h.hj.q=h.hj.q||[]).push(arguments)};
                                h._hjSettings={hjid:${hotjarId},hjsv:6};
                                a=o.getElementsByTagName('head')[0];
                                r=o.createElement('script');r.async=1;
                                r.src=t+h._hjSettings.hjid+j+h._hjSettings.hjsv;
                                a.appendChild(r);
                            })(window,document,'https://static.hotjar.com/c/hotjar-','.js?sv=');
                        `,
                    }}
                />
            )}

            {/* Facebook Pixel (Optional - for social media advertising) */}
            <script
                dangerouslySetInnerHTML={{
                    __html: `
                        !function(f,b,e,v,n,t,s)
                        {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
                        n.callMethod.apply(n,arguments):n.queue.push(arguments)};
                        if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
                        n.queue=[];t=b.createElement(e);t.async=!0;
                        t.src=v;s=b.getElementsByTagName(e)[0];
                        s.parentNode.insertBefore(t,s)}(window, document,'script',
                        'https://connect.facebook.net/en_US/fbevents.js');

                        // Replace 'YOUR_PIXEL_ID' with your actual Facebook Pixel ID
                        // fbq('init', 'YOUR_PIXEL_ID');
                        // fbq('track', 'PageView');

                        // Track academic service leads
                        window.trackFacebookLead = function(service_type, value) {
                            if (typeof fbq !== 'undefined') {
                                fbq('track', 'Lead', {
                                    content_category: 'Academic Writing Services',
                                    content_name: service_type,
                                    value: value || 50,
                                    currency: 'USD'
                                });
                            }
                        };
                    `,
                }}
            />

            {/* Microsoft Clarity (Optional - for user behavior analytics) */}
            <script
                dangerouslySetInnerHTML={{
                    __html: `
                        (function(c,l,a,r,i,t,y){
                            c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
                            t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
                            y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
                        })(window, document, "clarity", "script", "YOUR_CLARITY_ID");
                    `,
                }}
            />

            {/* Google Tag Manager (noscript) - Place this immediately after opening <body> tag */}
            <noscript>
                <iframe
                    src={`https://www.googletagmanager.com/ns.html?id=${gtmId}`}
                    height="0"
                    width="0"
                    style={{ display: "none", visibility: "hidden" }}
                ></iframe>
            </noscript>
        </Head>
    );
}
