import React from 'react';

// Import individual content block components
import HeroBlock from './blocks/HeroBlock';
import OverviewBlock from './blocks/OverviewBlock';
import BenefitsBlock from './blocks/BenefitsBlock';
import ProcessBlock from './blocks/ProcessBlock';
import TestimonialsBlock from './blocks/TestimonialsBlock';
import FAQsBlock from './blocks/FAQsBlock';
import ContactFormBlock from './blocks/ContactFormBlock';
import CTABlock from './blocks/CTABlock';
import FeaturesBlock from './blocks/FeaturesBlock';
import PricingBlock from './blocks/PricingBlock';
import GalleryBlock from './blocks/GalleryBlock';
import TextContentBlock from './blocks/TextContentBlock';
import VideoBlock from './blocks/VideoBlock';
import AboutBlock from './blocks/AboutBlock';
import ServicesBlock from './blocks/ServicesBlock';
import StatsBlock from './blocks/StatsBlock';
import ContactBlock from './blocks/ContactBlock';
import PriceCalculatorSection from './PriceCalculatorSection';

export default function ContentBlockRenderer({ blocks }) {
    if (!blocks || blocks.length === 0) {
        return null;
    }

    // Sort blocks by order
    const sortedBlocks = [...blocks].sort((a, b) => a.order - b.order);

    return (
        <div className="content-blocks">
            {sortedBlocks.map((block) => {
                if (!block.is_active) {
                    return null;
                }

                const blockProps = {
                    id: block.id,
                    type: block.type,
                    content: block.content,
                    blockKey: block.key,
                };

                // Render the appropriate component based on block type
                switch (block.type) {
                    case 'hero':
                        return <HeroBlock key={block.id} {...blockProps} />;
                    case 'overview':
                        return <OverviewBlock key={block.id} {...blockProps} />;
                    case 'benefits':
                        return <BenefitsBlock key={block.id} {...blockProps} />;
                    case 'process':
                        return <ProcessBlock key={block.id} {...blockProps} />;
                    case 'testimonials':
                        return <TestimonialsBlock key={block.id} {...blockProps} />;
                    case 'faqs':
                        return <FAQsBlock key={block.id} {...blockProps} />;
                    case 'contact_form':
                        return <ContactFormBlock key={block.id} {...blockProps} />;
                    case 'cta':
                        return <CTABlock key={block.id} {...blockProps} />;
                    case 'features':
                        return <FeaturesBlock key={block.id} {...blockProps} />;
                    case 'pricing':
                        return <PricingBlock key={block.id} {...blockProps} />;
                    case 'gallery':
                        return <GalleryBlock key={block.id} {...blockProps} />;
                    case 'text_content':
                        return <TextContentBlock key={block.id} {...blockProps} />;
                    case 'video':
                        return <VideoBlock key={block.id} {...blockProps} />;
                    case 'about':
                        return <AboutBlock key={block.id} {...blockProps} />;
                    case 'services':
                        return <ServicesBlock key={block.id} {...blockProps} />;
                    case 'stats':
                        return <StatsBlock key={block.id} {...blockProps} />;
                    case 'contact':
                        return <ContactBlock key={block.id} {...blockProps} />;
                    case 'price_calculator':
                        return <PriceCalculatorSection key={block.id} content={block.content} />;
                    default:
                        return (
                            <div key={block.id} className="unknown-block">
                                <div className="container mx-auto px-4 py-8">
                                    <div className="bg-yellow-50 border border-yellow-200 rounded-lg p-4">
                                        <h3 className="text-lg font-medium text-yellow-800 mb-2">
                                            Unknown Block Type: {block.type}
                                        </h3>
                                        <p className="text-yellow-700">
                                            This content block type is not yet implemented.
                                        </p>
                                        {process.env.NODE_ENV === 'development' && (
                                            <pre className="mt-2 text-xs bg-yellow-100 p-2 rounded">
                                                {JSON.stringify(block.content, null, 2)}
                                            </pre>
                                        )}
                                    </div>
                                </div>
                            </div>
                        );
                }
            })}
        </div>
    );
}
