import React from 'react';

export default function ProcessBlock({ content }) {
    if (!content) return null;

    const {
        title = '',
        subtitle = '',
        steps = []
    } = content;

    return (
        <section className="process-section py-16 bg-white">
            <div className="container mx-auto px-4">
                <div className="text-center mb-12">
                    {title && (
                        <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
                            {title}
                        </h2>
                    )}
                    
                    {subtitle && (
                        <p className="text-lg text-gray-600 max-w-2xl mx-auto">
                            {subtitle}
                        </p>
                    )}
                </div>
                
                {steps && steps.length > 0 && (
                    <div className="relative">
                        {/* Process line */}
                        <div className="hidden md:block absolute top-12 left-0 right-0 h-0.5 bg-gray-200"></div>
                        
                        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                            {steps.map((step, index) => (
                                <div key={index} className="relative text-center">
                                    {/* Step number */}
                                    <div className="relative z-10 w-24 h-24 bg-blue-600 text-white rounded-full flex items-center justify-center text-2xl font-bold mx-auto mb-4">
                                        {step.number || index + 1}
                                    </div>
                                    
                                    {/* Step content */}
                                    <div className="bg-gray-50 dark:bg-gray-700 rounded-lg p-6">
                                        <h3 className="text-xl font-semibold text-gray-900 dark:text-white mb-3">
                                            {step.title}
                                        </h3>
                                        <div 
                                            className="text-gray-600 dark:text-gray-300 leading-relaxed prose prose-sm dark:prose-invert max-w-none"
                                            dangerouslySetInnerHTML={{ __html: step.description }}
                                        />
                                    </div>
                                </div>
                            ))}
                        </div>
                    </div>
                )}
            </div>
        </section>
    );
}
