import { Head } from "@inertiajs/react";

export default function FaqSchema() {
    const faqSchema = {
        "@context": "https://schema.org",
        "@type": "FAQPage",
        mainEntity: [
            {
                "@type": "Question",
                name: "What academic writing services do you offer?",
                acceptedAnswer: {
                    "@type": "Answer",
                    text: "We provide comprehensive academic writing services including dissertation writing help, research paper writing service, custom academic papers, essay writing, thesis proposals, literature reviews, and case studies. Our professional essay writers hold PhD degrees in various academic disciplines and specialize in PhD dissertation writing for students at all academic levels.",
                },
            },
            {
                "@type": "Question",
                name: "How do you ensure academic integrity in your writing services?",
                acceptedAnswer: {
                    "@type": "Answer",
                    text: "We maintain strict academic integrity by providing original, plagiarism-free content for all our academic writing services. Every custom academic paper is written from scratch by our professional essay writers, properly cited using your preferred style (APA, MLA, Chicago, etc.), and checked through professional plagiarism detection software before delivery. Our dissertation writing help and research paper writing service guarantee 100% original content.",
                },
            },
            {
                "@type": "Question",
                name: "What qualifications do your academic writers have?",
                acceptedAnswer: {
                    "@type": "Answer",
                    text: "Our professional essay writers hold advanced degrees (Master's and PhDs) from accredited universities across various disciplines. We have over 180 expert writers specializing in different fields. For PhD dissertation writing and advanced research paper writing service, we match your project with a writer who has relevant subject-matter expertise and academic background in your specific field. All our writers have extensive experience in academic writing services.",
                },
            },
            {
                "@type": "Question",
                name: "How confidential is your academic writing service?",
                acceptedAnswer: {
                    "@type": "Answer",
                    text: "We guarantee complete confidentiality for all our academic writing services. Your personal information is protected by advanced encryption, and we never share your details with third parties. Whether you need dissertation writing help, research paper writing service, or custom academic papers, your transactions and communications remain private. We operate with a strict non-disclosure policy to protect all clients using our professional essay writers.",
                },
            },
            {
                "@type": "Question",
                name: "Do you offer revisions for custom academic papers?",
                acceptedAnswer: {
                    "@type": "Answer",
                    text: "Yes, we provide unlimited free revisions within 14 days of delivery for all our academic writing services. If any aspects of your dissertation writing help, research paper writing service, PhD dissertation writing, or custom academic papers don't meet the requirements you specified, our professional essay writers will revise the work until you're completely satisfied, at no additional cost.",
                },
            },
            {
                "@type": "Question",
                name: "What is your pricing for academic writing services?",
                acceptedAnswer: {
                    "@type": "Answer",
                    text: "Our academic writing services pricing is transparent and competitive, based on academic level, deadline, page count, and complexity. We offer affordable rates for dissertation writing help, research paper writing service, and custom academic papers. Longer deadlines generally mean lower prices, and we frequently provide special discounts for returning customers. Our professional essay writers deliver quality PhD dissertation writing at fair market rates.",
                },
            },
            {
                "@type": "Question",
                name: "How fast can you complete my academic writing project?",
                acceptedAnswer: {
                    "@type": "Answer",
                    text: "Our academic writing services can accommodate various deadlines depending on the project complexity. For standard essays and custom academic papers, we can deliver within 3-6 hours for urgent requests. Research paper writing service typically requires 12-48 hours, while dissertation writing help and PhD dissertation writing may need several days to weeks depending on length and complexity. Our professional essay writers work efficiently while maintaining quality standards.",
                },
            },
            {
                "@type": "Question",
                name: "Can I communicate directly with my assigned writer?",
                acceptedAnswer: {
                    "@type": "Answer",
                    text: "Yes, our academic writing services include direct communication with your assigned writer through our secure messaging system. Whether you need dissertation writing help, research paper writing service, or custom academic papers, you can discuss requirements, provide additional instructions, and track progress. Our professional essay writers are available for consultation throughout the PhD dissertation writing process to ensure your satisfaction.",
                },
            },
            {
                "@type": "Question",
                name: "What academic levels do you cover?",
                acceptedAnswer: {
                    "@type": "Answer",
                    text: "Our academic writing services cover all educational levels from high school to doctoral programs. We provide dissertation writing help for PhD students, research paper writing service for graduate and undergraduate students, and custom academic papers for all academic levels. Our professional essay writers specialize in undergraduate, master's, and PhD dissertation writing across 35+ academic disciplines.",
                },
            },
            {
                "@type": "Question",
                name: "Do you guarantee plagiarism-free content?",
                acceptedAnswer: {
                    "@type": "Answer",
                    text: "Absolutely! All our academic writing services guarantee 100% plagiarism-free content. Every custom academic paper, dissertation writing help project, and research paper writing service delivery includes a detailed plagiarism report. Our professional essay writers create original content from scratch, and we use advanced plagiarism detection software to verify originality before delivery. PhD dissertation writing and all academic papers come with our plagiarism-free guarantee.",
                },
            },
        ],
    };

    return (
        <Head>
            <script
                type="application/ld+json"
                dangerouslySetInnerHTML={{
                    __html: JSON.stringify(faqSchema),
                }}
            />
        </Head>
    );
}
