import { Link, usePage } from "@inertiajs/react";
import {
    Mail,
    Phone,
    MapPin,
} from "lucide-react";

export default function Footer() {
    const currentYear = new Date().getFullYear();
    const { footerData } = usePage().props;

    // Fallback data if CMS data is not available
    const {
        companyInfo = { title: 'Academic Scribe', description: '' },
        serviceLinks = [],
        quickLinks = [],
        contactInfo = { email: '', phone: '', phone_description: '', address: {} },
        legalLinks = [],
        copyrightText = 'Academic Scribe. All rights reserved.'
    } = footerData || {};

    return (
        <>
            {/* Footer */}
            <footer className="bg-gradient-to-b from-blue-100 to-white dark:bg-none dark:bg-gray-900 text-gray-800 dark:text-white">
                <div className="w-full mx-auto px-4 sm:px-6 lg:px-8">
                    {/* Main Footer */}
                    <div className="py-12 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                        {/* Company Info */}
                        <div>
                            <h3 className="text-xl text-blue-800 dark:text-white font-bold mb-4">
                                {companyInfo.title}
                            </h3>
                            {companyInfo.description && (
                                <div
                                    className="text-gray-600 dark:text-gray-400 mb-4 leading-relaxed"
                                    dangerouslySetInnerHTML={{ __html: companyInfo.description }}
                                />
                            )}
                        </div>

                        {/* Academic Writing Services */}
                        {serviceLinks.length > 0 && (
                            <div>
                                <h3 className="text-lg text-blue-700 dark:text-white font-semibold mb-4">
                                    Academic Writing Services
                                </h3>
                                <ul className="space-y-2">
                                    {serviceLinks.map((link, index) => (
                                        <li key={index}>
                                            <Link
                                                href={link.url}
                                                className="text-gray-600 hover:text-gray-900 dark:text-gray-400 dark:hover:text-white transition-colors"
                                            >
                                                {link.name}
                                            </Link>
                                        </li>
                                    ))}
                                </ul>
                            </div>
                        )}

                        {/* Quick Links */}
                        {quickLinks.length > 0 && (
                            <div>
                                <h3 className="text-lg text-blue-700 dark:text-white font-semibold mb-4">
                                    Quick Links
                                </h3>
                                <ul className="space-y-2">
                                    {quickLinks.map((link, index) => (
                                        <li key={index}>
                                            <Link
                                                href={link.url}
                                                className="text-gray-600 hover:text-gray-900 dark:text-gray-400 dark:hover:text-white transition-colors"
                                            >
                                                {link.name}
                                            </Link>
                                        </li>
                                    ))}
                                </ul>
                            </div>
                        )}

                        {/* Contact Information */}
                        {contactInfo && (contactInfo.email || contactInfo.phone || contactInfo.address) && (
                            <div>
                                <h3 className="text-lg text-blue-700 dark:text-white font-semibold mb-4">
                                    Contact Information
                                </h3>
                                <ul className="space-y-3">
                                    {contactInfo.email && (
                                        <li className="flex items-start">
                                            <Mail className="h-5 w-5 text-blue-500 mr-2 mt-1 flex-shrink-0" />
                                            <div>
                                                <a
                                                    href={`mailto:${contactInfo.email}`}
                                                    className="text-gray-600 dark:text-gray-400 hover:text-blue-600 dark:hover:text-blue-400 transition-colors"
                                                >
                                                    {contactInfo.email}
                                                </a>
                                            </div>
                                        </li>
                                    )}
                                    {contactInfo.phone && (
                                        <li className="flex items-start">
                                            <Phone className="h-5 w-5 text-blue-500 mr-2 mt-1 flex-shrink-0" />
                                            <div>
                                                <a
                                                    href={`tel:${contactInfo.phone.replace(/[^0-9+]/g, '')}`}
                                                    className="text-gray-600 dark:text-gray-400 hover:text-blue-600 dark:hover:text-blue-400 transition-colors"
                                                >
                                                    {contactInfo.phone}
                                                </a>
                                                {contactInfo.phone_description && (
                                                    <p className="text-xs text-gray-500 dark:text-gray-500">
                                                        {contactInfo.phone_description}
                                                    </p>
                                                )}
                                            </div>
                                        </li>
                                    )}
                                    {contactInfo.address && Object.keys(contactInfo.address).length > 0 && (
                                        <li className="flex items-start">
                                            <MapPin className="h-5 w-5 text-blue-500 mr-2 mt-1 flex-shrink-0" />
                                            <div className="text-gray-600 dark:text-gray-400">
                                                <address className="not-italic">
                                                    {contactInfo.address.line1 && (
                                                        <>
                                                            {contactInfo.address.line1}
                                                            <br />
                                                        </>
                                                    )}
                                                    {contactInfo.address.line2 && (
                                                        <>
                                                            {contactInfo.address.line2}
                                                            <br />
                                                        </>
                                                    )}
                                                    {contactInfo.address.line3 && contactInfo.address.line3}
                                                </address>
                                            </div>
                                        </li>
                                    )}
                                </ul>
                            </div>
                        )}
                    </div>

                    {/* Bottom Footer */}
                    <div className="py-6 border-t border-gray-200 dark:border-gray-700 text-sm">
                        <div className="md:flex md:items-center md:justify-between">
                            <div className="text-gray-600 dark:text-gray-400 mb-4 md:mb-0">
                                © {currentYear} {copyrightText}
                            </div>
                            {legalLinks.length > 0 && (
                                <div className="flex flex-wrap gap-4">
                                    {legalLinks.map((link, index) => (
                                        link.external ? (
                                            <a
                                                key={index}
                                                href={link.url}
                                                target="_blank"
                                                rel="noopener noreferrer"
                                                className="text-gray-600 hover:text-gray-900 dark:text-gray-400 dark:hover:text-white transition-colors"
                                                title={link.name}
                                            >
                                                {link.name}
                                            </a>
                                        ) : (
                                            <Link
                                                key={index}
                                                href={link.url}
                                                className="text-gray-600 hover:text-gray-900 dark:text-gray-400 dark:hover:text-white transition-colors"
                                            >
                                                {link.name}
                                            </Link>
                                        )
                                    ))}
                                </div>
                            )}
                        </div>
                    </div>
                </div>
            </footer>
        </>
    );
}
