import React from 'react';

export default function GuaranteeComparison({ title, description, features, ctaText, ctaLink }) {
    if (!features || features.length === 0) return null;

    const checkIcon = (
        <svg className="w-6 h-6 text-green-500 mx-auto" fill="currentColor" viewBox="0 0 20 20">
            <path fillRule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clipRule="evenodd" />
        </svg>
    );

    const xIcon = (
        <svg className="w-6 h-6 text-red-500 mx-auto" fill="currentColor" viewBox="0 0 20 20">
            <path fillRule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clipRule="evenodd" />
        </svg>
    );

    return (
        <section className="py-16 bg-white">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                {title && (
                    <div className="text-center mb-12">
                        <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
                            {title}
                        </h2>
                        {description && (
                            <div 
                                className="text-xl text-gray-600 content-area"
                                dangerouslySetInnerHTML={{ __html: description }}
                            />
                        )}
                    </div>
                )}

                <div className="overflow-x-auto">
                    <table className="w-full bg-white rounded-lg shadow-lg overflow-hidden">
                        <thead className="bg-green-600 text-white">
                            <tr>
                                <th className="px-6 py-4 text-left font-semibold">Guarantee Feature</th>
                                <th className="px-6 py-4 text-center font-semibold">Academic Scribe</th>
                                <th className="px-6 py-4 text-center font-semibold">Competitor A</th>
                                <th className="px-6 py-4 text-center font-semibold">Competitor B</th>
                            </tr>
                        </thead>
                        <tbody className="divide-y divide-gray-200">
                            {features.map((feature, index) => (
                                <tr key={index} className="hover:bg-gray-50">
                                    <td className="px-6 py-4 font-medium text-gray-900">{feature.name}</td>
                                    <td className="px-6 py-4 text-center">
                                        {feature.us === 'check' ? checkIcon : 
                                         feature.us === 'x' ? xIcon :
                                         <span className="text-yellow-600 text-sm">{feature.us}</span>}
                                    </td>
                                    <td className="px-6 py-4 text-center">
                                        {feature.compA === 'check' ? checkIcon :
                                         feature.compA === 'x' ? xIcon :
                                         <span className="text-yellow-600 text-sm">{feature.compA}</span>}
                                    </td>
                                    <td className="px-6 py-4 text-center">
                                        {feature.compB === 'check' ? checkIcon :
                                         feature.compB === 'x' ? xIcon :
                                         <span className="text-yellow-600 text-sm">{feature.compB}</span>}
                                    </td>
                                </tr>
                            ))}
                        </tbody>
                    </table>
                </div>

                {ctaText && ctaLink && (
                    <div className="text-center mt-8">
                        <a
                            href={ctaLink}
                            className="bg-green-600 hover:bg-green-700 text-white px-8 py-4 rounded-lg font-bold text-lg transition-colors inline-block"
                        >
                            {ctaText}
                        </a>
                    </div>
                )}
            </div>
        </section>
    );
}





