import React from 'react';

export default function GuaranteeProcess({ title, description, steps }) {
    if (!steps || steps.length === 0) return null;

    return (
        <section className="py-16 bg-gray-50">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                {title && (
                    <div className="text-center mb-12">
                        <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
                            {title}
                        </h2>
                        {description && (
                            <div 
                                className="text-xl text-gray-600 content-area"
                                dangerouslySetInnerHTML={{ __html: description }}
                            />
                        )}
                    </div>
                )}

                <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
                    {steps.map((step, index) => (
                        <div key={index} className="text-center">
                            <div className="bg-green-100 rounded-full w-20 h-20 flex items-center justify-center mx-auto mb-6">
                                <span className="text-2xl font-bold text-green-600">
                                    {step.number || index + 1}
                                </span>
                            </div>
                            <h3 className="text-xl font-bold text-gray-900 mb-4">
                                {step.title}
                            </h3>
                            <div 
                                className="text-gray-600 mb-4 content-area"
                                dangerouslySetInnerHTML={{ __html: step.description }}
                            />
                            {step.link && step.linkText && (
                                <a
                                    href={step.link}
                                    className="text-green-600 hover:text-green-800 font-semibold"
                                >
                                    {step.linkText} →
                                </a>
                            )}
                        </div>
                    ))}
                </div>
            </div>
        </section>
    );
}





