import React from 'react';

export default function ServiceGuarantees({ title, description, services }) {
    if (!services || services.length === 0) return null;

    const colorSchemes = {
        0: { bg: 'bg-blue-50', border: 'border-blue-500', text: 'text-blue-600', hover: 'hover:text-blue-600' },
        1: { bg: 'bg-purple-50', border: 'border-purple-500', text: 'text-purple-600', hover: 'hover:text-purple-600' },
        2: { bg: 'bg-green-50', border: 'border-green-500', text: 'text-green-600', hover: 'hover:text-green-600' },
        3: { bg: 'bg-yellow-50', border: 'border-yellow-500', text: 'text-yellow-600', hover: 'hover:text-yellow-600' },
        4: { bg: 'bg-red-50', border: 'border-red-500', text: 'text-red-600', hover: 'hover:text-red-600' },
        5: { bg: 'bg-indigo-50', border: 'border-indigo-500', text: 'text-indigo-600', hover: 'hover:text-indigo-600' },
        6: { bg: 'bg-pink-50', border: 'border-pink-500', text: 'text-pink-600', hover: 'hover:text-pink-600' },
    };

    return (
        <section className="py-16 bg-white">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                {title && (
                    <div className="text-center mb-12">
                        <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
                            {title}
                        </h2>
                        {description && (
                            <div 
                                className="text-xl text-gray-600 content-area"
                                dangerouslySetInnerHTML={{ __html: description }}
                            />
                        )}
                    </div>
                )}

                <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    {services.map((service, index) => {
                        const colors = colorSchemes[index % 7];
                        return (
                            <div 
                                key={index} 
                                className={`${colors.bg} rounded-lg p-6 border-l-4 ${colors.border}`}
                            >
                                <h3 className="text-xl font-bold text-gray-900 mb-3">
                                    <a
                                        href={service.link}
                                        className={`${colors.hover} transition-colors`}
                                    >
                                        {service.title}
                                    </a>
                                </h3>
                                <ul className="text-gray-600 space-y-2 mb-4">
                                    {service.features && service.features.map((feature, idx) => (
                                        <li key={idx}>• {feature}</li>
                                    ))}
                                </ul>
                                {service.link && service.linkText && (
                                    <a
                                        href={service.link}
                                        className={`${colors.text} hover:${colors.text.replace('text-', 'text-')}-800 font-semibold text-sm`}
                                    >
                                        {service.linkText} →
                                    </a>
                                )}
                            </div>
                        );
                    })}
                </div>
            </div>
        </section>
    );
}





