import React from 'react';

export default function ServiceLinksFooter({ title, description, services }) {
    if (!services || services.length === 0) return null;

    return (
        <section className="py-12 bg-white border-t border-gray-200">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                {title && (
                    <div className="text-center mb-8">
                        <h3 className="text-2xl font-bold text-gray-900 mb-4">
                            {title}
                        </h3>
                        {description && (
                            <div 
                                className="text-gray-600 content-area"
                                dangerouslySetInnerHTML={{ __html: description }}
                            />
                        )}
                    </div>
                )}

                <div className="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-7 gap-4">
                    {services.map((service, index) => (
                        <a
                            key={index}
                            href={service.link}
                            className="text-center p-4 rounded-lg border border-gray-200 hover:border-green-500 hover:shadow-md transition-all group"
                        >
                            <div className="text-2xl mb-2">{service.icon}</div>
                            <div className="text-sm font-semibold text-gray-900 group-hover:text-green-600">
                                {service.name}
                            </div>
                        </a>
                    ))}
                </div>
            </div>
        </section>
    );
}





