import React from "react";
import OptimizedImage from "./OptimizedImage";
import PropTypes from "prop-types";

const HeroImage = ({
    imageData,
    alt = "",
    className = "",
    overlayClassName = "",
    children = null,
    ...props
}) => {
    const defaultSizes =
        "(max-width: 768px) 100vw, (max-width: 1200px) 100vw, 1200px";

    return (
        <div className={`relative ${className}`}>
            <OptimizedImage
                imageData={imageData}
                alt={alt}
                className="w-full h-full object-cover"
                priority={true} // Hero images should load immediately
                sizes={defaultSizes}
                {...props}
            />

            {/* Optional overlay */}
            {overlayClassName && (
                <div className={`absolute inset-0 ${overlayClassName}`} />
            )}

            {/* Optional content overlay */}
            {children && (
                <div className="absolute inset-0 flex items-center justify-center">
                    {children}
                </div>
            )}
        </div>
    );
};

HeroImage.propTypes = {
    imageData: PropTypes.oneOfType([PropTypes.string, PropTypes.object])
        .isRequired,
    alt: PropTypes.string,
    className: PropTypes.string,
    overlayClassName: PropTypes.string,
    children: PropTypes.node,
};

export default HeroImage;
