import { Clock } from "lucide-react";
import { useState, useEffect } from "react";

export default function OrderPostedTime({ postedDate, className = "" }) {
    const [timeAgo, setTimeAgo] = useState("");

    useEffect(() => {
        const calculateTimeAgo = () => {
            const userTimezone =
                Intl.DateTimeFormat().resolvedOptions().timeZone;
            const now = new Date();

            // Convert posted date to local timezone
            const posted = new Date(postedDate);
            const localPosted = new Date(
                posted.toLocaleString("en-US", { timeZone: userTimezone })
            );

            const diff = now - localPosted;

            const minutes = Math.floor(diff / (1000 * 60));
            const hours = Math.floor(diff / (1000 * 60 * 60));
            const days = Math.floor(diff / (1000 * 60 * 60 * 24));
            const months = Math.floor(days / 30);
            const years = Math.floor(days / 365);

            if (years > 0) {
                setTimeAgo(`${years} year${years > 1 ? "s" : ""} ago`);
            } else if (months > 0) {
                setTimeAgo(`${months} month${months > 1 ? "s" : ""} ago`);
            } else if (days > 0) {
                setTimeAgo(`${days} day${days > 1 ? "s" : ""} ago`);
            } else if (hours > 0) {
                setTimeAgo(`${hours} hour${hours > 1 ? "s" : ""} ago`);
            } else {
                setTimeAgo(`${minutes} minute${minutes > 1 ? "s" : ""} ago`);
            }
        };

        calculateTimeAgo();
        const timer = setInterval(calculateTimeAgo, 60000); // Updates every minute

        return () => clearInterval(timer);
    }, [postedDate]);

    return (
        <div className="flex items-center">
            <Clock className="w-4 h-4 mr-1 text-gray-100 dark:text-gray-100" />
            <span className={` dark:text-gray-300 ${className}`}>
                {timeAgo}
            </span>
        </div>
    );
}
