import { Link } from "@inertiajs/react";
import { ChevronLeft, ChevronRight } from "lucide-react";

export default function Pagination({ links }) {
    if (links.length <= 1) return null;

    // Filter out Laravel's default prev/next links
    const pageLinks = links.slice(1, -1);

    return (
        <div className="flex mt-6 justify-center items-center flex-wrap gap-2">
            {/* Previous Button */}
            {links[0].url && (
                <Link
                    href={links[0].url}
                    className="px-3 py-2 flex items-center gap-1 rounded-md border bg-gray-200 text-gray-700 hover:bg-gray-300 dark:bg-gray-700 dark:text-white dark:hover:bg-gray-600 transition"
                >
                    <ChevronLeft className="w-4 h-4" />
                    <span>Previous</span>
                </Link>
            )}

            {/* Page Numbers */}
            {pageLinks.map((link, index) =>
                link.url ? (
                    <Link
                        key={index}
                        href={link.url}
                        dangerouslySetInnerHTML={{ __html: link.label }}
                        className={`px-3 py-2 rounded-md transition-all duration-200 ${
                            link.active
                                ? "bg-blue-600 text-white shadow-md"
                                : "text-gray-600 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-700"
                        }`}
                    />
                ) : (
                    <span
                        key={index}
                        dangerouslySetInnerHTML={{ __html: link.label }}
                        className="px-3 py-2 text-gray-400"
                    />
                )
            )}

            {/* Next Button */}
            {links[links.length - 1].url && (
                <Link
                    href={links[links.length - 1].url}
                    className="px-3 py-2 flex items-center gap-1 rounded-md border bg-gray-200 text-gray-700 hover:bg-gray-300 dark:bg-gray-700 dark:text-white dark:hover:bg-gray-600 transition"
                >
                    <span>Next</span>
                    <ChevronRight className="w-4 h-4" />
                </Link>
            )}
        </div>
    );
}
