import React from 'react';

export default function PricingKeywords({ content }) {
    if (!content || !content[0]) return null;
    
    const data = content[0].content;
    
    return (
        <section className="py-16 bg-white dark:bg-gray-900">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                <div className="text-center mb-12">
                    <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                        {data.title}
                    </h2>
                    <p className="text-xl text-gray-600 dark:text-gray-300 mb-8">
                        {data.description}
                    </p>
                </div>

                <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    {data.categories && data.categories.map((category, index) => (
                        <div key={index} className="bg-gray-50 dark:bg-gray-800 rounded-lg p-6">
                            <h3 className="text-xl font-semibold text-gray-900 dark:text-white mb-3">
                                <a
                                    href={category.link}
                                    className="hover:text-blue-600 dark:hover:text-blue-400 transition-colors"
                                >
                                    {category.title}
                                </a>
                            </h3>
                            <ul className="text-gray-600 dark:text-gray-300 space-y-2">
                                {category.items && category.items.map((item, itemIndex) => (
                                    <li key={itemIndex}>
                                        •{" "}
                                        <a
                                            href={item.link}
                                            className="hover:text-blue-600 dark:hover:text-blue-400 transition-colors"
                                        >
                                            {item.text}
                                        </a>
                                    </li>
                                ))}
                            </ul>
                        </div>
                    ))}
                </div>

                <div className="mt-12 text-center">
                    <div className="bg-blue-50 dark:bg-blue-900/20 rounded-lg p-8 max-w-4xl mx-auto">
                        <h3 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">
                            {data.bottomSection.title}
                        </h3>
                        <div className="grid grid-cols-1 md:grid-cols-2 gap-6 text-left">
                            <div>
                                <h4 className="font-semibold text-gray-900 dark:text-white mb-2">
                                    {data.bottomSection.leftColumn.title}
                                </h4>
                                <p className="text-gray-600 dark:text-gray-300 mb-2">
                                    {data.bottomSection.leftColumn.description}
                                </p>
                                <a
                                    href={data.bottomSection.leftColumn.link}
                                    className="text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-300 font-semibold text-sm"
                                >
                                    {data.bottomSection.leftColumn.linkText} →
                                </a>
                            </div>
                            <div>
                                <h4 className="font-semibold text-gray-900 dark:text-white mb-2">
                                    {data.bottomSection.rightColumn.title}
                                </h4>
                                <p className="text-gray-600 dark:text-gray-300 mb-2">
                                    {data.bottomSection.rightColumn.description}
                                </p>
                                <a
                                    href={data.bottomSection.rightColumn.link}
                                    className="text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-300 font-semibold text-sm"
                                >
                                    {data.bottomSection.rightColumn.linkText} →
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    );
}



