import React from 'react';

export default function PricingSecurity({ content }) {
    if (!content || !content[0]) return null;
    
    const data = content[0].content;
    
    return (
        <section className="py-16 bg-white dark:bg-gray-900">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                <div className="text-center mb-12">
                    <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                        {data.title}
                    </h2>
                    <p className="text-xl text-gray-600 dark:text-gray-300">
                        {data.description}
                    </p>
                </div>

                <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                    {data.securityFeatures && data.securityFeatures.map((feature, index) => (
                        <div key={index} className="text-center">
                            <div className={`${feature.iconBgColor} rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-4`}>
                                <svg
                                    className={`w-8 h-8 ${feature.iconColor}`}
                                    fill="currentColor"
                                    viewBox="0 0 20 20"
                                >
                                    <path
                                        fillRule="evenodd"
                                        d={feature.iconPath}
                                        clipRule="evenodd"
                                    />
                                </svg>
                            </div>
                            <h3 className="text-lg font-semibold text-gray-900 dark:text-white mb-2">
                                {feature.title}
                            </h3>
                            <p className="text-gray-600 dark:text-gray-300 text-sm">
                                {feature.description}
                            </p>
                        </div>
                    ))}
                </div>

                {/* Payment Methods */}
                <div className="mt-12 text-center">
                    <h3 className="text-lg font-semibold text-gray-900 dark:text-white mb-6">
                        {data.paymentMethods.title}
                    </h3>
                    <div className="flex flex-wrap justify-center items-center gap-6 opacity-60">
                        {data.paymentMethods.methods && data.paymentMethods.methods.map((method, index) => (
                            <div key={index} className="bg-white dark:bg-gray-800 rounded-lg p-3 shadow-sm">
                                <span className={`${method.color} font-bold text-lg`}>
                                    {method.name}
                                </span>
                            </div>
                        ))}
                    </div>
                </div>
            </div>
        </section>
    );
}



