import React from 'react';

export default function ServicePricingGrid({ content }) {
    if (!content || !content[0]) return null;
    
    const data = content[0].content;
    
    return (
        <section className="py-16 bg-white dark:bg-gray-900">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                <div className="text-center mb-12">
                    <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                        {data.title}
                    </h2>
                    <p className="text-xl text-gray-600 dark:text-gray-300">
                        {data.description}
                    </p>
                </div>

                <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    {data.services && data.services.map((service, index) => (
                        <div
                            key={index}
                            className="bg-gray-50 dark:bg-gray-800 rounded-lg shadow-sm p-6 hover:shadow-md transition-shadow border-l-4 border-blue-600"
                        >
                            <div className="flex justify-between items-start mb-3">
                                <h3 className="text-xl font-semibold text-gray-900 dark:text-white">
                                    {service.name}
                                </h3>
                                <span className="text-lg font-bold text-blue-600">
                                    {service.price}
                                </span>
                            </div>
                            <p className="text-gray-600 dark:text-gray-300 mb-4">
                                {service.description}
                            </p>
                            <div className="flex space-x-2">
                                <a
                                    href={service.learnMoreLink}
                                    className="flex-1 bg-blue-600 hover:bg-blue-700 text-white py-2 px-4 rounded-lg font-semibold transition-colors text-center text-sm"
                                >
                                    Learn More
                                </a>
                                <a
                                    href={service.orderLink}
                                    className="flex-1 border-2 border-blue-600 text-blue-600 hover:bg-blue-600 hover:text-white py-2 px-4 rounded-lg font-semibold transition-colors text-center text-sm"
                                >
                                    Order Now
                                </a>
                            </div>
                        </div>
                    ))}
                </div>

                <div className="text-center mt-8">
                    <a
                        href={data.viewAllServicesLink}
                        className="bg-blue-600 hover:bg-blue-700 text-white px-8 py-4 rounded-lg font-bold text-lg transition-colors inline-block"
                    >
                        {data.viewAllServicesText}
                    </a>
                </div>
            </div>
        </section>
    );
}



