import React from 'react';

export default function FeaturedTestimonials({ title, description, testimonials }) {
    if (!testimonials || testimonials.length === 0) return null;

    const renderStars = (rating) => {
        return [...Array(5)].map((_, index) => (
            <svg
                key={index}
                className={`w-5 h-5 ${
                    index < rating ? "text-yellow-400" : "text-gray-300"
                }`}
                fill="currentColor"
                viewBox="0 0 20 20"
            >
                <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
            </svg>
        ));
    };

    return (
        <section className="py-16 bg-gray-50">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                {title && (
                    <div className="text-center mb-12">
                        <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
                            {title}
                        </h2>
                        {description && (
                            <div 
                                className="text-xl text-gray-600 content-area"
                                dangerouslySetInnerHTML={{ __html: description }}
                            />
                        )}
                    </div>
                )}

                <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
                    {testimonials.map((testimonial, index) => (
                        <div
                            key={index}
                            className="bg-white rounded-lg shadow-lg p-8"
                        >
                            <div className="flex items-center mb-4">
                                <div className="flex mr-2">
                                    {renderStars(testimonial.rating)}
                                </div>
                                <span className="text-sm text-gray-600 ml-2">
                                    Verified Review
                                </span>
                            </div>
                            <blockquote className="text-gray-700 mb-6 italic">
                                "{testimonial.quote}"
                            </blockquote>
                            <div className="flex items-center justify-between">
                                <div>
                                    <div className="font-semibold text-gray-900">
                                        {testimonial.name}
                                    </div>
                                    <div className="text-sm text-gray-600">
                                        {testimonial.course}
                                    </div>
                                    <div className="text-sm text-gray-500">
                                        {testimonial.university}
                                    </div>
                                </div>
                                {testimonial.serviceSlug && (
                                    <a
                                        href={`/services/${testimonial.serviceSlug}`}
                                        className="text-blue-600 hover:text-blue-800 font-semibold text-sm"
                                    >
                                        Try {testimonial.service} →
                                    </a>
                                )}
                            </div>
                        </div>
                    ))}
                </div>
            </div>
        </section>
    );
}




