import React from 'react';

export default function ReviewHero({ hero, stats }) {
    if (!hero) return null;

    return (
        <section className="bg-gradient-to-r from-blue-600 to-purple-600 text-white py-16">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                <div className="text-center">
                    <h1 className="text-4xl md:text-5xl font-bold mb-6">
                        {hero.title}
                    </h1>
                    <div 
                        className="text-xl md:text-2xl mb-8 max-w-3xl mx-auto content-area"
                        dangerouslySetInnerHTML={{ __html: hero.description }}
                    />

                    {/* Review Stats */}
                    {stats && stats.length > 0 && (
                        <div className="grid grid-cols-2 md:grid-cols-4 gap-6 max-w-4xl mx-auto">
                            {stats.map((stat, index) => (
                                <div key={index} className="text-center">
                                    <div className="text-3xl font-bold mb-2">
                                        {stat.value}
                                    </div>
                                    <div className="text-blue-100">
                                        {stat.label}
                                    </div>
                                </div>
                            ))}
                        </div>
                    )}
                </div>
            </div>
        </section>
    );
}




