import React from "react";

export default function RichSection({ title, description }) {
  // Basic renderer that preserves paragraphs, lists, and simple formatting
  // description is plain text/markdown-like content
  const lines = (description || "").split(/\n/);
  const paragraphs = [];
  let list = [];

  const flushList = () => {
    if (list.length > 0) {
      paragraphs.push(
        <ul className="list-disc pl-6 space-y-1" key={`ul-${paragraphs.length}`}>
          {list.map((item, idx) => (
            <li key={idx}>{item}</li>
          ))}
        </ul>
      );
      list = [];
    }
  };

  lines.forEach((line, idx) => {
    const trimmed = line.trim();
    if (trimmed.startsWith("- ")) {
      list.push(trimmed.slice(2));
      return;
    }
    if (trimmed === "") {
      flushList();
      paragraphs.push(<div className="h-2" key={`sp-${idx}`} />);
      return;
    }
    flushList();
    paragraphs.push(
      <p className="leading-7 text-gray-700" key={`p-${idx}`}>{trimmed}</p>
    );
  });
  flushList();

  return (
    <section className="py-8">
      <div className="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
        {title && (
          <h2 className="text-2xl font-bold text-gray-900 mb-4">{title}</h2>
        )}
        <div className="space-y-3">
          {paragraphs}
        </div>
      </div>
    </section>
  );
}


