import OptimizedImage from "./OptimizedImage";

/**
 * ServiceImage Component - Specifically for service page images
 */
const ServiceImage = ({
    service,
    alt,
    className = "w-full h-64 object-cover rounded-lg shadow-lg",
    ...props
}) => {
    // Map service names to image paths
    const serviceImages = {
        "research-papers": "/images/research-paper-benefits.jpg",
        "dissertation-writing": "/images/dissertation-writing-benefits.jpg",
        "essay-writing": "/images/essay-writing-benefits.jpg",
        assignments: "/images/assignment-writing-benefits.jpg",
        "case-studies": "/images/case-study-writing-benefits.jpg",
        "literature-reviews": "/images/literature-review-benefits.jpg",
        "thesis-proposals": "/images/thesis-statement-writing-benefits.jpg",
        "programming-assignments": "/images/programming-assignment-benefits.jpg",
    };

    const imageSrc =
        serviceImages[service] || "/images/academic-writing-pricing.jpg";

    return (
        <OptimizedImage
            src={imageSrc}
            alt={alt || `${service.replace("-", " ")} service benefits`}
            className={className}
            sizes="(max-width: 768px) 100vw, (max-width: 1024px) 50vw, 800px"
            {...props}
        />
    );
};

export default ServiceImage;
