import React from "react";

export default function SimpleBarChart({
    data,
    maxValue,
    height = 100,
    barColor = "bg-indigo-500",
}) {
    // If no data or maxValue is 0, show empty state
    if (!data || !data.length || maxValue === 0) {
        return (
            <div className="flex justify-center items-center h-24 bg-gray-50 dark:bg-gray-800 rounded-md">
                <p className="text-sm text-gray-500 dark:text-gray-400">
                    No data available
                </p>
            </div>
        );
    }

    return (
        <div className="flex items-end h-[100px] gap-1">
            {data.map((item, index) => {
                // Calculate height as a percentage of maxValue
                const barHeight = (item.value / maxValue) * height;
                // Ensure bars have at least a minimum height for visibility
                const displayHeight = Math.max(barHeight, 4);

                return (
                    <div
                        key={index}
                        className="flex flex-col items-center flex-1"
                    >
                        <div
                            className={`w-full ${barColor} dark:opacity-80 rounded-t-sm transition-all duration-300`}
                            style={{ height: `${displayHeight}%` }}
                            title={`${item.label}: ${item.value}`}
                        ></div>
                        <div className="text-xs text-gray-500 dark:text-gray-400 mt-1 truncate w-full text-center">
                            {item.label}
                        </div>
                    </div>
                );
            })}
        </div>
    );
}
