const StatCard = ({ title, value, className = "" }) => {
    return (
        <div
            className={`bg-gradient-to-br rounded-xl p-6 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 ${className}`}
        >
            <div className="flex flex-col items-center justify-center text-center">
                <span className="text-white text-sm uppercase font-semibold mb-3 tracking-wide">
                    {title}
                </span>
                <span className="text-white text-2xl font-bold">{value}</span>
            </div>
        </div>
    );
};

export default StatCard;
