import React from 'react';

export default function FeaturedWriters({ title, description, writers }) {
    if (!writers || writers.length === 0) return null;

    const renderStars = (rating) => {
        return [...Array(5)].map((_, index) => (
            <svg
                key={index}
                className={`w-4 h-4 ${
                    index < Math.floor(rating) ? "text-yellow-400" : "text-gray-300 dark:text-gray-600"
                }`}
                fill="currentColor"
                viewBox="0 0 20 20"
            >
                <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
            </svg>
        ));
    };

    return (
        <section className="py-16 bg-white dark:bg-gray-900">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                {title && (
                    <div className="text-center mb-12">
                        <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                            {title}
                        </h2>
                        {description && (
                            <div 
                                className="text-xl text-gray-600 dark:text-gray-300 content-area"
                                dangerouslySetInnerHTML={{ __html: description }}
                            />
                        )}
                    </div>
                )}

                <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
                    {writers.map((writer, index) => (
                        <div
                            key={writer.id || index}
                            className="bg-gray-50 dark:bg-gray-800 rounded-lg shadow-lg p-6 hover:shadow-xl transition-all"
                        >
                            {/* Writer Header */}
                            <div className="text-center mb-6">
                                <div className="w-24 h-24 bg-blue-100 dark:bg-blue-900 rounded-full flex items-center justify-center mx-auto mb-4">
                                    <span className="text-3xl font-bold text-blue-600 dark:text-blue-300">
                                        {writer.name.split(' ').map(n => n[0]).join('')}
                                    </span>
                                </div>
                                <h3 className="text-xl font-bold text-gray-900 dark:text-white mb-1">
                                    {writer.name}
                                </h3>
                                <p className="text-blue-600 dark:text-blue-400 font-medium mb-2">
                                    {writer.title}
                                </p>
                                <div className="flex items-center justify-center mb-2">
                                    {renderStars(writer.rating)}
                                    <span className="ml-2 text-gray-600 dark:text-gray-400 text-sm">
                                        {writer.rating}/5
                                    </span>
                                </div>
                                {writer.availability && (
                                    <span className="inline-block bg-green-100 dark:bg-green-900 text-green-800 dark:text-green-300 text-xs px-3 py-1 rounded-full">
                                        {writer.availability}
                                    </span>
                                )}
                            </div>

                            {/* Writer Details */}
                            <div className="space-y-4">
                                <div>
                                    <p className="text-sm text-gray-600 dark:text-gray-400 mb-1">
                                        <strong>Specialization:</strong>
                                    </p>
                                    <p className="text-gray-900 dark:text-white text-sm">
                                        {writer.specialization}
                                    </p>
                                </div>

                                <div>
                                    <p className="text-sm text-gray-600 dark:text-gray-400 mb-1">
                                        <strong>Experience:</strong>
                                    </p>
                                    <p className="text-gray-900 dark:text-white text-sm">
                                        {writer.experience}
                                    </p>
                                </div>

                                <div>
                                    <p className="text-sm text-gray-600 dark:text-gray-400 mb-1">
                                        <strong>Completed Orders:</strong>
                                    </p>
                                    <p className="text-gray-900 dark:text-white text-sm">
                                        {writer.completedOrders?.toLocaleString()}
                                    </p>
                                </div>

                                {writer.expertise && writer.expertise.length > 0 && (
                                    <div>
                                        <p className="text-sm text-gray-600 dark:text-gray-400 mb-2">
                                            <strong>Expertise:</strong>
                                        </p>
                                        <div className="flex flex-wrap gap-2">
                                            {writer.expertise.map((skill, idx) => (
                                                <span
                                                    key={idx}
                                                    className="bg-blue-50 dark:bg-blue-900/30 text-blue-700 dark:text-blue-300 px-2 py-1 rounded text-xs"
                                                >
                                                    {skill}
                                                </span>
                                            ))}
                                        </div>
                                    </div>
                                )}

                                {writer.education && (
                                    <div>
                                        <p className="text-sm text-gray-600 dark:text-gray-400 mb-1">
                                            <strong>Education:</strong>
                                        </p>
                                        <p className="text-gray-900 dark:text-white text-sm">
                                            {writer.education}
                                        </p>
                                    </div>
                                )}

                                {writer.description && (
                                    <div 
                                        className="text-sm text-gray-600 dark:text-gray-300 content-area"
                                        dangerouslySetInnerHTML={{ __html: writer.description }}
                                    />
                                )}

                                {writer.languages && writer.languages.length > 0 && (
                                    <div>
                                        <p className="text-sm text-gray-600 dark:text-gray-400 mb-1">
                                            <strong>Languages:</strong>
                                        </p>
                                        <p className="text-gray-900 dark:text-white text-sm">
                                            {writer.languages.join(', ')}
                                        </p>
                                    </div>
                                )}
                            </div>
                        </div>
                    ))}
                </div>
            </div>
        </section>
    );
}




