import React, { useState } from 'react';

export default function SelectionProcess({ title, description, processes }) {
    const [activeTab, setActiveTab] = useState(processes && processes.length > 0 ? processes[0].id : '');
    
    if (!processes || processes.length === 0) return null;

    return (
        <section className="py-16 bg-white dark:bg-gray-900">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                {title && (
                    <div className="text-center mb-12">
                        <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                            {title}
                        </h2>
                        {description && (
                            <div 
                                className="text-xl text-gray-600 dark:text-gray-300 max-w-3xl mx-auto content-area"
                                dangerouslySetInnerHTML={{ __html: description }}
                            />
                        )}
                    </div>
                )}

                {/* Tab Buttons */}
                <div className="flex flex-wrap justify-center gap-4 mb-12">
                    {processes.map((process) => (
                        <button
                            key={process.id}
                            onClick={() => setActiveTab(process.id)}
                            className={`px-6 py-3 rounded-lg font-semibold transition-all ${
                                activeTab === process.id
                                    ? "bg-blue-600 text-white shadow-lg dark:bg-blue-700"
                                    : "bg-gray-100 text-gray-700 hover:bg-gray-200 dark:bg-gray-800 dark:text-gray-300 dark:hover:bg-gray-700"
                            }`}
                        >
                            <span className="text-xl mr-2">{process.icon}</span>
                            {process.title}
                        </button>
                    ))}
                </div>

                {/* Tab Content */}
                <div className="bg-gray-50 dark:bg-gray-800 rounded-lg shadow-lg p-8 md:p-12">
                    {processes.map((process) => (
                        <div
                            key={process.id}
                            className={activeTab === process.id ? "block" : "hidden"}
                        >
                            <div className="flex items-center justify-center mb-6">
                                <div className="text-6xl">{process.icon}</div>
                            </div>
                            <h3 className="text-2xl md:text-3xl font-bold text-gray-900 dark:text-white mb-2 text-center">
                                {process.title}
                            </h3>
                            {process.subtitle && (
                                <p className="text-lg text-gray-600 dark:text-gray-400 mb-6 text-center italic">
                                    {process.subtitle}
                                </p>
                            )}
                            <div 
                                className="text-lg text-gray-700 dark:text-gray-300 mb-8 leading-relaxed content-area"
                                dangerouslySetInnerHTML={{ __html: process.description }}
                            />

                            {process.details && process.details.length > 0 && (
                                <div className="grid md:grid-cols-2 gap-4">
                                    {process.details.map((detail, idx) => (
                                        <div key={idx} className="flex items-start">
                                            <svg
                                                className="w-6 h-6 text-green-500 dark:text-green-400 mr-3 mt-1 flex-shrink-0"
                                                fill="currentColor"
                                                viewBox="0 0 20 20"
                                            >
                                                <path
                                                    fillRule="evenodd"
                                                    d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z"
                                                    clipRule="evenodd"
                                                />
                                            </svg>
                                            <span className="text-gray-700 dark:text-gray-300">{detail}</span>
                                        </div>
                                    ))}
                                </div>
                            )}
                        </div>
                    ))}
                </div>
            </div>
        </section>
    );
}




