import React from "react";
import { cn } from "@/lib/utils";

const Switch = React.forwardRef(
    (
        {
            className,
            id,
            checked,
            defaultChecked,
            onChange,
            onCheckedChange, // Add this prop
            disabled,
            ...props
        },
        ref
    ) => {
        const [isChecked, setIsChecked] = React.useState(
            defaultChecked || false
        );

        React.useEffect(() => {
            if (checked !== undefined) {
                setIsChecked(checked);
            }
        }, [checked]);

        const handleChange = (e) => {
            const newChecked = e.target.checked;

            if (checked === undefined) {
                setIsChecked(newChecked);
            }

            if (onChange) {
                onChange(e);
            }

            // Call the onCheckedChange handler with the new checked value
            if (onCheckedChange) {
                onCheckedChange(newChecked);
            }
        };

        return (
            <div className="flex items-center">
                <input
                    ref={ref}
                    type="checkbox"
                    id={id}
                    role="switch"
                    checked={isChecked}
                    disabled={disabled}
                    onChange={handleChange}
                    className={cn("peer sr-only", className)}
                    {...props}
                />
                <label
                    htmlFor={id}
                    className={cn(
                        "relative inline-flex h-6 w-11 items-center rounded-full transition-colors",
                        "bg-gray-300 dark:bg-gray-600",
                        "peer-checked:bg-blue-600 peer-checked:dark:bg-blue-500",
                        "peer-disabled:cursor-not-allowed peer-disabled:opacity-50",
                        "cursor-pointer"
                    )}
                >
                    <span
                        className={cn(
                            "absolute mx-1 inline-block h-4 w-4 rounded-full transition-transform",
                            "bg-white dark:bg-gray-200",
                            "peer-checked:translate-x-5"
                        )}
                    />
                </label>
            </div>
        );
    }
);

Switch.displayName = "Switch";

export { Switch };
