import React from "react";
import { cn } from "@/lib/utils";

const Table = React.forwardRef(({ className, ...props }, ref) => {
    return (
        <table
            ref={ref}
            className={cn(
                "w-full caption-bottom text-sm border-collapse",
                className
            )}
            {...props}
        />
    );
});
Table.displayName = "Table";

const TableHeader = React.forwardRef(({ className, ...props }, ref) => {
    return (
        <thead
            ref={ref}
            className={cn("[&_tr]:border-b", className)}
            {...props}
        />
    );
});
TableHeader.displayName = "TableHeader";

const TableBody = React.forwardRef(({ className, ...props }, ref) => {
    return (
        <tbody
            ref={ref}
            className={cn("[&_tr:last-child]:border-0", className)}
            {...props}
        />
    );
});
TableBody.displayName = "TableBody";

const TableFooter = React.forwardRef(({ className, ...props }, ref) => {
    return (
        <tfoot
            ref={ref}
            className={cn("bg-gray-50 dark:bg-gray-800 font-medium", className)}
            {...props}
        />
    );
});
TableFooter.displayName = "TableFooter";

const TableRow = React.forwardRef(({ className, ...props }, ref) => {
    return (
        <tr
            ref={ref}
            className={cn(
                "border-b border-gray-200 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-800/50 transition-colors",
                className
            )}
            {...props}
        />
    );
});
TableRow.displayName = "TableRow";

const TableHead = React.forwardRef(({ className, ...props }, ref) => {
    return (
        <th
            ref={ref}
            className={cn(
                "h-12 px-4 text-left align-middle font-medium text-gray-500 dark:text-gray-400 [&:has([role=checkbox])]:pr-0",
                className
            )}
            {...props}
        />
    );
});
TableHead.displayName = "TableHead";

const TableCell = React.forwardRef(({ className, ...props }, ref) => {
    return (
        <td
            ref={ref}
            className={cn(
                "p-4 align-middle [&:has([role=checkbox])]:pr-0",
                className
            )}
            {...props}
        />
    );
});
TableCell.displayName = "TableCell";

const TableCaption = React.forwardRef(({ className, ...props }, ref) => {
    return (
        <caption
            ref={ref}
            className={cn(
                "mt-4 text-sm text-gray-500 dark:text-gray-400",
                className
            )}
            {...props}
        />
    );
});
TableCaption.displayName = "TableCaption";

Table.Header = TableHeader;
Table.Body = TableBody;
Table.Row = TableRow;
Table.Head = TableHead;
Table.Cell = TableCell;
Table.Footer = TableFooter;
Table.Caption = TableCaption;

export {
    Table,
    TableHeader,
    TableBody,
    TableFooter,
    TableHead,
    TableRow,
    TableCell,
    TableCaption,
};

export default Table;
