import AdminLayout from "@/Layouts/AdminLayout";
import { Link } from "@inertiajs/react";
import { Eye, Pencil, Trash2, Plus, X } from "lucide-react";
import { useState, useEffect } from "react";
import { usePage, router } from "@inertiajs/react";

export default function Index({ academicLevels }) {
    const [selectedLevel, setSelectedLevel] = useState(null);
    const { flash } = usePage().props;
    const [flashMsg, setFlashMsg] = useState(flash.message);

    useEffect(() => {
        if (flashMsg) {
            const timer = setTimeout(() => {
                setFlashMsg("");
            }, 3000);
            return () => clearTimeout(timer);
        }
    }, [flashMsg]);

    useEffect(() => {
        setFlashMsg(flash.message);
    }, [flash.message]);

    const handleDelete = (levelId) => {
        if (confirm("Are you sure you want to delete this academic level?")) {
            router.delete(route("academic-levels.destroy", levelId));
        }
    };

    return (
        <AdminLayout>
            <div className="space-y-6">
                <div className="flex flex-col md:flex-row md:justify-between md:items-center gap-4">
                    <h1 className="text-xl font-bold dark:text-white">
                        Academic Levels
                    </h1>
                    <Link
                        href={route("academic-levels.create")}
                        className="flex items-center gap-2 px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors"
                    >
                        <Plus className="h-4 w-4" />
                        <span>Add New</span>
                    </Link>
                </div>
                {flashMsg && (
                    <div
                        className="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative"
                        role="alert"
                    >
                        <span className="block sm:inline">{flashMsg}</span>
                    </div>
                )}

                {/* Desktop View */}
                <div className="hidden md:block">
                    <div className="bg-gradient-to-r from-orange-200 to-cyan-200 dark:bg-none dark:bg-gray-800 rounded-lg shadow">
                        <div className="grid grid-cols-12 gap-4 bg-gradient-to-r from-blue-900 to-cyan-500  p-4 font-semibold text-gray-100 dark:text-gray-300 rounded-t-lg">
                            <div className="col-span-1">ID</div>
                            <div className="col-span-4">Name</div>
                            <div className="col-span-5">Value</div>
                            <div className="col-span-2 text-right">Actions</div>
                        </div>

                        {academicLevels.map((level) => (
                            <div
                                key={level.id}
                                className="grid grid-cols-12 gap-4 p-4 items-center border-b dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-700"
                            >
                                <div className="col-span-1 dark:text-gray-300">
                                    {level.id}
                                </div>
                                <div className="col-span-4 dark:text-gray-300">
                                    {level.name}
                                </div>
                                <div className="col-span-5 dark:text-gray-300">
                                    ${level.value}
                                </div>
                                <div className="col-span-2 flex justify-end gap-2">
                                    <Link
                                        href={route(
                                            "academic-levels.edit",
                                            level.id
                                        )}
                                        className="p-2 text-amber-600 hover:bg-amber-100 rounded-full dark:text-amber-400 dark:hover:bg-amber-900"
                                    >
                                        <Pencil className="h-5 w-5" />
                                    </Link>
                                    <button
                                        onClick={() => handleDelete(level.id)}
                                        className="p-2 text-red-600 hover:bg-red-100 rounded-full dark:text-red-400 dark:hover:bg-red-900"
                                    >
                                        <Trash2 className="h-5 w-5" />
                                    </button>
                                </div>
                            </div>
                        ))}
                    </div>
                </div>

                {/* Mobile View */}
                <div className="md:hidden space-y-4">
                    {academicLevels.map((level) => (
                        <div
                            key={level.id}
                            className="bg-white dark:bg-gray-800 p-4 rounded-lg shadow space-y-3"
                        >
                            <div className="flex justify-between items-start">
                                <div>
                                    <h3 className="font-semibold text-lg dark:text-white">
                                        {level.name}
                                    </h3>
                                    <p className="text-gray-600 dark:text-gray-400">
                                        ${level.value}
                                    </p>
                                </div>
                                <span className="text-gray-500 dark:text-gray-400">
                                    #{level.id}
                                </span>
                            </div>
                            <div className="flex justify-end gap-2 pt-2 border-t dark:border-gray-700">
                                <Link
                                    href={route(
                                        "academic-levels.edit",
                                        level.id
                                    )}
                                    className="p-2 text-blue-600 hover:bg-blue-100 rounded-full dark:text-blue-400 dark:hover:bg-blue-900"
                                >
                                    <Pencil className="h-5 w-5" />
                                </Link>

                                <button
                                    onClick={() => handleDelete(level.id)}
                                    className="p-2 text-red-600 hover:bg-red-100 rounded-full dark:text-red-400 dark:hover:bg-red-900"
                                >
                                    <Trash2 className="h-5 w-5" />
                                </button>
                            </div>
                        </div>
                    ))}
                </div>
            </div>
        </AdminLayout>
    );
}
