import AdminLayout from "@/Layouts/AdminLayout";
import { Link } from "@inertiajs/react";
import { Pencil, Trash2 } from "lucide-react";

export default function Show({ academicLevel }) {
    return (
        <AdminLayout>
            <div className="max-w-3xl mx-auto">
                <div className="bg-white dark:bg-gray-800 rounded-lg shadow-lg overflow-hidden">
                    {/* Header */}
                    <div className="px-6 py-4 border-b dark:border-gray-700">
                        <h1 className="text-2xl font-bold text-gray-900 dark:text-white">
                            Academic Level Details
                        </h1>
                    </div>

                    {/* Content */}
                    <div className="p-6 space-y-6">
                        <div className="space-y-4">
                            <div>
                                <label className="block text-sm font-medium text-gray-600 dark:text-gray-400">
                                    Name
                                </label>
                                <div className="mt-1 text-lg text-gray-900 dark:text-white">
                                    {academicLevel.name}
                                </div>
                            </div>

                            {/* <div>
                                <label className="block text-sm font-medium text-gray-600 dark:text-gray-400">
                                    Description
                                </label>
                                <div className="mt-1 text-lg text-gray-900 dark:text-white">
                                    {academicLevel.description}
                                </div>
                            </div> */}

                            <div>
                                <label className="block text-sm font-medium text-gray-600 dark:text-gray-400">
                                    Value
                                </label>
                                <div className="mt-1 text-lg text-gray-900 dark:text-white">
                                    {academicLevel.value}
                                </div>
                            </div>
                        </div>
                    </div>

                    {/* Actions */}
                    <div className="px-6 py-4 bg-gray-50 dark:bg-gray-700 flex flex-col sm:flex-row gap-3 sm:justify-end">
                        <Link
                            href={route(
                                "academic-levels.edit",
                                academicLevel.id
                            )}
                            className="inline-flex justify-center items-center px-4 py-2 bg-amber-600 hover:bg-amber-700 text-white rounded-md transition-colors"
                        >
                            <Pencil className="h-4 w-4 mr-2" />
                            Edit
                        </Link>

                        <button className="inline-flex justify-center items-center px-4 py-2 bg-red-600 hover:bg-red-700 text-white rounded-md transition-colors">
                            <Trash2 className="h-4 w-4 mr-2" />
                            Delete
                        </button>
                    </div>
                </div>
            </div>
        </AdminLayout>
    );
}
