import AdminLayout from "@/Layouts/AdminLayout";
import { Users, FileText, Mail, ExternalLink } from "lucide-react";
import { Link, Head } from "@inertiajs/react";
import CleanPagination from "@/Components/CleanPagination";
import DashboardCharts from "@/Components/DashboardCharts";
import SectionContainer from "@/Components/SectionContainer";
import StatsCard from "@/Components/StatsCard";

export default function Dashboard({
    totalClients,
    totalOrders,
    totalWriters,
    chartData,
    clientsOrders,
    totalRevenue,
    clients,
}) {
    // const { clients } = usePage().props;

    return (
        <AdminLayout>
            <Head title="Admin Dashboard" />
            <div className=" dark:bg-gray-900">
                <h1 className="text-2xl font-bold mb-6 dark:text-white">
                    Admin Dashboard
                </h1>

                <div>
                    {/*  Statistics */}
                    <SectionContainer
                        className="bg-gradient-to-r from-orange-200 to-cyan-200 dark:bg-none dark:from-gray-800 dark:to-gray-900"
                        title="Statistics"
                        titleClassName="text-lg font-bold text-gray-900 dark:text-white bg-white bg-opacity-30 dark:bg-gray-900 dark:bg-opacity-40 border-b border-gray-300 dark:border-gray-700"
                    >
                        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                            <StatsCard
                                title="Total Clients"
                                value={totalClients}
                                className="from-blue-500 to-pink-600 dark:from-gray-800 dark:to-gray-900"
                            />

                            {/* Total Orders */}
                            <StatsCard
                                title="Total Orders"
                                value={totalOrders}
                                className="from-green-500 to-blue-600 dark:from-gray-800 dark:to-gray-900"
                            />

                            {/* Total Writers */}
                            <StatsCard
                                title="Total Writers"
                                value={totalWriters}
                                className="from-cyan-500 to-red-600 dark:from-gray-800 dark:to-gray-900"
                            />

                            {/* Total Revenue */}
                            <StatsCard
                                title="Total Revenue"
                                value={`USD: ${totalRevenue.toFixed(2)}`}
                                className="from-yellow-500 to-green-600 dark:from-gray-800 dark:to-gray-900"
                            />
                        </div>
                    </SectionContainer>

                    <SectionContainer
                        className="hidden md:block bg-gradient-to-r from-orange-200 to-cyan-200 dark:bg-none dark:from-gray-800 dark:to-gray-900"
                        title="Client Orders"
                        titleClassName="text-lg font-bold text-gray-900 dark:text-white bg-white bg-opacity-30 dark:bg-gray-900 dark:bg-opacity-40 border-b border-gray-300 dark:border-gray-700"
                    >
                        <div className="hidden md:flex gap-4">
                            <div className="flex flex-col lg:flex-row gap-6 w-full">
                                {/* Left side - Client table */}
                                <div className="w-full ">
                                    <div className="bg-gradient-to-r from-orange-200 to-cyan-200 dark:from-gray-800 dark:bg-gray-800 rounded-lg overflow-hidden shadow-lg">
                                        <table className="min-w-full">
                                            <thead className="bg-indigo-600 dark:bg-gray-700">
                                                <tr>
                                                    <th className="px-6 py-3 text-left text-xs font-medium text-gray-100 dark:text-gray-300 uppercase tracking-wider">
                                                        <div className="flex items-center gap-2">
                                                            <Users
                                                                size={16}
                                                                className="text-blue-100 dark:text-gray-300"
                                                            />
                                                            CLient ID
                                                        </div>
                                                    </th>
                                                    <th className="px-6 py-3 text-left text-xs font-medium text-gray-100 dark:text-gray-300 uppercase tracking-wider">
                                                        <div className="flex items-center gap-2">
                                                            <Users
                                                                size={16}
                                                                className="text-blue-100 dark:text-gray-300"
                                                            />
                                                            Client Name
                                                        </div>
                                                    </th>
                                                    <th className="px-6 py-3 text-left text-xs font-medium text-gray-100 dark:text-gray-300 uppercase tracking-wider">
                                                        <div className="flex items-center gap-2">
                                                            <Mail
                                                                size={16}
                                                                className="text-gray-100 dark:text-gray-300"
                                                            />
                                                            Email
                                                        </div>
                                                    </th>
                                                    <th className="px-6 py-3 text-left text-xs font-medium text-gray-100 dark:text-gray-300 uppercase tracking-wider">
                                                        <div className="flex items-center gap-2">
                                                            <FileText
                                                                size={16}
                                                                className="text-gray-100 dark:text-gray-300"
                                                            />
                                                            Orders Count
                                                        </div>
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody className="divide-y divide-gray-200 dark:divide-gray-600">
                                                {clients.data.map((client) => (
                                                    <tr
                                                        key={client.id}
                                                        className="hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors"
                                                    >
                                                        <td className="px-6 py-4 whitespace-nowrap dark:text-gray-200">
                                                            {client.id}
                                                        </td>
                                                        <td className="px-6 py-4 whitespace-nowrap dark:text-gray-200">
                                                            {client.name}
                                                        </td>
                                                        <td className="px-6 py-4 whitespace-nowrap dark:text-gray-200">
                                                            {client.email}
                                                        </td>
                                                        <td className="px-6 py-4 whitespace-nowrap dark:text-gray-200">
                                                            <Link
                                                                href={route(
                                                                    "admin.user-orders",
                                                                    client.id
                                                                )}
                                                                className="inline-block bg-blue-600 hover:bg-blue-700 text-white px-3 py-1 rounded-full text-sm font-medium transition-colors"
                                                            >
                                                                {
                                                                    client.orders_count
                                                                }{" "}
                                                                Orders
                                                            </Link>
                                                        </td>
                                                    </tr>
                                                ))}
                                            </tbody>
                                        </table>
                                    </div>
                                    <div className="mb-4">
                                        <CleanPagination
                                            links={clients.links}
                                            total={clients.total}
                                            perPage={clients.per_page}
                                            currentPage={clients.current_page}
                                        />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </SectionContainer>

                    {/* Responsive Layout for Small Screens */}
                    <SectionContainer
                        className="md:hidden bg-gradient-to-r from-orange-200 to-cyan-200 dark:bg-none dark:from-gray-800 dark:to-gray-900"
                        title="Client Orders"
                        titleClassName="bg-gradient-to-r from-blue-900 to-cyan-500 dark:bg-none dark:bg-slate-700 dark:text-gray-200 font-semibold bg-white bg-opacity-30 dark:bg-gray-900 dark:bg-opacity-40 border-b border-gray-300 dark:border-gray-700"
                    >
                        {" "}
                        <div className="md:hidden grid grid-cols-1 gap-4 mt-2">
                            {clients.data.map((client) => (
                                <div
                                    key={client.id}
                                    className="bg-gradient-to-r from-orange-200 to-cyan-20 dark:from-gray-800 dark:bg-gray-800 p-4 rounded-lg shadow-md"
                                >
                                    <div className="flex items-center gap-2 mb-2">
                                        <Users
                                            className="text-blue-600 dark:text-blue-400"
                                            size={20}
                                        />
                                        <h3 className="font-semibold dark:text-white">
                                            {client.name}
                                        </h3>
                                    </div>
                                    <div className="flex items-center gap-2 mb-2 text-gray-600 dark:text-gray-300">
                                        <Mail size={18} />
                                        <span className="truncate max-w-[200px]">
                                            {client.email}
                                        </span>
                                    </div>
                                    <div className="flex items-center gap-2 text-center text-gray-100 dark:text-gray-300 bg-indigo-700 dark:bg-gray-700 p-2 rounded-md">
                                        <ExternalLink size={18} />
                                        <Link
                                            href={route(
                                                "admin.user-orders",
                                                client.id
                                            )}
                                            className="hover:text-blue-600 transition-colors"
                                        >
                                            {client.orders_count} Orders
                                        </Link>
                                    </div>
                                </div>
                            ))}
                            <div className="mt-4">
                                <CleanPagination
                                    links={clients.links}
                                    total={clients.total}
                                    perPage={clients.per_page}
                                    currentPage={clients.current_page}
                                />
                            </div>
                        </div>
                    </SectionContainer>
                </div>
                <SectionContainer
                    className="bg-gradient-to-r from-orange-200 to-cyan-200 dark:bg-none dark:from-gray-800 dark:to-gray-900"
                    title="Visualize Data"
                    titleClassName="text-lg font-bold text-gray-900 dark:text-white bg-white bg-opacity-30 dark:bg-gray-900 dark:bg-opacity-40 border-b border-gray-300 dark:border-gray-700"
                >
                    <div className="mt-6">
                        <DashboardCharts
                            chartData={chartData}
                            clientsOrders={clientsOrders}
                        />
                    </div>
                </SectionContainer>
            </div>
        </AdminLayout>
    );
}
