import { FormInput } from "@/Components/ui/FormInput";
import { NormalSelect } from "@/Components/ui/NormalSelect";
import AdminLayout from "@/Layouts/AdminLayout";
import { Link, useForm } from "@inertiajs/react";

export default function Create() {
    const { data, setData, post, processing, errors } = useForm({
        name: "",
        email: "",
        user_type: "",
        status: "",
        password: "",
        password_confirmation: "",
    });

    console.log(data);
    const handleSubmit = (e) => {
        e.preventDefault();
        post(route("admin.users.store"));
    };

    return (
        <AdminLayout>
            <div className="max-w-2xl mx-auto">
                <div className="bg-gradient-to-r from-orange-200 to-cyan-200 dark:bg-none dark:bg-gray-800 rounded-lg shadow-lg">
                    <div className="px-6 py-4 border-b dark:border-gray-700 bg-gradient-to-r from-blue-900 to-cyan-500 rounded-t-lg dark:bg-none dark:bg-gray-700">
                        <h1 className="text-md lg:text-xl  font-bold text-gray-100 dark:text-white">
                            Add User
                        </h1>
                    </div>

                    <form onSubmit={handleSubmit} className="p-6 space-y-6">
                        <div className="col-span-full">
                            <FormInput
                                id="name"
                                name="name"
                                label="Full Name"
                                value={data.name}
                                setData={setData}
                                error={errors.name}
                                placeholder="Enter Fullname"
                                className="dark:text-gray-200"
                                required
                            />
                        </div>

                        <div className="col-span-full">
                            <FormInput
                                id="email"
                                type="email"
                                name="email"
                                label="Email"
                                value={data.email}
                                setData={setData}
                                error={errors.email}
                                placeholder="Enter Email"
                                className="dark:text-gray-200"
                                required
                            />
                        </div>
                        <div className="col-span-full">
                            <FormInput
                                id="password"
                                type="password"
                                name="password"
                                label="Password"
                                value={data.password}
                                setData={setData}
                                error={errors.password}
                                placeholder="Enter Password"
                                className="dark:text-gray-200"
                                required
                            />
                        </div>

                        <div className="col-span-full">
                            <FormInput
                                id="password_confirmation"
                                type="password"
                                name="password_confirmation"
                                label="Confirm Password"
                                value={data.password_confirmation}
                                setData={setData}
                                error={errors.password_confirmation}
                                placeholder="Confirm Password"
                                className="dark:text-gray-200"
                                required
                            />
                        </div>

                        <div>
                            <NormalSelect
                                id="user_type"
                                name="user_type"
                                label="User Type"
                                value={data.user_type}
                                setData={setData}
                                options={[
                                    {
                                        id: 1,
                                        value: "client",
                                        name: "Client",
                                    },
                                    {
                                        id: 2,
                                        value: "admin",
                                        name: "Admin",
                                    },
                                    {
                                        id: 3,
                                        value: "writer",
                                        name: "Writer",
                                    },
                                ]}
                                error={errors.user_type}
                                placeholder="Select User Type"
                                className="dark:text-gray-200"
                            />
                        </div>

                        <div>
                            <NormalSelect
                                id="status"
                                name="status"
                                label="Status"
                                value={data.status}
                                setData={setData}
                                options={[
                                    {
                                        id: 1,
                                        value: "active",
                                        name: "Active",
                                    },
                                    {
                                        id: 2,
                                        value: "inactive",
                                        name: "Inactive",
                                    },
                                ]}
                                error={errors.status}
                                placeholder="Select Status"
                                className="dark:text-gray-200"
                            />
                        </div>

                        <div className="flex justify-end gap-3">
                            <Link
                                href={route("admin.users.index")}
                                className="px-4 py-2 bg-gray-500 text-white rounded-md hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2"
                            >
                                Cancel
                            </Link>
                            <button
                                type="submit"
                                disabled={processing}
                                className="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 disabled:opacity-50"
                            >
                                Create
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </AdminLayout>
    );
}
